/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.supercontour;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.application.supercontour.SuperContour;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class SuperContoursSpan
implements Comparable<SuperContoursSpan> {
    private List<SuperContour> contours = new ArrayList<SuperContour>();
    private Function<Double, Double> approx;

    public void add(SuperContour superContour) {
        this.contours.add(superContour);
    }

    public List<SuperContour> getContours() {
        return this.contours;
    }

    public Function<Double, Double> getApprox() {
        return this.approx != null ? this.approx : (this.approx = this.computeApprox());
    }

    private Function<Double, Double> computeApprox() {
        PolynomialSplineFunction psf = new LinearInterpolator().interpolate(this.contours.stream().mapToDouble(sc -> sc.center.x).toArray(), this.contours.stream().mapToDouble(sc -> sc.center.y).toArray());
        return x -> psf.isValidPoint(x.doubleValue()) ? Double.valueOf(psf.value(x.doubleValue())) : null;
    }

    @Override
    public int compareTo(SuperContoursSpan span) {
        return Double.compare(this.getContours().stream().mapToDouble(c -> c.center.y).average().getAsDouble(), span.getContours().stream().mapToDouble(c -> c.center.y).average().getAsDouble());
    }

    public static List<SuperContour> detectSuperContours(double minArea, Mat mask) {
        ArrayList contours = new ArrayList();
        Mat hierarchy = new Mat();
        Imgproc.findContours((Mat)mask, contours, (Mat)hierarchy, (int)3, (int)1);
        ArrayList<SuperContour> result = new ArrayList<SuperContour>();
        int row = 0;
        for (MatOfPoint contour : contours) {
            MatOfPoint fatherWrapper;
            double[] indexes = hierarchy.get(0, row);
            double fatherIndex = indexes[3];
            MatOfPoint matOfPoint = fatherWrapper = fatherIndex != -1.0 ? (MatOfPoint)contours.get((int)fatherIndex) : null;
            if (Imgproc.contourArea((Mat)contour) > minArea && Imgproc.boundingRect((MatOfPoint)contour).area() < 10000.0) {
                if (fatherWrapper != null) {
                    if (SuperContoursSpan.countWhitePixels(contour, Imgproc.boundingRect((MatOfPoint)contour), mask) != 0) {
                        result.add(new SuperContour(contour));
                    }
                } else {
                    result.add(new SuperContour(contour));
                }
            }
            ++row;
        }
        return result;
    }

    public static int countWhitePixels(MatOfPoint contour, Rect rect, Mat img) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(0.0), (int)1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        int white = 0;
        for (int row = 0; row < mask.rows(); ++row) {
            for (int col = 0; col < mask.cols(); ++col) {
                if (mask.get(row, col)[0] == 0.0 || img.get(row + (int)rect.tl().y, col + (int)rect.tl().x)[0] == 0.0) continue;
                ++white;
            }
        }
        return white;
    }

    public static List<SuperContoursSpan> assembleContours(List<SuperContour> superContours, Predicate<SuperContour> contoursFilter, double maxScore, double coeffDeltaAngle, double minSpanWidth) {
        superContours = superContours.stream().filter(contoursFilter).collect(Collectors.toList());
        Collections.sort(superContours);
        ArrayList<Edge> candidateEdges = new ArrayList<Edge>();
        for (int i = 0; i < superContours.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Edge edge = SuperContoursSpan.generateEdge(superContours.get(i), superContours.get(j), maxScore, coeffDeltaAngle);
                if (edge == null) continue;
                candidateEdges.add(edge);
            }
        }
        Collections.sort(candidateEdges);
        for (Edge edge : candidateEdges) {
            if (edge.getC1().succ != null || edge.getC2().pred != null) continue;
            edge.getC1().succ = edge.getC2();
            edge.getC2().pred = edge.getC1();
        }
        ArrayList<SuperContoursSpan> spans = new ArrayList<SuperContoursSpan>();
        while (!superContours.isEmpty()) {
            SuperContour contour = superContours.get(0);
            while (contour.pred != null) {
                contour = contour.pred;
            }
            SuperContoursSpan curSpan = new SuperContoursSpan();
            double width = 0.0;
            while (contour != null) {
                superContours.remove(contour);
                curSpan.add(contour);
                width += contour.lxmax - contour.lxmin;
                contour = contour.succ;
            }
            if (!(width > minSpanWidth) || curSpan.getContours().size() <= 1) continue;
            spans.add(curSpan);
        }
        Collections.sort(spans);
        return spans;
    }

    private static Edge generateEdge(SuperContour c1, SuperContour c2, double maxScore, double coeffDeltaAngle) {
        if (c1.compareTo(c2) > 0) {
            SuperContour tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        double minDist = Double.MAX_VALUE;
        double c1Angle = 0.0;
        double c2Angle = 0.0;
        for (Point c1Point : new Point[]{c1.top, c1.right, c1.left, c1.bottom}) {
            for (Point c2Point : new Point[]{c2.top, c2.right, c2.left, c2.bottom}) {
                double dist = SuperContoursSpan.euclid(c1Point, c2Point);
                if (!(dist < minDist)) continue;
                minDist = dist;
                c1Angle = SuperContoursSpan.toDemiPis(c1Point == c1.top || c1Point == c1.bottom ? c1.antiAngle : c1.angle);
                c2Angle = SuperContoursSpan.toDemiPis(c2Point == c2.top || c2Point == c2.bottom ? c2.antiAngle : c2.angle);
            }
        }
        double centersAngle = SuperContoursSpan.toDemiPis(Math.atan2(c2.center.y - c1.center.y, c2.center.x - c1.center.x));
        if (Math.abs(centersAngle) * 180.0 / Math.PI > 45.0) {
            return null;
        }
        double deltaAngle = Math.max(SuperContoursSpan.toZeroDemiPi(centersAngle - c1Angle), SuperContoursSpan.toZeroDemiPi(centersAngle - c2Angle));
        if (minDist * Math.sin(deltaAngle) > 8.0) {
            return null;
        }
        double score = minDist + minDist * Math.sin(deltaAngle) * coeffDeltaAngle;
        return score < maxScore ? new Edge(score, c1, c2) : null;
    }

    private static double toZeroDemiPi(double diff) {
        while (diff > 1.5707963267948966) {
            diff -= Math.PI;
        }
        while (diff < -1.5707963267948966) {
            diff += Math.PI;
        }
        return Math.abs(diff);
    }

    private static double toDemiPis(double diff) {
        while (diff > 1.5707963267948966) {
            diff -= Math.PI;
        }
        while (diff < -1.5707963267948966) {
            diff += Math.PI;
        }
        return diff;
    }

    private static double euclid(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    public static class Edge
    implements Comparable<Edge> {
        private final double score;
        private final SuperContour c1;
        private final SuperContour c2;

        public Edge(double score, SuperContour c1, SuperContour c2) {
            this.c1 = c1;
            this.c2 = c2;
            this.score = score;
        }

        @Override
        public int compareTo(Edge edge) {
            return Double.compare(this.score, edge.getScore());
        }

        private double getScore() {
            return this.score;
        }

        public SuperContour getC1() {
            return this.c1;
        }

        public SuperContour getC2() {
            return this.c2;
        }
    }
}

