/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.cv.application.mesh.Mesh;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class ReverseMap {
    private final Map<Range[], Mat> reverseMap = new HashMap<Range[], Mat>();

    public ReverseMap(Mesh mesh, int halfWidth, int halfHeight, Point imageCenter, double[] widths, double[] heights) {
        int j;
        double x;
        int i;
        double y = imageCenter.y;
        for (i = 0; i < halfHeight; ++i) {
            x = imageCenter.x;
            for (j = 0; j < halfWidth; ++j) {
                this.putReverse(mesh.getCell(i, j), x, y, widths[j + halfWidth], heights[i + halfHeight]);
                x += widths[j + halfWidth];
            }
            x = imageCenter.x;
            for (j = -1; j >= -halfWidth; --j) {
                this.putReverse(mesh.getCell(i, j), x -= widths[j + halfWidth], y, widths[j + halfWidth], heights[i + halfHeight]);
            }
            y += heights[i + halfHeight];
        }
        y = imageCenter.y;
        for (i = -1; i >= -halfHeight; --i) {
            y -= heights[i + halfHeight];
            x = imageCenter.x;
            for (j = 0; j < halfWidth; ++j) {
                this.putReverse(mesh.getCell(i, j), x, y, widths[j + halfWidth], heights[i + halfHeight]);
                x += widths[j + halfWidth];
            }
            x = imageCenter.x;
            for (j = -1; j >= -halfWidth; --j) {
                this.putReverse(mesh.getCell(i, j), x -= widths[j + halfWidth], y, widths[j + halfWidth], heights[i + halfHeight]);
            }
        }
    }

    public Point reverse(Point point) {
        Mat homography = this.reverseMap.entrySet().stream().filter(entry -> (double)((Range[])entry.getKey())[0].start <= point.x && (double)((Range[])entry.getKey())[0].end >= point.x && (double)((Range[])entry.getKey())[1].start <= point.y && (double)((Range[])entry.getKey())[1].end >= point.y).map(entry -> (Mat)entry.getValue()).findFirst().get();
        return this.transform(Arrays.asList(point), homography).get(0);
    }

    private List<Point> transform(List<Point> originals, Mat homography) {
        Mat original = Converters.vector_Point2d_to_Mat(originals);
        Mat results = new Mat();
        Core.perspectiveTransform((Mat)original, (Mat)results, (Mat)homography);
        ArrayList<Point> res = new ArrayList<Point>();
        Converters.Mat_to_vector_Point2d((Mat)results, res);
        return res;
    }

    public void putReverse(Point[] polygon, double x, double y, double rectWidth, double rectHeight) {
        Point dewarpedTopLeft = new Point(x, y);
        Point dewarpedTopRight = new Point(x + rectWidth, y);
        Point dewarpedBottomRight = new Point(x + rectWidth, y + rectHeight);
        Point dewarpedBottomLeft = new Point(x, y + rectHeight);
        Mat homography = Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(polygon), (Mat)new MatOfPoint2f(new Point[]{dewarpedTopLeft, dewarpedTopRight, dewarpedBottomRight, dewarpedBottomLeft}));
        this.reverseMap.put(new Range[]{new Range((int)Math.round(x), (int)Math.round(x + rectWidth)), new Range((int)Math.round(y), (int)Math.round(y + rectHeight))}, homography.inv());
    }
}

