/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.GSCapture;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class GSVideoCapture
implements GSCapture {
    private final VideoCapture videoCapture;
    private final Size size;
    private final Size resize;

    GSVideoCapture(String url, Size size, Size resize) {
        this.size = size;
        this.resize = resize;
        this.videoCapture = new VideoCapture(url);
        this.videoCapture.set(3, size.width);
        this.videoCapture.set(4, size.height);
    }

    public GSVideoCapture(int index, Size size, Size resize) {
        this.size = size;
        this.resize = resize;
        this.videoCapture = new VideoCapture(index);
        this.videoCapture.set(3, size.width);
        this.videoCapture.set(4, size.height);
    }

    @Override
    public Size getResize() {
        return this.resize;
    }

    @Override
    public Img read() {
        Mat frameMat = new Mat();
        boolean result = this.videoCapture.read(frameMat);
        if (!result) {
            throw new IllegalStateException("Unable to read camera");
        }
        Imgproc.resize((Mat)frameMat, (Mat)frameMat, (Size)this.resize, (double)1.0, (double)1.0, (int)1);
        return new Img(frameMat, false);
    }

    @Override
    public void release() {
        this.videoCapture.release();
    }
}

