/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.genericsystem.cv.Ocr;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class App
extends Application {
    private final String sourceDirectoryPath = "pdf";
    private final String targetDirectoryPath = "png";
    private final String adjustedDirectoryPath = "ajusted";
    private final double displayWidth = 200.0;
    private final double canyThreshold1 = 12.0;
    private final double canyThreshold2 = 90.0;
    private final double ratio = 2.0;
    private final boolean landscape = true;
    private final double[] zone = new double[]{0.32075471698113206, 0.7547169811320755, 0.18918918918918917, 0.27027027027027023};

    public static void main(String[] args) {
        App.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        GridPane gridPane = new GridPane();
        int[] row = new int[]{0};
        Tools.classImgsStream("png").forEach(img -> {
            int column = 0;
            gridPane.add((Node)this.getImageViewFromMat(img.getSrc()), column++, row[0]);
            Mat grayed = this.gray(img.getSrc());
            gridPane.add((Node)this.getImageViewFromMat(grayed), column++, row[0]);
            Mat canny = this.canny(grayed, 12.0);
            gridPane.add((Node)this.getImageViewFromMat(canny), column++, row[0]);
            Mat blured = canny.clone();
            Imgproc.dilate((Mat)blured, (Mat)blured, (Mat)Imgproc.getStructuringElement((int)1, (Size)new Size(5.0, 5.0)));
            gridPane.add((Node)this.getImageViewFromMat(blured), column++, row[0]);
            MatOfPoint2f contour = this.getContour(blured);
            Mat contoured = this.drawContour(this.colorize(blured), contour);
            gridPane.add((Node)this.getImageViewFromMat(contoured), column++, row[0]);
            Mat adjusted = this.transform(img.getSrc(), contour);
            gridPane.add((Node)this.getImageViewFromMat(adjusted), column++, row[0]);
            String hocrString = Ocr.doWork(adjusted);
            gridPane.add((Node)new TextArea(hocrString), column++, row[0]);
            Mat adjustedGrayed = this.gray(adjusted);
            gridPane.add((Node)this.getImageViewFromMat(adjustedGrayed), column++, row[0]);
            Mat adjustedCanny = this.canny(adjustedGrayed, 90.0);
            Imgproc.dilate((Mat)adjustedCanny, (Mat)adjustedCanny, (Mat)Imgproc.getStructuringElement((int)1, (Size)new Size(12.0, 12.0)));
            gridPane.add((Node)this.getImageViewFromMat(adjustedCanny), column++, row[0]);
            Mat adjustedBlured = this.gaussianBlur(adjustedCanny);
            gridPane.add((Node)this.getImageViewFromMat(adjustedCanny), column++, row[0]);
            ArrayList contours = new ArrayList();
            Imgproc.findContours((Mat)adjustedBlured, contours, (Mat)new Mat(), (int)1, (int)2);
            Mat coutoured = adjusted.clone();
            for (int i = 0; i < contours.size(); ++i) {
                if (!(((MatOfPoint)contours.get(i)).size().area() > 160.0)) continue;
                MatOfPoint2f contour2f = new MatOfPoint2f(((MatOfPoint)contours.get(i)).toArray());
                MatOfPoint2f approxCurve = new MatOfPoint2f();
                Imgproc.approxPolyDP((MatOfPoint2f)contour2f, (MatOfPoint2f)approxCurve, (double)(Imgproc.arcLength((MatOfPoint2f)contour2f, (boolean)true) * 0.02), (boolean)true);
                Rect rect = Imgproc.boundingRect((MatOfPoint)new MatOfPoint(approxCurve.toArray()));
                if (rect.height >= 80 || rect.width <= 120) continue;
                Imgproc.rectangle((Mat)coutoured, (Point)rect.tl(), (Point)rect.br(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)5);
            }
            gridPane.add((Node)this.getImageViewFromMat(coutoured), column++, row[0]);
            Point pt1 = new Point(this.zone[0] * (double)adjusted.width(), this.zone[2] * (double)adjusted.height());
            Point pt2 = new Point(this.zone[1] * (double)adjusted.width(), this.zone[3] * (double)adjusted.height());
            Rect rect = new Rect(pt1, pt2);
            Mat templated = adjusted.clone();
            Imgproc.rectangle((Mat)templated, (Point)rect.br(), (Point)rect.tl(), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)20);
            gridPane.add((Node)this.getImageViewFromMat(templated), column++, row[0]);
            Mat ocrZone = new Mat(adjusted, rect);
            gridPane.add((Node)this.getImageViewFromMat(ocrZone), column++, row[0]);
            String zoneOcr = Ocr.doWork(ocrZone);
            gridPane.add((Node)new TextArea(zoneOcr), column++, row[0]);
            row[0] = row[0] + 1;
        });
        Scene scene = new Scene((Parent)new Group());
        stage.setTitle("Generic System OCR");
        ScrollPane scrollPane = new ScrollPane((Node)gridPane);
        scrollPane.setFitToHeight(true);
        VBox root = new VBox(new Node[]{scrollPane});
        scene.setRoot((Parent)root);
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                try {
                    App.this.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        stage.setScene(scene);
        stage.show();
    }

    private Mat transform(Mat src, MatOfPoint2f contour2f) {
        double height;
        boolean toReverse;
        Mat target = new Mat();
        List<Point> list = Arrays.asList(contour2f.toArray());
        double width = Math.max(Math.sqrt(Math.pow(list.get((int)0).x - list.get((int)1).x, 2.0) + Math.pow(list.get((int)0).y - list.get((int)1).y, 2.0)), Math.sqrt(Math.pow(list.get((int)2).x - list.get((int)3).x, 2.0) + Math.pow(list.get((int)2).y - list.get((int)3).y, 2.0)));
        boolean bl = toReverse = width < (height = Math.max(Math.sqrt(Math.pow(list.get((int)1).x - list.get((int)2).x, 2.0) + Math.pow(list.get((int)1).y - list.get((int)2).y, 2.0)), Math.sqrt(Math.pow(list.get((int)3).x - list.get((int)0).x, 2.0) + Math.pow(list.get((int)3).y - list.get((int)0).y, 2.0))));
        if (toReverse) {
            System.out.println("inversion width height");
            double tmp = width;
            width = height;
            height = tmp;
        }
        LinkedList<Point> targets = new LinkedList<Point>(Arrays.asList(new Point(width, 0.0), new Point(0.0, 0.0), new Point(0.0, height), new Point(width, height)));
        if (toReverse) {
            Point first = (Point)targets.get(0);
            targets.remove(0);
            targets.add(first);
        }
        Imgproc.warpPerspective((Mat)src, (Mat)target, (Mat)Imgproc.getPerspectiveTransform((Mat)contour2f, (Mat)Converters.vector_Point2f_to_Mat(targets)), (Size)new Size(width, height), (int)2);
        return target;
    }

    private ImageView getImageViewFromMat(Mat src) {
        Mat target = new Mat();
        Imgproc.resize((Mat)src, (Mat)target, (Size)new Size(200.0, Math.floor(200.0 / (double)src.width() * (double)src.height())));
        MatOfByte buffer = new MatOfByte();
        Imgcodecs.imencode((String)".png", (Mat)target, (MatOfByte)buffer);
        ImageView imageView = new ImageView(new Image((InputStream)new ByteArrayInputStream(buffer.toArray())));
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(200.0);
        return imageView;
    }

    static File createFileFromMat(Mat mat, String fileName, String directoryPath) {
        File destinationDirectory = new File(directoryPath);
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdir();
        }
        File dest = new File(destinationDirectory, fileName);
        MatOfByte bytesBuffer = new MatOfByte();
        Imgcodecs.imencode((String)".png", (Mat)mat, (MatOfByte)bytesBuffer);
        try (ByteArrayInputStream sourceFile = new ByteArrayInputStream(bytesBuffer.toArray());
             FileOutputStream destinationFile = new FileOutputStream(dest);){
            int nbLecture;
            byte[] buffer = new byte[524288];
            while ((nbLecture = sourceFile.read(buffer)) != -1) {
                ((OutputStream)destinationFile).write(buffer, 0, nbLecture);
            }
            destinationFile.flush();
            ((OutputStream)destinationFile).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dest;
    }

    private Mat read(File file) {
        return Imgcodecs.imread((String)file.getPath());
    }

    private Mat gray(Mat src) {
        Mat target = new Mat();
        Imgproc.cvtColor((Mat)src, (Mat)target, (int)6);
        return target;
    }

    private Mat canny(Mat src, double thresHold) {
        Mat target = new Mat();
        Imgproc.Canny((Mat)src, (Mat)target, (double)thresHold, (double)(thresHold * 2.0), (int)3, (boolean)true);
        return target;
    }

    private Mat gaussianBlur(Mat src) {
        Mat target = new Mat();
        Imgproc.GaussianBlur((Mat)src, (Mat)target, (Size)new Size(5.0, 5.0), (double)0.0);
        return target;
    }

    private MatOfPoint2f getContour(Mat src) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)src, contours, (Mat)new Mat(), (int)0, (int)2);
        Collections.sort(contours, (c1, c2) -> Double.compare(Imgproc.contourArea((Mat)c2), Imgproc.contourArea((Mat)c1)));
        MatOfPoint2f approxCurve = new MatOfPoint2f();
        for (MatOfPoint contour : contours) {
            MatOfPoint2f contour2F = new MatOfPoint2f(contour.toArray());
            Imgproc.approxPolyDP((MatOfPoint2f)contour2F, (MatOfPoint2f)approxCurve, (double)(Imgproc.arcLength((MatOfPoint2f)contour2F, (boolean)true) * 0.02), (boolean)true);
            if (approxCurve.total() != 4L) continue;
            break;
        }
        return approxCurve;
    }

    private Mat colorize(Mat src) {
        Mat target = new Mat();
        Imgproc.cvtColor((Mat)src, (Mat)target, (int)8);
        return target;
    }

    private Mat drawContour(Mat src, MatOfPoint2f contour2f) {
        Mat target = src.clone();
        MatOfPoint contour = new MatOfPoint();
        contour2f.convertTo((Mat)contour, 4);
        Imgproc.drawContours((Mat)target, Arrays.asList(contour), (int)-1, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)20);
        return target;
    }

    static {
        NativeLibraryLoader.load();
    }
}

