/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.text.TextDetectorCNN;
import org.opencv.utils.Converters;

public class CNNTextDetector
extends AbstractApp {
    private final GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};
    private final TextDetectorCNN cnn = TextDetectorCNN.create((String)"resources/textbox.prototxt", (String)"resources/TextBoxes_icdar13.caffemodel");

    public static void main(String[] args) {
        CNNTextDetector.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.0;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
        }
        Image[] images = new Image[3];
        long ref = System.currentTimeMillis();
        long ref2 = System.currentTimeMillis();
        MatOfRect mor = new MatOfRect();
        MatOfFloat mof = new MatOfFloat();
        this.cnn.detect(this.frame.getSrc(), mor, mof);
        ArrayList rects = new ArrayList();
        Converters.Mat_to_vector_Rect((Mat)mor, rects);
        ArrayList confidences = new ArrayList();
        Converters.Mat_to_vector_float((Mat)mof, confidences);
        Mat display = this.frame.getSrc().clone();
        for (int rectIndex = 0; rectIndex < rects.size(); ++rectIndex) {
            if ((double)((Float)confidences.get(rectIndex)).floatValue() >= 0.1) {
                Imgproc.rectangle((Mat)display, (Rect)((Rect)rects.get(rectIndex)), (Scalar)new Scalar(0.0, 255.0, 0.0));
            }
            System.out.println("confidence : " + confidences.get(rectIndex) + " " + rects.get(rectIndex));
        }
        images[0] = new Img(display, false).toJfxImage();
        ref = this.trace("cnn detection", ref);
        ref2 = this.trace("total", ref2);
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

