/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import org.genericsystem.cv.application.Interpolator;
import org.genericsystem.cv.application.mesh.CandidatePoints;
import org.genericsystem.cv.application.mesh.Mesh;
import org.genericsystem.cv.application.mesh.Mesh3D;
import org.genericsystem.cv.application.mesh.Points;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshManager {
    private static final Logger logger = LoggerFactory.getLogger(MeshManager.class);
    private final double deltaX;
    private final double deltaY;
    private final int xBorder;
    private final int yBorder;
    private final Size frameSize;
    private final Size enlargedSize;
    private final int halfWidth;
    private final int halfHeight;
    private final Interpolator interpolator;
    private final double focale;
    private Points points;
    private Mesh mesh;
    private Mesh3D mesh3D;
    private Mesh reverseMesh;

    public MeshManager(int halfWidth, int halfHeight, Interpolator interpolatorFHT, Size frameSize, double focale) {
        this(halfWidth, halfHeight, interpolatorFHT, frameSize.width / (double)(2 * halfWidth), frameSize.height / (double)(2 * halfHeight), frameSize, focale);
    }

    public MeshManager(int halfWidth, int halfHeight, Interpolator interpolator, double deltaX, double deltaY, Size frameSize, double focale) {
        this.frameSize = frameSize;
        this.focale = focale;
        this.interpolator = interpolator;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.xBorder = 2 * (int)deltaX;
        this.yBorder = 2 * (int)deltaY;
        this.enlargedSize = new Size(frameSize.width + (double)(2 * this.getxBorder()), frameSize.height + (double)(2 * this.yBorder));
        this.halfHeight = halfHeight;
        this.halfWidth = halfWidth;
    }

    public Points getPoints() {
        return this.points != null ? this.points : (this.points = new CandidatePoints(new Point(this.enlargedSize.width / 2.0, this.enlargedSize.height / 2.0), this.halfWidth, this.halfHeight, this.deltaX, this.deltaY, this.getxBorder(), this.yBorder, this.interpolator));
    }

    private Mesh getMesh() {
        return this.mesh != null ? this.mesh : (this.mesh = new Mesh(this.getPoints(), this.halfWidth, this.halfHeight));
    }

    private Mesh3D getMesh3D() {
        return this.mesh3D != null ? this.mesh3D : (this.mesh3D = new Mesh3D(this.getMesh(), this.enlargedSize, this.focale));
    }

    public Mesh getReverseMesh() {
        return this.reverseMesh != null ? this.reverseMesh : (this.reverseMesh = this.getMesh3D().reverseMesh());
    }

    public Mat draw(Mat image, Scalar meshColor, Scalar ptsColor) {
        Mat enlarged = new Mat();
        Core.copyMakeBorder((Mat)image, (Mat)enlarged, (int)this.yBorder, (int)this.yBorder, (int)this.getxBorder(), (int)this.getxBorder(), (int)1);
        this.getMesh().draw(enlarged, meshColor, ptsColor);
        this.getReverseMesh().draw(enlarged, new Scalar(0.0, 0.0, 255.0), new Scalar(255.0, 0.0, 0.0));
        return enlarged;
    }

    public Mat drawReverse(Mat image, Scalar meshColor, Scalar ptsColor) {
        Mat enlarged = this.buildEnlarged(image);
        this.getReverseMesh().draw(enlarged, meshColor, ptsColor);
        return enlarged;
    }

    public Mat buildEnlarged(Mat image) {
        Mat enlarged = new Mat();
        Core.copyMakeBorder((Mat)image, (Mat)enlarged, (int)this.yBorder, (int)this.yBorder, (int)this.getxBorder(), (int)this.getxBorder(), (int)1);
        return enlarged;
    }

    public Mat dewarpReverse(Mat image) {
        return this.getReverseMesh().dewarp(this.buildEnlarged(image), image.size());
    }

    private Size getOriginalSize() {
        return this.frameSize;
    }

    public Mat draw3Dsurface(Scalar colorStart, Scalar colorEnd) {
        return this.getMesh3D().draw3Dsurface(colorStart, colorEnd, this.getOriginalSize());
    }

    public Mat dewarp(Mat image) {
        Mat enlarged = new Mat();
        Core.copyMakeBorder((Mat)image, (Mat)enlarged, (int)this.yBorder, (int)this.yBorder, (int)this.getxBorder(), (int)this.getxBorder(), (int)1);
        return this.getMesh().dewarp(enlarged, this.getOriginalSize());
    }

    public Mat dewarp3D(Mat image) {
        Mat enlarged = new Mat();
        Core.copyMakeBorder((Mat)image, (Mat)enlarged, (int)this.yBorder, (int)this.yBorder, (int)this.getxBorder(), (int)this.getxBorder(), (int)1);
        return this.getMesh3D().dewarp(enlarged, this.getOriginalSize());
    }

    public int getxBorder() {
        return this.xBorder;
    }

    public int getyBorder() {
        return this.yBorder;
    }
}

