/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class VanishingPointsDetector {
    private static final int MODE_LS = 0;
    private static final int MODE_NIETO = 1;
    private Mat li = new Mat(3, 1, 5);
    private boolean verbose;
    private float width;
    private float height;
    private int mode;
    private float epsilon = 1.0E-6f;
    private static float T_noise_squared = 0.03246f;
    private static int min_iters = 5;
    int minimal_sample_set_dimension = 2;
    private Mat K;
    private Mat Li;
    private Mat Mi;
    private Mat Lengths;
    int[] CS_idx;

    public VanishingPointsDetector(Size imSize, boolean verbose) {
        this.verbose = verbose;
        this.width = (float)imSize.width;
        this.height = (float)imSize.height;
        this.verbose = verbose;
        this.mode = 0;
        this.K = new Mat(3, 3, 5, new Scalar(0.0));
        this.K.put(0, 0, new float[]{this.width});
        this.K.put(0, 2, new float[]{this.width / 2.0f});
        this.K.put(1, 1, new float[]{this.height});
        this.K.put(1, 2, new float[]{this.height / 2.0f});
        this.K.put(2, 2, new float[]{1.0f});
    }

    private void fillDataContainers(List<Point[]> lineSegments) {
        int numLines = lineSegments.size();
        if (this.verbose) {
            System.out.println("Line segments: " + numLines);
        }
        this.Li = new Mat(numLines, 3, 5);
        this.Mi = new Mat(numLines, 3, 5);
        this.Lengths = new Mat(numLines, numLines, 5, new Scalar(0.0));
        double sum_lengths = 0.0;
        Mat a = new Mat(3, 1, 5);
        Mat b = new Mat(3, 1, 5);
        for (int i = 0; i < numLines; ++i) {
            Point p1 = lineSegments.get(i)[0];
            Point p2 = lineSegments.get(i)[1];
            a.put(0, 0, new float[]{Double.valueOf(p1.x).floatValue()});
            a.put(1, 0, new float[]{Double.valueOf(p1.y).floatValue()});
            a.put(2, 0, new float[]{Double.valueOf(1.0).floatValue()});
            b.put(0, 0, new float[]{Double.valueOf(p2.x).floatValue()});
            b.put(1, 0, new float[]{Double.valueOf(p2.y).floatValue()});
            b.put(2, 0, new float[]{Double.valueOf(1.0).floatValue()});
            Mat c = new Mat(3, 1, 5);
            if (this.mode == 1) {
                Core.addWeighted((Mat)a, (double)0.5, (Mat)b, (double)0.5, (double)0.0, (Mat)c);
            }
            double length = Math.sqrt((b.get(0, 0)[0] - a.get(0, 0)[0]) * (b.get(0, 0)[0] - a.get(0, 0)[0]) + (b.get(1, 0)[0] - a.get(1, 0)[0]) * (b.get(1, 0)[0] - a.get(1, 0)[0]));
            sum_lengths += length;
            this.Lengths.put(i, i, new float[]{(float)length});
            Mat an = new Mat(3, 1, 5);
            Mat bn = new Mat(3, 1, 5);
            if (this.mode == 0) {
                Core.gemm((Mat)this.K.inv(), (Mat)a, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)an);
                Core.gemm((Mat)this.K.inv(), (Mat)b, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)bn);
            } else {
                an = a;
                bn = b;
            }
            this.li = an.cross(bn);
            Core.normalize((Mat)this.li, (Mat)this.li);
            this.Li.put(i, 0, this.li.get(0, 0));
            this.Li.put(i, 1, this.li.get(1, 0));
            this.Li.put(i, 2, this.li.get(2, 0));
            if (this.mode != 1) continue;
            this.Mi.put(i, 0, c.get(0, 0));
            this.Mi.put(i, 1, c.get(1, 0));
            this.Mi.put(i, 2, c.get(2, 0));
        }
        Core.multiply((Mat)this.Lengths, (Scalar)new Scalar(1.0 / sum_lengths), (Mat)this.Lengths);
    }

    public void multipleVPEstimation(List<Point[]> lineSegments, List<List<Point[]>> lineSegmentsClusters, List<Integer> numInliers, List<Mat> vps, int numVps) {
        ArrayList<Point[]> lineSegmentsCopy = new ArrayList<Point[]>(lineSegments);
        for (int vpNum = 0; vpNum < numVps; ++vpNum) {
            this.fillDataContainers(lineSegments);
            int numLines = lineSegments.size();
            if (this.verbose) {
                System.out.println("VP " + vpNum + "-----");
            }
            if (numLines < 3 || numLines < this.minimal_sample_set_dimension) {
                if (!this.verbose) break;
                System.out.println("Not enough line segments to compute vanishing point");
                break;
            }
            int N_I_best = this.minimal_sample_set_dimension;
            float J_best = Float.MAX_VALUE;
            int iter = 0;
            int T_iter = Integer.MAX_VALUE;
            int[] CS_best = new int[numLines];
            this.CS_idx = new int[numLines];
            float[] E = new float[numLines];
            if (this.verbose) {
                if (this.mode == 0) {
                    System.out.println("Method: Calibrated Least Squares");
                }
                if (this.mode == 1) {
                    System.out.println("Method: Nieto");
                }
                System.out.println("Start MSAC");
            }
            Mat vp = new Mat(3, 1, 5);
            while (iter <= min_iters || iter <= T_iter) {
                boolean notify;
                ++iter;
                int[] MSS = new int[this.minimal_sample_set_dimension];
                if (this.Li.rows() < MSS.length) break;
                Mat vpAux = new Mat(3, 1, 5);
                this.getMinimalSampleSet(this.Li, this.Lengths, this.Mi, MSS, vpAux);
                int[] N_I = new int[]{0};
                float J = this.getConsensusSet(vpNum, this.Li, this.Lengths, this.Mi, vpAux, E, N_I);
                boolean update_T_iter = false;
                if (N_I[0] >= this.minimal_sample_set_dimension && J < J_best || J == J_best && N_I[0] > N_I_best) {
                    notify = true;
                    J_best = J;
                    CS_best = this.CS_idx;
                    vp = vpAux;
                    if (N_I[0] > N_I_best) {
                        update_T_iter = true;
                    }
                    N_I_best = N_I[0];
                    if (update_T_iter) {
                        double q = 0.0;
                        if (this.minimal_sample_set_dimension > N_I_best) {
                            throw new IllegalStateException("The number of inliers must be higher than minimal sample set");
                        }
                        if (numLines == N_I_best) {
                            q = 1.0;
                        } else {
                            q = 1.0;
                            for (int j = 0; j < this.minimal_sample_set_dimension; ++j) {
                                q *= (double)(N_I_best - j) / (double)(numLines - j);
                            }
                        }
                        T_iter = 1.0 - q > 1.0E-12 ? (int)Math.ceil(Math.log(this.epsilon) / Math.log(1.0 - q)) : 0;
                    }
                } else {
                    notify = false;
                }
                if (this.verbose && notify) {
                    int aux = Math.max(T_iter, min_iters);
                    System.out.println("Iteration = " + iter + "/" + aux);
                    System.out.println("Inliers = " + N_I_best + "/" + numLines + " (cost is J = " + J_best);
                    if (this.verbose) {
                        System.out.println("MSS Cal.VP = (" + vp.get(0, 0)[0] + "," + vp.get(1, 0)[0] + "," + vp.get(2, 0)[0] + ")");
                    }
                }
                if (N_I_best != numLines) continue;
                if (!this.verbose) break;
                System.out.println("All line segments are inliers. End MSAC at iteration : " + iter);
                break;
            }
            if (this.verbose) {
                System.out.println("Number of iterations: " + iter);
                System.out.println("Final number of inliers = " + N_I_best + "/" + numLines);
            }
            ArrayList<Integer> ind_CS = new ArrayList<Integer>();
            ArrayList<Point[]> lineSegmentsCurrent = new ArrayList<Point[]>();
            for (int i = 0; i < numLines; ++i) {
                if (CS_best[i] != vpNum) continue;
                ind_CS.add(i);
                lineSegmentsCurrent.add(lineSegments.get(i));
            }
            if (J_best > 0.0f && ind_CS.size() > this.minimal_sample_set_dimension) {
                if (this.verbose) {
                    System.out.println("Reestimating the solution... ");
                }
                if (this.mode == 0) {
                    this.estimateLS(this.Li, this.Lengths, ind_CS, N_I_best, vp);
                } else if (this.mode != 1) {
                    throw new IllegalStateException("ERROR: mode not supported, please use {LS, LIEB, NIETO}\n");
                }
                if (this.verbose) {
                    System.out.println("done!");
                }
                if (this.verbose) {
                    System.out.println("Cal.VP = (" + vp.get(0, 0)[0] + "," + vp.get(1, 0)[0] + "," + vp.get(2, 0)[0] + ")");
                }
                Core.gemm((Mat)this.K, (Mat)vp, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)vp);
                if (vp.get(2, 0)[0] != 0.0) {
                    vp.put(0, 0, new float[]{Double.valueOf(vp.get(0, 0)[0] / vp.get(2, 0)[0]).floatValue()});
                    vp.put(1, 0, new float[]{Double.valueOf(vp.get(1, 0)[0] / vp.get(2, 0)[0]).floatValue()});
                    vp.put(2, 0, new float[]{1.0f});
                } else {
                    Core.gemm((Mat)this.K.inv(), (Mat)vp, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)vp);
                }
                if (this.verbose) {
                    System.out.println("VP = (" + vp.get(0, 0)[0] + "," + vp.get(1, 0)[0] + "," + vp.get(2, 0)[0] + ")");
                }
                vps.add(vp);
            } else if ((double)Math.abs(J_best - 1.0f) < 1.0E-6) {
                if (this.verbose) {
                    System.out.println("The cost of the best MSS is 0! No need to reestimate");
                    System.out.println("Cal. VP = (" + Double.valueOf(vp.get(0, 0)[0]) + "," + Double.valueOf(vp.get(1, 0)[0]) + "," + Double.valueOf(vp.get(2, 0)[0]) + ")");
                }
                Core.gemm((Mat)this.K, (Mat)vp, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)vp);
                if (vp.get(2, 0)[0] != 0.0) {
                    vp.put(0, 0, new float[]{Double.valueOf(vp.get(0, 0)[0] / vp.get(2, 0)[0]).floatValue()});
                    vp.put(1, 0, new float[]{Double.valueOf(vp.get(1, 0)[0] / vp.get(2, 0)[0]).floatValue()});
                    vp.put(2, 0, new float[]{1.0f});
                    if (this.verbose) {
                        System.out.println("VP = (" + vp.get(0, 0)[0] + "," + vp.get(1, 0)[0] + "," + vp.get(2, 0)[0] + ")");
                    }
                } else {
                    vp = this.K.inv().mul(vp);
                    Core.gemm((Mat)this.K.inv(), (Mat)vp, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)vp);
                }
                vps.add(vp);
            }
            if (N_I_best > 2) {
                for (int index = ind_CS.size() - 1; index >= 0; --index) {
                    lineSegments.remove(ind_CS.get(index));
                }
            }
            lineSegmentsClusters.add(lineSegmentsCurrent);
            numInliers.add(N_I_best);
        }
        lineSegments = lineSegmentsCopy;
    }

    public void getMinimalSampleSet(Mat Li, Mat Lengths, Mat Mi, int[] MSS, Mat vp) {
        int N = Li.rows();
        while (N <= (MSS[0] = (int)(Math.random() * (double)(N - 1)))) {
        }
        while (N <= (MSS[1] = (int)(Math.random() * (double)(N - 1)))) {
        }
        if (this.mode == 0) {
            this.estimateLS(Li, Lengths, Arrays.asList(MSS[0], MSS[1]), 2, vp);
        } else if (this.mode != 1) {
            throw new IllegalStateException("ERROR: mode not supported. Please use {LS, LIEB, NIETO}");
        }
    }

    private float getConsensusSet(int vpNum, Mat Li, Mat Lengths, Mat Mi, Mat vp, float[] E, int[] CS_counter) {
        for (int i = 0; i < this.CS_idx.length; ++i) {
            this.CS_idx[i] = -1;
        }
        float J = 0.0f;
        if (this.mode == 0) {
            J = this.errorLS(vpNum, Li, vp, E, CS_counter);
        } else if (this.mode != 1) {
            throw new IllegalStateException("ERROR: mode not supported, please use {LS, LIEB, NIETO}\n");
        }
        return J;
    }

    private void estimateLS(Mat Li, Mat Lengths, List<Integer> set, int set_length, Mat vp) {
        if (set_length == this.minimal_sample_set_dimension) {
            Mat ls0 = new Mat(3, 1, 5);
            Mat ls1 = new Mat(3, 1, 5);
            ls0.put(0, 0, Li.get(set.get(0).intValue(), 0));
            ls0.put(1, 0, Li.get(set.get(0).intValue(), 1));
            ls0.put(2, 0, Li.get(set.get(0).intValue(), 2));
            ls1.put(0, 0, Li.get(set.get(1).intValue(), 0));
            ls1.put(1, 0, Li.get(set.get(1).intValue(), 1));
            ls1.put(2, 0, Li.get(set.get(1).intValue(), 2));
            vp = ls0.cross(ls1);
            Core.normalize((Mat)vp, (Mat)vp);
            return;
        }
        if (set_length < this.minimal_sample_set_dimension) {
            throw new IllegalStateException("Error: at least 2 line-segments are required");
        }
        Mat li_set = new Mat(3, set_length, 5);
        Mat Lengths_set = new Mat(set_length, set_length, 5, new Scalar(0.0, 0.0, 0.0));
        for (int i = 0; i < set_length; ++i) {
            li_set.put(0, i, Li.get(set.get(i).intValue(), 0));
            li_set.put(1, i, Li.get(set.get(i).intValue(), 1));
            li_set.put(2, i, Li.get(set.get(i).intValue(), 2));
            Lengths_set.put(i, i, Lengths.get(set.get(i).intValue(), set.get(i).intValue()));
        }
        Mat L = li_set.t();
        Mat Tau = Lengths_set;
        Mat ATA = new Mat(3, 3, 5);
        Mat dst = new Mat();
        Core.gemm((Mat)L.t(), (Mat)Tau.t(), (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Core.gemm((Mat)dst, (Mat)Tau, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)dst);
        Core.gemm((Mat)dst, (Mat)L, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)ATA);
        Mat w = new Mat();
        Mat vt = new Mat();
        Mat v = new Mat();
        Core.SVDecomp((Mat)ATA, (Mat)w, (Mat)v, (Mat)vt);
        if (v.rows() < 3) {
            return;
        }
        vp.put(0, 0, v.get(0, 2));
        vp.put(1, 0, v.get(1, 2));
        vp.put(2, 0, v.get(2, 2));
        Core.normalize((Mat)vp, (Mat)vp);
    }

    public float errorLS(int vpNum, Mat Li, Mat vp, float[] E, int[] CS_counter) {
        Mat vn = vp;
        double vn_norm = Core.norm((Mat)vn);
        Mat li = new Mat(3, 1, 5);
        double li_norm = 0.0;
        float di = 0.0f;
        float J = 0.0f;
        for (int i = 0; i < Li.rows(); ++i) {
            li.put(0, 0, Li.get(i, 0));
            li.put(1, 0, Li.get(i, 1));
            li.put(2, 0, Li.get(i, 2));
            li_norm = Core.norm((Mat)li);
            di = (float)vn.dot(li);
            E[i] = (di /= (float)(vn_norm * li_norm)) * di;
            if (E[i] <= T_noise_squared) {
                this.CS_idx[i] = vpNum;
                CS_counter[0] = CS_counter[0] + 1;
                J += E[i];
                continue;
            }
            J += T_noise_squared;
        }
        return J /= (float)CS_counter[0];
    }

    public void drawCS(Mat im, List<List<Point[]>> lineSegmentsClusters, List<Mat> vps) {
        ArrayList<Scalar> colors = new ArrayList<Scalar>();
        colors.add(new Scalar(0.0, 0.0, 255.0));
        colors.add(new Scalar(0.0, 255.0, 0.0));
        colors.add(new Scalar(255.0, 0.0, 0.0));
        for (int vpNum = 0; vpNum < vps.size(); ++vpNum) {
            if (vps.get(vpNum).get(2, 0)[0] == 0.0) continue;
            Point vp = new Point(vps.get(vpNum).get(0, 0)[0], vps.get(vpNum).get(1, 0)[0]);
            if (!(vp.x >= 0.0) || !(vp.x < (double)im.cols()) || !(vp.y >= 0.0) || !(vp.y < (double)im.rows())) continue;
            Imgproc.circle((Mat)im, (Point)vp, (int)4, (Scalar)((Scalar)colors.get(vpNum)), (int)2);
            Imgproc.circle((Mat)im, (Point)vp, (int)3, (Scalar)new Scalar(0.0, 0.0, 0.0), (int)-1);
        }
        for (int localc = 0; localc < lineSegmentsClusters.size(); ++localc) {
            for (int i = 0; i < lineSegmentsClusters.get(localc).size(); ++i) {
                Point pt1 = lineSegmentsClusters.get(localc).get(i)[0];
                Point pt2 = lineSegmentsClusters.get(localc).get(i)[1];
                Imgproc.line((Mat)im, (Point)pt1, (Point)pt2, (Scalar)((Scalar)colors.get(localc)), (int)1);
            }
        }
    }
}

