/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.AbstractField;
import org.genericsystem.cv.utils.ModelTools;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class DocField
extends AbstractField {
    private int num;
    private String uid;

    public DocField() {
    }

    public DocField(int num, GSRect rect) {
        super(rect);
        this.num = num;
        this.uid = ModelTools.generateZoneUID(rect);
    }

    public void writeNum(Img img, String text, double fontScale, Scalar color, int thickness) {
        Imgproc.putText((Mat)img.getSrc(), (String)text, (Point)new Point(this.rect.tl().getX(), this.rect.br().getY()), (int)1, (double)fontScale, (Scalar)color, (int)thickness);
    }

    public void annotateImage(Img annotated, double fontScale, Scalar color, int thickness) {
        this.drawRect(annotated, color, thickness);
        this.writeNum(annotated, String.valueOf(this.num), fontScale, color, thickness);
    }

    public int getNum() {
        return this.num;
    }

    public String getUid() {
        return this.uid;
    }

    protected void setRect(GSRect rect) {
        this.updateRect(rect);
        this.uid = ModelTools.generateZoneUID(rect);
    }

    protected void setNum(int num) {
        this.num = num;
    }

    protected void setUid(String uid) {
        this.uid = uid;
    }

    protected void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    protected void setAttempts(long attempts) {
        this.attempts = attempts;
    }

    protected void setLabelsSize(int size) {
    }
}

