/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.textdetection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.MSER;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class MserTextDetector
extends AbstractApp {
    private final GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};
    private final MSER detector = MSER.create((int)1, (int)6, (int)40, (double)0.25, (double)0.2, (int)200, (double)1.01, (double)0.03, (int)5);

    public static void main(String[] args) {
        MserTextDetector.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.0;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
        }
        Image[] images = new Image[3];
        long ref = System.currentTimeMillis();
        long ref2 = System.currentTimeMillis();
        ArrayList regions = new ArrayList();
        MatOfRect mor = new MatOfRect();
        this.detector.detectRegions(this.frame.bgr2Gray().getSrc(), regions, mor);
        ArrayList<Rect> rects = new ArrayList<Rect>();
        Converters.Mat_to_vector_Rect((Mat)mor, rects);
        Mat display = this.frame.getSrc().clone();
        rects.removeIf(rect -> {
            for (Rect other : rects) {
                if (other.equals(rect)) continue;
                if (this.contains(other, (Rect)rect)) {
                    return true;
                }
                if (!this.isOverlapping((Rect)rect, other) || !(rect.area() < other.area())) continue;
                return true;
            }
            return false;
        });
        for (Rect rect2 : rects) {
            boolean isOverlapping = false;
            for (Rect other : rects) {
                if (other.equals((Object)rect2) || !this.isOverlapping(rect2, other)) continue;
                if (!(rect2.area() < other.area())) break;
                isOverlapping = true;
                break;
            }
            Imgproc.rectangle((Mat)display, (Rect)rect2, (Scalar)(isOverlapping ? new Scalar(0.0, 0.0, 255.0) : new Scalar(0.0, 255.0, 0.0)), (int)1);
        }
        images[0] = new Img(display, false).toJfxImage();
        ref = this.trace("mser", ref);
        ref2 = this.trace("total", ref2);
        return images;
    }

    public boolean isEnoughOverlapping(Rect rect, Rect shiftedRect, int pts) {
        return Math.abs(rect.tl().x - shiftedRect.tl().x) < (double)pts && Math.abs(rect.tl().y - shiftedRect.tl().y) < (double)pts && Math.abs(rect.br().x - shiftedRect.br().x) < (double)pts && Math.abs(rect.br().y - shiftedRect.br().y) < (double)pts;
    }

    private boolean contains(Rect rect, Rect shiftedRect) {
        return rect.tl().x <= shiftedRect.tl().x && rect.tl().y <= shiftedRect.tl().y && rect.br().x >= shiftedRect.br().x && rect.br().y >= shiftedRect.br().y;
    }

    private boolean isOverlapping(Rect first, Rect other) {
        return first.tl().x < other.br().x && other.tl().x < first.br().x && first.tl().y < other.br().y && other.tl().y < first.br().y;
    }

    private Mat sharpen(Mat img, double sigma, double threshold, double amount) {
        Mat blurred = new Mat();
        Imgproc.GaussianBlur((Mat)this.frame.getSrc(), (Mat)blurred, (Size)new Size(0.0, 0.0), (double)sigma, (double)sigma);
        Mat lowContrastMask = new Mat();
        Core.absdiff((Mat)this.frame.getSrc(), (Mat)blurred, (Mat)lowContrastMask);
        Imgproc.threshold((Mat)lowContrastMask, (Mat)lowContrastMask, (double)threshold, (double)255.0, (int)1);
        Mat sharpened = new Mat();
        Core.addWeighted((Mat)this.frame.getSrc(), (double)(1.0 + amount), (Mat)blurred, (double)(-amount), (double)0.0, (Mat)sharpened);
        this.frame.getSrc().copyTo(sharpened, lowContrastMask);
        return sharpened;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

