/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.AbstractFields;
import org.genericsystem.cv.retriever.Field;
import org.genericsystem.cv.retriever.RectDetector;
import org.genericsystem.cv.utils.ParallelTasks;
import org.genericsystem.cv.utils.RectToolsMapper;
import org.genericsystem.reinforcer.tools.GSPoint;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fields
extends AbstractFields<Field> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_DELETE_UNMERGED = 5;
    private static final int OCR_TIMEOUT = 100;

    public Fields(List<Field> fields) {
        super(fields);
    }

    public Fields() {
    }

    public void reset() {
        this.fields = new ArrayList();
    }

    @Override
    public void drawOcrPerspectiveInverse(Img display, Mat homography, int thickness) {
        this.stream().forEach(field -> field.drawWithHomography(display, homography, thickness));
    }

    public void drawFieldsOnStabilized(Img stabilized) {
        this.stream().forEach(field -> field.draw(stabilized, 1));
    }

    public void drawFieldsOnStabilizedDebug(Img stabilized) {
        for (GSRect rect : this.mergeRectsList(stabilized)) {
            Point[] targets = RectToolsMapper.gsPointToPoint(Arrays.asList(rect.decomposeClockwise())).toArray(new Point[0]);
            for (int i = 0; i < targets.length; ++i) {
                Imgproc.line((Mat)stabilized.getSrc(), (Point)targets[i], (Point)targets[(i + 1) % targets.length], (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
            }
        }
    }

    @JsonIgnore
    public List<Field> getRoots() {
        return this.fields.stream().filter(field -> field.isOrphan()).collect(Collectors.toList());
    }

    public void consolidate(Img img) {
        this.fields.forEach(f -> {
            if (f.isInFrame(img)) {
                f.incrementDeadCounter();
                f.adjustLockLevel(-0.5);
            }
        });
        this.mergeRects(img, 0.7);
        this.removeDeadTrees();
    }

    public List<GSRect> mergeRectsList(Img img) {
        RectDetector rd = new RectDetector(img);
        List<GSRect> rects = rd.getRects(200, 11, 3.0, new Size(11.0, 3.0));
        List<GSRect> children = rd.getRects(40, 17, 3.0, new Size(7.0, 3.0));
        return this.cleanList(rects, children, 0.7);
    }

    public List<GSRect> cleanList(List<GSRect> bigRects, List<GSRect> smallRects, double overlapThreshold) {
        smallRects.removeIf(smallRect -> bigRects.stream().anyMatch(bigRect -> smallRect.inclusiveArea(bigRect) > overlapThreshold));
        return Stream.concat(smallRects.stream().filter(smallRect -> bigRects.stream().filter(rect -> rect.isOverlapping(smallRect)).noneMatch(rect -> rect.getInsider(smallRect) == null)), bigRects.stream()).collect(Collectors.toList());
    }

    private void mergeRects(Img img, double overlapThreshold) {
        List<GSRect> rects = this.mergeRectsList(img);
        Collections.reverse(rects);
        for (GSRect rect : rects) {
            if (rect.isNearEdge(img.width(), img.height(), 10)) {
                logger.trace("Rect {} was too close to the frame's edges", (Object)rect);
                continue;
            }
            Field match = this.findMatch(rect, overlapThreshold, img.width(), img.height());
            if (match != null) {
                this.updateNode(rect, match, img.width(), img.height());
                continue;
            }
            Field parent = this.findPotentialParent(rect);
            List<Field> children = parent == null ? this.findPotentialChildren(this.getRoots(), rect) : this.findPotentialChildren(parent.getChildren(), rect);
            this.createNode(rect, parent, children);
        }
    }

    private List<Field> findPotentialChildren(List<Field> potentialChildren, GSRect rect) {
        return potentialChildren.stream().filter(f -> f.getRect().isInside(rect) && f.getRect().inclusiveArea(rect) < 0.3).collect(Collectors.toList());
    }

    private Field findPotentialParent(GSRect rect) {
        for (Field root : this.getRoots()) {
            Field parent = root.recursiveFindPotentialParent(rect);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public void createNode(GSRect rect, Field parent, List<Field> children) {
        if (!this.checkOverlapConstraint(rect)) {
            logger.trace("Rect {} was overlapping a field", (Object)rect);
        } else {
            Field f = new Field(rect);
            if (children != null) {
                for (Field child : children) {
                    child.updateParent(f);
                }
            }
            if (parent != null) {
                f.updateParent(parent);
            }
            this.fields.add(f);
        }
    }

    public void updateNode(GSRect rect, Field field, int width, int height) {
        field.updateOcrRect(rect);
        field.adjustLockLevel(1.0);
        field.recursiveResetParentsDeadCounter();
        field.recursiveResetChildrenDeadCounter();
    }

    private boolean checkOverlapConstraint(GSRect rect) {
        for (Field field : this.fields) {
            if (!rect.isOverlappingStrict(field.getRect()) || rect.getInsider(field.getRect()) != null) continue;
            field.adjustLockLevel(-0.4);
            return false;
        }
        return true;
    }

    public void removeNode(Field field) {
        this.fields.remove(field);
    }

    private void removeDeadTrees() {
        this.getRoots().stream().filter(field -> this.isDeadTree((Field)field, 5)).flatMap(field -> this.listTree((Field)field).stream()).forEach(this::removeNode);
    }

    private boolean isDeadTree(Field root, int maxDeadCount) {
        if (!root.hasChildren()) {
            return root.isDead(maxDeadCount);
        }
        for (Field child : root.getChildren()) {
            if (this.isDeadTree(child, maxDeadCount)) continue;
            return false;
        }
        return true;
    }

    private List<Field> listTree(Field root) {
        ArrayList<Field> res = new ArrayList<Field>();
        res.add(root);
        for (Field child : root.getChildren()) {
            res.addAll(this.listTree(child));
        }
        return res;
    }

    private Field findMatch(GSRect rect, double areaOverlap, int width, int height) {
        GSRect frameRect = new GSRect(0.0, 0.0, (double)width, (double)height);
        List matches = this.fields.stream().filter(f -> rect.inclusiveArea(f.getRect().getIntersection(frameRect)) > areaOverlap).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            logger.warn(matches.size() + " matches were detected.");
        }
        return (Field)matches.get(0);
    }

    public void restabilizeFields(Mat homography) {
        this.fields.forEach(field -> field.updateRect(this.findNewRect(field.getRect(), homography)));
    }

    private GSRect findNewRect(GSRect rect, Mat homography) {
        List<Point> originals = RectToolsMapper.gsPointToPoint(Arrays.asList(rect.tl(), rect.br()));
        List<GSPoint> points = RectToolsMapper.pointToGSPoint(this.restabilize(originals, homography));
        return new GSRect(points.get(0), points.get(1));
    }

    private List<Point> restabilize(List<Point> originals, Mat homography) {
        Mat original = Converters.vector_Point2d_to_Mat(originals);
        Mat results = new Mat();
        Core.perspectiveTransform((Mat)original, (Mat)results, (Mat)homography);
        ArrayList<Point> res = new ArrayList<Point>();
        Converters.Mat_to_vector_Point2d((Mat)results, res);
        return res;
    }

    @Override
    public void performOcr(Img rootImg) {
        if (this.size() <= 0) {
            return;
        }
        long TS = System.currentTimeMillis();
        while (System.currentTimeMillis() - TS <= 100L) {
            this.runParallelOcr(rootImg);
        }
    }

    private void runSequentialOcr(Img rootImg) {
        int idx = ThreadLocalRandom.current().nextInt(this.size());
        Field f = (Field)this.fields.get(idx);
        f.ocr(rootImg);
    }

    private void runParallelOcr(Img rootImg) {
        ParallelTasks tasks = new ParallelTasks();
        int limit = tasks.getCounter() * 2;
        HashSet<Integer> indexes = new HashSet<Integer>();
        while (indexes.size() < limit && indexes.size() < this.size()) {
            int idx = ThreadLocalRandom.current().nextInt(this.size());
            if (!indexes.add(idx)) continue;
            Field f = (Field)this.fields.get(idx);
            tasks.add(() -> f.ocr(rootImg));
        }
        try {
            tasks.run();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void consolidateHierarchyLabels() {
        for (Field field : this.getRoots()) {
            field.consolidateLabelWithChildren();
        }
    }
}

