/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import org.genericsystem.cv.application.Interpolator;
import org.genericsystem.cv.application.mesh.Points;
import org.opencv.core.Point;

public class CandidatePoints
extends Points {
    private final Interpolator interpolator;
    private final double deltaX;
    private final double deltaY;

    public CandidatePoints(Point imgCenter, int halfWidth, int halfHeight, double deltaX, double deltaY, int xBorder, int yBorder, Interpolator interpolator) {
        super(xBorder, yBorder);
        int j;
        int i;
        int j2;
        this.interpolator = interpolator;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.put(0, 0, this.createIndexedPoint(imgCenter));
        for (j2 = 1; j2 <= halfWidth; ++j2) {
            this.put(0, j2, this.createIndexedPoint(this.horizontalMove(this.getPoint(0, j2 - 1), this.getWidthCoeff(j2 + halfWidth - 1))));
        }
        for (j2 = -1; j2 >= -halfWidth; --j2) {
            this.put(0, j2, this.createIndexedPoint(this.horizontalMove(this.getPoint(0, j2 + 1), -this.getWidthCoeff(j2 + halfWidth))));
        }
        for (i = 1; i <= halfHeight; ++i) {
            this.put(i, 0, this.createIndexedPoint(this.verticalMove(this.getPoint(i - 1, 0), this.getHeightCoeff(i + halfHeight - 1))));
            for (j = 1; j <= halfWidth; ++j) {
                this.put(i, j, this.createIndexedPoint(this.intersect(this.getPoint(i, j - 1), this.getPoint(i - 1, j))));
            }
            for (j = -1; j >= -halfWidth; --j) {
                this.put(i, j, this.createIndexedPoint(this.intersect(this.getPoint(i, j + 1), this.getPoint(i - 1, j))));
            }
        }
        for (i = -1; i >= -halfHeight; --i) {
            this.put(i, 0, this.createIndexedPoint(this.verticalMove(this.getPoint(i + 1, 0), -this.getHeightCoeff(i + halfHeight))));
            for (j = 1; j <= halfWidth; ++j) {
                this.put(i, j, this.createIndexedPoint(this.intersect(this.getPoint(i, j - 1), this.getPoint(i + 1, j))));
            }
            for (j = -1; j >= -halfWidth; --j) {
                this.put(i, j, this.createIndexedPoint(this.intersect(this.getPoint(i, j + 1), this.getPoint(i + 1, j))));
            }
        }
    }

    double getWidthCoeff(int j) {
        return this.deltaX;
    }

    double getHeightCoeff(int i) {
        return this.deltaY;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    private Point verticalMove(Point startingPoint, double deltaY) {
        if (deltaY == 0.0) {
            return startingPoint;
        }
        double dY = Math.signum(deltaY);
        double x = startingPoint.x;
        double y = startingPoint.y;
        while (Math.abs(y - startingPoint.y - deltaY) >= 1.0) {
            double dX = this.interpolator.interpolateVerticals(x - (double)this.xBorder, y - (double)this.yBorder) * dY;
            assert (Double.isFinite(dX)) : this.interpolator.interpolateVerticals(x - (double)this.xBorder, y - (double)this.yBorder);
            x += dX;
            y += dY;
        }
        return new Point(x, y);
    }

    private Point horizontalMove(Point startingPoint, double deltaX) {
        if (deltaX == 0.0) {
            return startingPoint;
        }
        double dX = Math.signum(deltaX);
        double x = startingPoint.x;
        double y = startingPoint.y;
        while (Math.abs(x - startingPoint.x - deltaX) >= 1.0) {
            double dY = this.interpolator.interpolateHorizontals(x - (double)this.xBorder, y - (double)this.yBorder) * dX;
            assert (Double.isFinite(dY)) : this.interpolator.interpolateHorizontals(x - (double)this.xBorder, y - (double)this.yBorder);
            x += dX;
            y += dY;
        }
        return new Point(x, y);
    }

    private Point intersect(Point hPoint, Point vPoint) {
        double xDiff = this.xDiff(hPoint, vPoint);
        double yDiff = this.yDiff(vPoint, hPoint);
        while (Math.abs(xDiff) > 1.0 || Math.abs(yDiff) > 1.0) {
            xDiff = this.xDiff(hPoint, vPoint);
            yDiff = this.yDiff(vPoint, hPoint);
            hPoint = this.horizontalMove(hPoint, xDiff);
            vPoint = this.verticalMove(vPoint, yDiff);
        }
        if (Math.abs(xDiff) <= 1.0 && Math.abs(yDiff) <= 1.0) {
            return new Point(0.5 * (hPoint.x + vPoint.x), 0.5 * (hPoint.y + vPoint.y));
        }
        throw new IllegalStateException(xDiff + " " + yDiff);
    }

    private double xDiff(Point pt1, Point pt2) {
        return pt2.x - pt1.x;
    }

    private double yDiff(Point pt1, Point pt2) {
        return pt2.y - pt1.y;
    }
}

