/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.layout;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Ocr;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class Layout {
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    private Map<String, Integer> labels = new HashMap<String, Integer>();
    private List<Layout> children = new ArrayList<Layout>();
    private Layout parent = null;

    public Layout(Layout parent, double x1, double x2, double y1, double y2) {
        this.parent = parent;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public Img getRoi(Img img) {
        return new Img(img, this);
    }

    public Rect getRect(Img imgRoot) {
        Rect parentRect = this.getParent() != null ? this.getParent().getRect(imgRoot) : new Rect(0, 0, imgRoot.width(), imgRoot.height());
        return new Rect(new Point(parentRect.tl().x + (double)parentRect.width * this.getX1(), parentRect.tl().y + (double)parentRect.height * this.getY1()), new Point(parentRect.tl().x + (double)parentRect.width * this.getX2(), parentRect.tl().y + (double)parentRect.height * this.getY2()));
    }

    public Rect getLargeRect(Img imgRoot, double deltaW, double deltaH) {
        Rect rect = this.getRect(imgRoot);
        int adjustW = 3 + Double.valueOf(Math.floor((double)rect.width * deltaW)).intValue();
        int adjustH = 3 + Double.valueOf(Math.floor((double)rect.height * deltaH)).intValue();
        Point tl = new Point(rect.tl().x - (double)adjustW > 0.0 ? rect.tl().x - (double)adjustW : 0.0, rect.tl().y - (double)adjustH > 0.0 ? rect.tl().y - (double)adjustH : 0.0);
        Point br = new Point(rect.br().x + (double)adjustW > (double)imgRoot.width() ? (double)imgRoot.width() : rect.br().x + (double)adjustW, rect.br().y + (double)adjustH > (double)imgRoot.height() ? (double)imgRoot.height() : rect.br().y + (double)adjustH);
        return new Rect(tl, br);
    }

    public double normalizedArea() {
        double result = 0.0;
        if (this.getChildren().isEmpty()) {
            Point[] pts = this.getNormalizedTlBr();
            return (pts[1].x - pts[0].x) * (pts[1].y - pts[0].y);
        }
        for (Layout child : this.getChildren()) {
            result += child.normalizedArea();
        }
        return result;
    }

    public Point[] getNormalizedTlBr() {
        Point[] pointArray;
        if (this.getParent() != null) {
            pointArray = this.getParent().getNormalizedTlBr();
        } else {
            Point[] pointArray2 = new Point[2];
            pointArray2[0] = new Point(0.0, 0.0);
            pointArray = pointArray2;
            pointArray2[1] = new Point(1.0, 1.0);
        }
        Point[] parentRect = pointArray;
        return new Point[]{new Point(parentRect[0].x + (parentRect[1].x - parentRect[0].x) * this.getX1(), parentRect[0].y + (parentRect[1].y - parentRect[0].y) * this.getY1()), new Point(parentRect[0].x + (parentRect[1].x - parentRect[0].x) * this.getX2(), parentRect[0].y + (parentRect[1].y - parentRect[0].y) * this.getY2())};
    }

    public double area(Img imgRoot) {
        if (this.getChildren().isEmpty()) {
            return this.getRect(imgRoot).area() / (double)(imgRoot.height() * imgRoot.width());
        }
        double result = 0.0;
        for (Layout child : this.getChildren()) {
            result += child.area(imgRoot);
        }
        return result;
    }

    public double computeTotalSurface(Img img) {
        double[] surface = new double[]{0.0};
        this.traverse(this.getRoi(img), (roi, shard) -> {
            if (shard.getChildren().isEmpty()) {
                surface[0] = surface[0] + (double)(roi.height() * roi.width());
            }
        });
        return surface[0] / (double)(img.width() * img.height());
    }

    public Layout traverse(Img img, BiConsumer<Img, Layout> visitor) {
        for (Layout shard : this.getChildren()) {
            shard.traverse(shard.getRoi(img), visitor);
        }
        visitor.accept(img, this);
        return this;
    }

    public void draw(Img img, Scalar branchColor, Scalar leafColor, int branchThickness, int leafThickness) {
        this.traverse(this.getRoi(img), (roi, shard) -> {
            int thickNess;
            int n = thickNess = shard.getChildren().isEmpty() ? leafThickness : branchThickness;
            if (thickNess != 0) {
                Imgproc.rectangle((Mat)roi.getSrc(), (Point)new Point(0.0, 0.0), (Point)new Point((double)(roi.width() - 1), (double)(roi.height() - 1)), (Scalar)(shard.getChildren().isEmpty() ? leafColor : branchColor), (int)thickNess);
            }
        });
    }

    public void drawOcrPerspectiveInverse(Img rootImg, Mat homography, Scalar color, int thickness) {
        this.traverse(this.getRoi(rootImg), (roi, layout) -> {
            if (layout.getChildren().isEmpty()) {
                MatOfPoint2f results = new MatOfPoint2f();
                Rect rect = layout.getRect(rootImg);
                Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point((double)(rect.x + rect.width / 2), (double)(rect.y + rect.height / 2)))), (Mat)results, (Mat)homography);
                Point[] targets = results.toArray();
                Imgproc.line((Mat)rootImg.getSrc(), (Point)targets[0], (Point)new Point(targets[0].x, targets[0].y - 30.0), (Scalar)color, (int)thickness);
                Imgproc.putText((Mat)rootImg.getSrc(), (String)Normalizer.normalize(layout.getBestLabel(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", ""), (Point)new Point(targets[0].x - 10.0, targets[0].y - 30.0), (int)1, (double)1.0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
            }
        });
    }

    public void ocrTree(Img rootImg, double deltaW, double deltaH) {
        this.traverse(rootImg, (root, layout) -> {
            String ocr;
            if (layout.getChildren().isEmpty() && layout.needOcr() && !"".equals(ocr = Ocr.doWork(new Mat(rootImg.getSrc(), layout.getLargeRect(rootImg, deltaW, deltaH))))) {
                Integer count = layout.getLabels().get(ocr);
                layout.getLabels().put(ocr, 1 + (count != null ? count : 0));
            }
        });
    }

    public void drawOcr(Img rootImg) {
        this.traverse(rootImg, (root, layout) -> {
            if (layout.getChildren().isEmpty()) {
                Imgproc.putText((Mat)rootImg.getSrc(), (String)Normalizer.normalize(layout.getBestLabel(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", ""), (Point)layout.getRect(rootImg).tl(), (int)1, (double)1.0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
            }
        });
    }

    private String getBestLabel() {
        String result = "";
        int occurence = 0;
        for (String key : this.getLabels().keySet()) {
            if (this.getLabels().get(key) <= occurence) continue;
            result = key;
            occurence = this.getLabels().get(key);
        }
        return result;
    }

    public void addChild(Layout child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    public void removeChild(Layout child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public List<Layout> getChildren() {
        return this.children;
    }

    public double getX1() {
        return this.x1;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public double getX2() {
        return this.x2;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public double getY1() {
        return this.y1;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public double getY2() {
        return this.y2;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }

    public Layout getParent() {
        return this.parent;
    }

    public Map<String, Integer> getLabels() {
        return this.labels;
    }

    public boolean needOcr() {
        int all = this.getLabels().values().stream().reduce(0, (i, j) -> i + j);
        for (Map.Entry<String, Integer> entry : this.getLabels().entrySet()) {
            if (entry.getValue() <= all / 3) continue;
            return false;
        }
        return true;
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public String recursiveToString() {
        StringBuilder sb = new StringBuilder();
        this.recursivToString(this, sb, 0);
        sb.append("\n");
        return sb.toString();
    }

    private void recursivToString(Layout shard, StringBuilder sb, int depth) {
        sb.append("depth : " + depth + " : ");
        sb.append("[(" + shard.x1 + "," + shard.x2 + "),(" + shard.y1 + "," + shard.y2 + ")]".toString());
        if (!shard.hasChildren()) {
            sb.append(" : Labels : " + shard.labels);
        } else {
            ++depth;
            for (Layout s : shard.getChildren()) {
                sb.append("\n");
                for (int i = 0; i < depth; ++i) {
                    sb.append("    ");
                }
                this.recursivToString(s, sb, depth);
            }
        }
    }

    public String toString() {
        return "tl : (" + this.x1 + "," + this.y1 + "), br :(" + this.x2 + "," + this.y2 + ")";
    }

    public Layout recursiveSplit(Size constantClose, Size linearClose, int level, Img binary) {
        if (level <= 0) {
            return this;
        }
        List<Layout> shards = this.split(constantClose, linearClose, binary);
        shards.removeIf(shard -> (shard.getY2() - shard.getY1()) * binary.size().height < 2.0 || (shard.getX2() - shard.getX1()) * binary.size().width < 2.0);
        if (shards.isEmpty()) {
            return null;
        }
        for (Layout shard2 : shards) {
            Layout shardLayout = shard2.recursiveSplit(constantClose, linearClose, level - 1, shard2.getRoi(binary));
            if (shardLayout == null || shard2.getX1() == 0.0 && shard2.getX2() == 1.0 && shard2.getY1() == 0.0 && shard2.getY2() == 1.0) continue;
            this.addChild(shard2);
        }
        return this;
    }

    public List<Layout> split(Size constantClose, Size linearClose, Img binary) {
        int verticalClose = (int)Math.floor(constantClose.height + linearClose.height * (double)binary.height());
        int horizontalClose = (int)Math.floor(constantClose.width + linearClose.width * (double)binary.width());
        return this.extractZones(Img.close(binary.projectVertically(), verticalClose), Img.close(binary.projectHorizontally(), horizontalClose), binary);
    }

    private List<Layout> extractZones(boolean[] resultV, boolean[] resultH, Img binary) {
        List<double[]> shardsV = this.getShards(resultV);
        List<double[]> shardsH = this.getShards(resultH);
        ArrayList<Layout> shards = new ArrayList<Layout>();
        for (double[] shardv : shardsV) {
            for (double[] shardh : shardsH) {
                Layout target = new Layout(this, shardh[0], shardh[1], shardv[0], shardv[1]);
                if (shardh[0] == shardh[1] || shardv[0] == shardv[1]) continue;
                shards.add(target);
            }
        }
        return shards;
    }

    private List<double[]> getShards(boolean[] result) {
        Double start;
        ArrayList<double[]> shards = new ArrayList<double[]>();
        Double d = start = result[0] ? Double.valueOf(0.0) : null;
        assert (result.length >= 1);
        for (int i = 0; i < result.length - 1; ++i) {
            if (!result[i] && result[i + 1]) {
                start = i + 1;
                continue;
            }
            if (!result[i] || result[i + 1]) continue;
            shards.add(new double[]{start / (double)result.length, ((double)i + 1.0) / (double)result.length});
            start = null;
        }
        if (result[result.length - 1]) {
            shards.add(new double[]{start / (double)result.length, 1.0});
            start = null;
        }
        return shards;
    }
}

