/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.Serializable;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Ocr;
import org.genericsystem.cv.utils.ModelTools;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class Zone
implements Serializable {
    private Rect rect;
    private int num;
    private String uid;

    public Zone() {
    }

    public Zone(int num, Rect rect) {
        this.num = num;
        this.rect = rect;
        this.uid = ModelTools.generateZoneUID(rect);
    }

    public Rect getRect() {
        return this.rect;
    }

    public Zone adjustRect(double dx, double dy, int maxWidht, int maxHeight) {
        Point tl = new Point(this.rect.tl().x > dx ? this.rect.tl().x - dx : 0.0, this.rect.tl().y > dy ? this.rect.tl().y - dy : 0.0);
        Point br = new Point(this.rect.br().x + dx > (double)maxWidht ? (double)maxWidht : this.rect.br().x + dx, this.rect.br().y + dy > (double)maxHeight ? (double)maxHeight : this.rect.br().y + dy);
        return new Zone(this.num, new Rect(tl, br));
    }

    public void draw(Img img, Scalar color, int thickness) {
        Imgproc.rectangle((Mat)img.getSrc(), (Point)this.rect.tl(), (Point)this.rect.br(), (Scalar)color, (int)thickness);
    }

    public void write(Img img, String text, double fontScale, Scalar color, int thickness) {
        Imgproc.putText((Mat)img.getSrc(), (String)text, (Point)new Point(this.rect.tl().x, this.rect.br().y), (int)1, (double)fontScale, (Scalar)color, (int)thickness);
    }

    public String ocr(Img img) {
        return Ocr.doWork(new Mat(img.getSrc(), this.getRect()));
    }

    public int getNum() {
        return this.num;
    }

    public Img getRoi(Img img) {
        return new Img(img, this);
    }

    public Img getImg(Img img) {
        return new Img(new Mat(img.getSrc(), this.getRect()), false);
    }

    public void draw(Mat roi, Scalar color, int thickness) {
        Imgproc.rectangle((Mat)roi, (Point)this.rect.tl(), (Point)this.rect.br(), (Scalar)color, (int)thickness);
    }

    public String toString() {
        return "Zone [rect=" + this.rect + ", num=" + this.num + ", uid=" + this.uid + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.num;
        result = 31 * result + (this.rect == null ? 0 : this.rect.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Zone other = (Zone)obj;
        if (this.num != other.num) {
            return false;
        }
        return !(this.rect == null ? other.rect != null : !this.rect.equals((Object)other.rect));
    }

    public String getUid() {
        return this.uid;
    }
}

