/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.Line;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Ransac;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;

public class LinesDetector
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private Damper damper = new Damper(10);

    public static void main(String[] args) {
        LinesDetector.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        this.damper.pushNewValue(0.0);
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView binaryView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)binaryView, 0, 0);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 1);
        ImageView rotatedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)rotatedView, 1, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskiewedView, 1, 1);
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img grad = new Img(frame, false).morphologyEx(4, 0, new Size(2.0, 2.0)).otsu();
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 100, 100.0, 10.0));
                if (lines.size() > 16) {
                    lines.draw(frame, new Scalar(0.0, 0.0, 255.0));
                    lines = lines.ransacMean();
                    lines.draw(frame, new Scalar(0.0, 255.0, 0.0));
                    this.damper.pushNewValue(lines.getMean());
                    System.out.println("Ransac angle: " + lines.getMean() / Math.PI * 180.0);
                    binaryView.setImage(Tools.mat2jfxImage(grad.getSrc()));
                    frameView.setImage(Tools.mat2jfxImage(frame));
                    Mat matrix = Imgproc.getRotationMatrix2D((Point)new Point((double)(frame.width() / 2), (double)(frame.height() / 2)), (double)(lines.getMean() / Math.PI * 180.0), (double)1.0);
                    Mat rotated = new Mat(frame.size(), CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
                    Mat rotatedMasked = new Mat();
                    Mat mask = new Mat(frame.size(), CvType.CV_8UC1, new Scalar(255.0));
                    Mat warpedMask = new Mat();
                    Imgproc.warpAffine((Mat)mask, (Mat)warpedMask, (Mat)matrix, (Size)frame.size());
                    Imgproc.warpAffine((Mat)frame, (Mat)rotatedMasked, (Mat)matrix, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    rotatedMasked.copyTo(rotated, warpedMask);
                    lines = Lines.of(lines.rotate(matrix));
                    rotatedView.setImage(Tools.mat2jfxImage(rotated));
                    Mat dePerspectived = new Mat(frame.size(), CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
                    Ransac<Line> ransac = lines.findPerspectiveMatrix(frame.width(), frame.height());
                    Mat homography = (Mat)ransac.getBestModel().getParams()[0];
                    mask = new Mat(frame.size(), CvType.CV_8UC1, new Scalar(255.0));
                    Mat maskWarpped = new Mat();
                    Imgproc.warpPerspective((Mat)mask, (Mat)maskWarpped, (Mat)homography, (Size)frame.size());
                    Mat tmp = new Mat();
                    Imgproc.warpPerspective((Mat)rotated, (Mat)tmp, (Mat)homography, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    tmp.copyTo(dePerspectived, maskWarpped);
                    lines = new Lines(ransac.getBestDataSet().values());
                    lines.draw(dePerspectived, new Scalar(255.0, 0.0, 0.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Damper {
        private final int maxSize;
        private final ArrayDeque<Double> deque;

        Damper(int maxSize) {
            this.maxSize = maxSize;
            this.deque = new ArrayDeque(maxSize + 1);
        }

        void pushNewValue(double value) {
            this.deque.push(value);
            if (this.deque.size() > this.maxSize) {
                this.deque.removeLast();
            }
        }

        public double getMean() {
            double mean = 0.0;
            for (Double value : this.deque) {
                mean += value.doubleValue();
            }
            return mean /= (double)this.deque.size();
        }
    }

    public static class Lines
    extends org.genericsystem.cv.utils.Lines {
        public Lines(Mat src) {
            super(src);
        }

        public Lines(Collection<Line> lines) {
            super(lines);
        }

        public static Lines of(Collection<Line> lines) {
            return new Lines(lines);
        }

        public Ransac<Line> findPerspectiveMatrix(int width, int height) {
            Function modelProvider = datas -> {
                Line line = (Line)datas.iterator().next();
                double a = (line.getY2() - line.getY1()) / (line.getX2() - line.getX1());
                double b = (line.getY1() + line.getY2() - a * (line.getX1() + line.getX2())) / 2.0;
                double newy = a * (double)width / 2.0 + b;
                final Mat homography = Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(new Point[]{new Point(line.getX1(), line.getY1()), new Point(line.getX2(), line.getY2()), new Point(line.getX2(), (double)(height / 2)), new Point(line.getX1(), (double)(height / 2))}), (Mat)new MatOfPoint2f(new Point[]{new Point(line.getX1(), newy), new Point(line.getX2(), newy), new Point(line.getX2(), (double)(height / 2)), new Point(line.getX1(), (double)(height / 2))}));
                return new Ransac.Model<Line>(){

                    @Override
                    public double computeError(Line line) {
                        return Math.abs(line.perspectivTransform(homography).getAngle());
                    }

                    @Override
                    public double computeGlobalError(List<Line> datas, Collection<Line> consensusData) {
                        double error = 0.0;
                        for (Line data : datas) {
                            error += Math.pow(this.computeError(data), 2.0);
                        }
                        return error / (double)datas.size();
                    }

                    @Override
                    public Object[] getParams() {
                        return new Object[]{homography};
                    }
                };
            };
            Ransac<Line> ransac = new Ransac<Line>(this.lines, modelProvider, 1, 200, 0.05235987755982988, Double.valueOf(Math.floor((double)this.lines.size() * 0.6)).intValue());
            return ransac;
        }

        public Lines ransacMean() {
            Function modelProvider = datas -> {
                Lines lines = new Lines((Collection<Line>)datas);
                final double meanParam = lines.getMean();
                return new Ransac.Model<Line>(){

                    @Override
                    public double computeError(Line data) {
                        return Math.abs(data.getAngle() - meanParam);
                    }

                    @Override
                    public Object[] getParams() {
                        return new Object[]{meanParam};
                    }

                    @Override
                    public double computeGlobalError(List<Line> datas, Collection<Line> consensusData) {
                        double error = 0.0;
                        for (Line data : consensusData) {
                            error += Math.pow(this.computeError(data), 2.0);
                        }
                        return error / (double)datas.size();
                    }
                };
            };
            return new Lines(new Ransac(this.lines, modelProvider, this.lines.size() / 8, 100, 0.4363323129985824, this.lines.size() / 3).getBestDataSet().values());
        }
    }
}

