/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.util.Arrays;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class Line {
    public final double x1;
    public final double y1;
    public final double x2;
    public final double y2;
    protected final double angle;

    public Line(Point p1, Point p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public Line(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.angle = Math.atan2(y2 - y1, x2 - x1);
    }

    public Point[] getSegment() {
        return new Point[]{new Point(this.x1, this.y1), new Point(this.x2, this.y2)};
    }

    public Line rotationTransform(Mat rotationMatrix) {
        Mat original = Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2)));
        MatOfPoint2f results = new MatOfPoint2f();
        Core.transform((Mat)original, (Mat)results, (Mat)rotationMatrix);
        Point[] targets = results.toArray();
        Line line = new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        original.release();
        results.release();
        return line;
    }

    public Line perspectivTransform(Mat homography) {
        Mat original = Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2)));
        MatOfPoint2f results = new MatOfPoint2f();
        Core.perspectiveTransform((Mat)original, (Mat)results, (Mat)homography);
        Point[] targets = results.toArray();
        Line line = new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        original.release();
        results.release();
        return line;
    }

    public void draw(Mat frame, Scalar color, int thickness) {
        Imgproc.line((Mat)frame, (Point)new Point(this.x1, this.y1), (Point)new Point(this.x2, this.y2), (Scalar)color, (int)thickness);
    }

    public double size() {
        return Math.sqrt(Math.pow(this.y2 - this.y1, 2.0) + Math.pow(this.x2 - this.x1, 2.0));
    }

    public double geta() {
        return (this.y2 - this.y1) / (this.x2 - this.x1);
    }

    public double getb() {
        return this.y1 - this.geta() * this.x1;
    }

    public Point intersection(Line line) {
        double x = (line.getb() - this.getb()) / (this.geta() - line.geta());
        double y = this.geta() * x + this.getb();
        return new Point(x, y);
    }

    public Point intersection(double verticalLinex) {
        double x = verticalLinex;
        double y = this.geta() * x + this.getb();
        return new Point(x, y);
    }

    public String toString() {
        return "Line : " + this.angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }
}

