/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.newmodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.annotations.Components;
import org.genericsystem.api.core.annotations.InstanceClass;
import org.genericsystem.api.core.annotations.SystemGeneric;
import org.genericsystem.api.core.annotations.constraints.InstanceValueClassConstraint;
import org.genericsystem.api.core.annotations.constraints.PropertyConstraint;
import org.genericsystem.api.core.annotations.constraints.SingularConstraint;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.opencv.core.Rect;

public class SimpleModel {
    private static final ObjectMapper mapper = new ObjectMapper();

    @SystemGeneric
    @Components(value={ImgType.class})
    @PropertyConstraint
    @InstanceClass(value=ImgRefreshTimestampInstance.class)
    @InstanceValueClassConstraint(value=Long.class)
    public static class ImgRefreshTimestampType
    implements Generic {

        @SystemGeneric
        public static class ImgRefreshTimestampInstance
        implements Generic {
            public ImgType.ImgInstance getImgInstance() {
                return (ImgType.ImgInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @Components(value={ImgType.class})
    @PropertyConstraint
    @InstanceClass(value=ImgTimestampInstance.class)
    @InstanceValueClassConstraint(value=Long.class)
    public static class ImgTimestampType
    implements Generic {

        @SystemGeneric
        public static class ImgTimestampInstance
        implements Generic {
            public ImgType.ImgInstance getImgInstance() {
                return (ImgType.ImgInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @Components(value={ImgType.class})
    @PropertyConstraint
    @InstanceClass(value=ImgPathInstance.class)
    @InstanceValueClassConstraint(value=String.class)
    public static class ImgPathType
    implements Generic {

        @SystemGeneric
        public static class ImgPathInstance
        implements Generic {
            public ImgType.ImgInstance getImgInstance() {
                return (ImgType.ImgInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @Components(value={ZoneType.class})
    @PropertyConstraint
    @InstanceClass(value=SupervisedInstance.class)
    @InstanceValueClassConstraint(value=String.class)
    public static class SupervisedType
    implements Generic {

        @SystemGeneric
        public static class SupervisedInstance
        implements Generic {
            public ZoneType.ZoneInstance getZoneInstance() {
                return (ZoneType.ZoneInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @Components(value={ZoneType.class})
    @PropertyConstraint
    @InstanceClass(value=ConsolidatedInstance.class)
    @InstanceValueClassConstraint(value=String.class)
    public static class ConsolidatedType
    implements Generic {

        @SystemGeneric
        public static class ConsolidatedInstance
        implements Generic {
            public ZoneType.ZoneInstance getZoneInstance() {
                return (ZoneType.ZoneInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @Components(value={ZoneType.class})
    @PropertyConstraint
    @InstanceClass(value=ZoneNumInstance.class)
    @InstanceValueClassConstraint(value=Integer.class)
    public static class ZoneNumType
    implements Generic {

        @SystemGeneric
        public static class ZoneNumInstance
        implements Generic {
            public ZoneType.ZoneInstance getZoneInstance() {
                return (ZoneType.ZoneInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @Components(value={ImgType.class})
    @InstanceClass(value=ZoneInstance.class)
    @InstanceValueClassConstraint(value=String.class)
    public static class ZoneType
    implements Generic {

        @SystemGeneric
        public static class ZoneInstance
        implements Generic {
            public ImgType.ImgInstance getImgInstance() {
                return (ImgType.ImgInstance)this.getBaseComponent();
            }

            public ZoneNumType.ZoneNumInstance setZoneNum(int num) {
                return (ZoneNumType.ZoneNumInstance)this.setHolder((DefaultGeneric)this.getRoot().find(ZoneNumType.class), Integer.valueOf(num), (DefaultGeneric[])new Generic[0]);
            }

            public ZoneNumType.ZoneNumInstance getZoneNum() {
                return (ZoneNumType.ZoneNumInstance)this.getHolder((DefaultGeneric)this.getRoot().find(ZoneNumType.class), (DefaultGeneric[])new Generic[0]);
            }

            public ConsolidatedType.ConsolidatedInstance setConsolidated(String consolidated) {
                return (ConsolidatedType.ConsolidatedInstance)this.setHolder((DefaultGeneric)this.getRoot().find(ConsolidatedType.class), (Serializable)((Object)consolidated), (DefaultGeneric[])new Generic[0]);
            }

            public ConsolidatedType.ConsolidatedInstance getConsolidated() {
                return (ConsolidatedType.ConsolidatedInstance)this.getHolder((DefaultGeneric)this.getRoot().find(ConsolidatedType.class), (DefaultGeneric[])new Generic[0]);
            }

            public SupervisedType.SupervisedInstance setSupervised(String supervised) {
                return (SupervisedType.SupervisedInstance)this.setHolder((DefaultGeneric)this.getRoot().find(SupervisedType.class), (Serializable)((Object)supervised), (DefaultGeneric[])new Generic[0]);
            }

            public SupervisedType.SupervisedInstance getSupervised() {
                return (SupervisedType.SupervisedInstance)this.getHolder((DefaultGeneric)this.getRoot().find(SupervisedType.class), (DefaultGeneric[])new Generic[0]);
            }

            public Rect getZoneRect() {
                try {
                    Rect rect = (Rect)mapper.readValue(this.getValue().toString(), Rect.class);
                    return rect;
                }
                catch (IOException e) {
                    throw new IllegalStateException("An error has occured while converting the json to a rectangle", e);
                }
            }
        }
    }

    @SystemGeneric
    @InstanceClass(value=ImgInstance.class)
    @InstanceValueClassConstraint(value=String.class)
    public static class ImgType
    implements Generic {
        public Snapshot<ImgInstance> getImgInstances() {
            return this.getInstances();
        }

        public ImgInstance addImg(String name) {
            return (ImgInstance)this.addInstance((Serializable)((Object)name), (DefaultGeneric[])new Generic[0]);
        }

        public ImgInstance getImg(String name) {
            return (ImgInstance)this.getInstance((Serializable)((Object)name), (DefaultGeneric[])new Generic[0]);
        }

        @SystemGeneric
        public static class ImgInstance
        implements Generic {
            public Snapshot<ZoneType.ZoneInstance> getZoneInstances() {
                return this.getHolders((DefaultGeneric)this.getRoot().find(ZoneType.class));
            }

            public Snapshot<ZoneType.ZoneInstance> getEmptyZoneInstances() {
                return this.getZoneInstances().filter(zone -> {
                    ConsolidatedType.ConsolidatedInstance consolidated = zone.getConsolidated();
                    return !this.isConsolidated(consolidated);
                });
            }

            public Snapshot<ZoneType.ZoneInstance> getConsolidatedZoneInstances() {
                return this.getZoneInstances().filter(zone -> {
                    ConsolidatedType.ConsolidatedInstance consolidated = zone.getConsolidated();
                    return this.isConsolidated(consolidated);
                });
            }

            private boolean isConsolidated(ConsolidatedType.ConsolidatedInstance consolidated) {
                return consolidated != null && consolidated.getValue() != null && !"".equals(consolidated.getValue());
            }

            public ZoneType.ZoneInstance addZone(Rect rect) {
                try {
                    String json = mapper.writeValueAsString((Object)rect);
                    return (ZoneType.ZoneInstance)this.addHolder((DefaultGeneric)this.getRoot().find(ZoneType.class), (Serializable)((Object)json), (DefaultGeneric[])new Generic[0]);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException("An error has occured while converting the rectangle to a json string", e);
                }
            }

            public ZoneType.ZoneInstance getZone(Rect rect) {
                try {
                    String json = mapper.writeValueAsString((Object)rect);
                    return this.getZone(json);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException("An error has occured while converting the rectangle to a json string", e);
                }
            }

            public ZoneType.ZoneInstance addZone(String json) {
                return (ZoneType.ZoneInstance)this.addHolder((DefaultGeneric)this.getRoot().find(ZoneType.class), (Serializable)((Object)json), (DefaultGeneric[])new Generic[0]);
            }

            public ZoneType.ZoneInstance getZone(String json) {
                return (ZoneType.ZoneInstance)this.getHolder((DefaultGeneric)this.getRoot().find(ZoneType.class), (Serializable)((Object)json), (DefaultGeneric[])new Generic[0]);
            }

            public ImgPathType.ImgPathInstance setImgPath(String relativePath) {
                return (ImgPathType.ImgPathInstance)this.setHolder((DefaultGeneric)this.getRoot().find(ImgPathType.class), (Serializable)((Object)relativePath), (DefaultGeneric[])new Generic[0]);
            }

            public ImgPathType.ImgPathInstance getImgPath() {
                return (ImgPathType.ImgPathInstance)this.getHolder((DefaultGeneric)this.getRoot().find(ImgPathType.class), (DefaultGeneric[])new Generic[0]);
            }

            public ImgTimestampType.ImgTimestampInstance setImgTimestamp(Long timestamp) {
                return (ImgTimestampType.ImgTimestampInstance)this.setHolder((DefaultGeneric)this.getRoot().find(ImgTimestampType.class), timestamp, (DefaultGeneric[])new Generic[0]);
            }

            public ImgTimestampType.ImgTimestampInstance getImgTimestamp() {
                return (ImgTimestampType.ImgTimestampInstance)this.getHolder((DefaultGeneric)this.getRoot().find(ImgTimestampType.class), (DefaultGeneric[])new Generic[0]);
            }

            public ImgRefreshTimestampType.ImgRefreshTimestampInstance setImgRefreshTimestamp(Long timestamp) {
                return (ImgRefreshTimestampType.ImgRefreshTimestampInstance)this.setHolder((DefaultGeneric)this.getRoot().find(ImgRefreshTimestampType.class), timestamp, (DefaultGeneric[])new Generic[0]);
            }

            public ImgRefreshTimestampType.ImgRefreshTimestampInstance getImgRefreshTimestamp() {
                return (ImgRefreshTimestampType.ImgRefreshTimestampInstance)this.getHolder((DefaultGeneric)this.getRoot().find(ImgRefreshTimestampType.class), (DefaultGeneric[])new Generic[0]);
            }

            public ImgDocRel.ImgDocLink addImgDocLink(String name, DocType.DocInstance docInstance) {
                return (ImgDocRel.ImgDocLink)this.addLink((DefaultGeneric)this.getRoot().find(ImgDocRel.class), (Serializable)((Object)name), (DefaultGeneric)docInstance, (DefaultGeneric[])new Generic[0]);
            }

            public ImgDocRel.ImgDocLink getImgDocLink() {
                return (ImgDocRel.ImgDocLink)this.getLink((DefaultGeneric)this.getRoot().find(ImgDocRel.class), (DefaultGeneric[])new Generic[0]);
            }

            public DocType.DocInstance getLinkedDoc() {
                return this.getImgDocLink().getDocInstance();
            }
        }
    }

    @SystemGeneric
    @Components(value={DocClassType.class})
    @InstanceClass(value=DocInstance.class)
    public static class DocType
    implements Generic {

        @SystemGeneric
        public static class DocInstance
        implements Generic {
            public DocClassType.DocClassInstance getDocClassInstance() {
                return (DocClassType.DocClassInstance)this.getBaseComponent();
            }

            public Snapshot<ImgDocRel.ImgDocLink> getAllImgDocLinks() {
                return this.getLinks((DefaultGeneric)this.getRoot().find(ImgDocRel.class));
            }

            public Snapshot<ImgType.ImgInstance> getAllLinkedImgs() {
                return this.getAllImgDocLinks().map(link -> link.getImgInstance());
            }

            public ImgDocRel.ImgDocLink addImgDocLink(String name, ImgType.ImgInstance imgInstance) {
                return (ImgDocRel.ImgDocLink)this.addLink((DefaultGeneric)this.getRoot().find(ImgDocRel.class), (Serializable)((Object)name), (DefaultGeneric)imgInstance, (DefaultGeneric[])new Generic[0]);
            }

            public ImgDocRel.ImgDocLink getImgDocLink(ImgType.ImgInstance imgInstance) {
                return (ImgDocRel.ImgDocLink)this.getLink((DefaultGeneric)this.getRoot().find(ImgDocRel.class), (DefaultGeneric[])new Generic[]{imgInstance});
            }
        }
    }

    @SystemGeneric
    @Components(value={ImgType.class, DocType.class})
    @SingularConstraint(value={0})
    @InstanceClass(value=ImgDocLink.class)
    public static class ImgDocRel
    implements Generic {
        public Snapshot<ImgDocLink> getAllImgDocLinks() {
            return this.getInstances();
        }

        public ImgDocLink addImgDocLink(String name, ImgType.ImgInstance imgInstance, DocType.DocInstance docInstance) {
            return (ImgDocLink)this.addInstance((Serializable)((Object)name), (DefaultGeneric[])new Generic[]{imgInstance, docInstance});
        }

        public ImgDocLink getImgDocLink(ImgType.ImgInstance imgInstance, DocType.DocInstance docInstance) {
            return (ImgDocLink)this.getInstance((DefaultGeneric[])new Generic[]{imgInstance, docInstance});
        }

        @SystemGeneric
        public static class ImgDocLink
        implements Generic {
            public ImgType.ImgInstance getImgInstance() {
                return (ImgType.ImgInstance)this.getComponent(0);
            }

            public DocType.DocInstance getDocInstance() {
                return (DocType.DocInstance)this.getComponent(1);
            }
        }
    }

    @SystemGeneric
    @Components(value={DocClassType.class})
    @InstanceClass(value=LayoutInstance.class)
    public static class LayoutType
    implements Generic {

        @SystemGeneric
        public static class LayoutInstance
        implements Generic {
            public DocClassType.DocClassInstance getDocClassInstance() {
                return (DocClassType.DocClassInstance)this.getBaseComponent();
            }
        }
    }

    @SystemGeneric
    @InstanceClass(value=DocClassInstance.class)
    public static class DocClassType
    implements Generic {
        public Snapshot<DocClassInstance> getAllDocClasses() {
            return this.getInstances();
        }

        public DocClassInstance addDocClass(String name) {
            return (DocClassInstance)this.addInstance((Serializable)((Object)name), (DefaultGeneric[])new Generic[0]);
        }

        public DocClassInstance getDocClass(String name) {
            return (DocClassInstance)this.getInstance((Serializable)((Object)name), (DefaultGeneric[])new Generic[0]);
        }

        @SystemGeneric
        public static class DocClassInstance
        implements Generic {
            public Snapshot<DocType.DocInstance> getAllDocInstances() {
                return this.getHolders((DefaultGeneric)this.getRoot().find(DocType.class));
            }

            public Snapshot<LayoutType.LayoutInstance> getAllLayouts() {
                return this.getComposites().filter(composite -> this.getRoot().find(LayoutType.class).equals(composite.getMeta()));
            }

            public Snapshot<LayoutType.LayoutInstance> getAllLayoutLeaves() {
                return this.getAllLayouts().filter(layout -> layout.getInheritings().isEmpty());
            }

            public LayoutType.LayoutInstance getLayoutRoot() {
                return (LayoutType.LayoutInstance)this.getAllLayouts().filter(layout -> layout.getSupers().isEmpty()).first();
            }

            public DocType.DocInstance addDocInstance(String name) {
                return (DocType.DocInstance)this.addHolder((DefaultGeneric)this.getRoot().find(DocType.class), (Serializable)((Object)name), (DefaultGeneric[])new Generic[0]);
            }

            public DocType.DocInstance getDocInstance(String name) {
                return (DocType.DocInstance)this.getHolder((DefaultGeneric)this.getRoot().find(DocType.class), (Serializable)((Object)name), (DefaultGeneric[])new Generic[0]);
            }

            public LayoutType.LayoutInstance addLayout(String json) {
                return (LayoutType.LayoutInstance)this.addHolder((DefaultGeneric)this.getRoot().find(LayoutType.class), Collections.emptyList(), (Serializable)((Object)json), (DefaultGeneric[])new Generic[0]);
            }

            public LayoutType.LayoutInstance addLayout(String json, LayoutType.LayoutInstance ... parents) {
                return (LayoutType.LayoutInstance)this.addHolder((DefaultGeneric)this.getRoot().find(LayoutType.class), Arrays.asList(parents), (Serializable)((Object)json), (DefaultGeneric[])new Generic[0]);
            }

            public LayoutType.LayoutInstance getLayout(String json) {
                return (LayoutType.LayoutInstance)this.getHolder((DefaultGeneric)this.getRoot().find(LayoutType.class), (Serializable)((Object)json), (DefaultGeneric[])new Generic[0]);
            }
        }
    }
}

