/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Ransac;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.opencv.videoio.VideoCapture;

public class LinesDetector4
extends AbstractApp {
    private final VideoCapture capture = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private Point vp = new Point(0.0, 0.0);

    public static void main(String[] args) {
        LinesDetector4.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        Mat frame = new Mat();
        this.capture.read(frame);
        ImageView frameView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)frameView, 0, 0);
        ImageView deskiewedView = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)deskiewedView, 0, 1);
        Mat dePerspectived = frame.clone();
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.capture.read(frame);
                Img grad = new Img(frame, false).morphologyEx(4, 2, new Size(2.0, 2.0)).otsu().morphologyEx(3, 2, new Size(7.0, 7.0));
                Lines lines = new Lines(grad.houghLinesP(1, Math.PI / 180, 10, 100.0, 10.0));
                if (lines.size() > 10) {
                    lines.draw(frame, new Scalar(0.0, 0.0, 255.0));
                    frameView.setImage(Tools.mat2jfxImage(frame));
                    Ransac<Line> ransac = lines.vanishingPointRansac(frame.width(), frame.height());
                    Mat vp_mat = (Mat)ransac.getBestModel().getParams()[0];
                    Mat uncalibrate = LinesDetector4.uncalibrate(vp_mat);
                    this.vp = new Point(uncalibrate.get(0, 0)[0], uncalibrate.get(1, 0)[0]);
                    System.out.println("Vanishing point : " + this.vp);
                    Point bary = new Point((double)(frame.width() / 2), (double)(frame.height() / 2));
                    Mat homography = this.findHomography(this.vp, bary, frame.width(), frame.height());
                    lines = new Lines(ransac.getBestDataSet().values()).perspectivTransform(homography);
                    Imgproc.warpPerspective((Mat)frame, (Mat)dePerspectived, (Mat)homography, (Size)frame.size(), (int)1, (int)1, (Scalar)Scalar.all((double)255.0));
                    lines.draw(dePerspectived, new Scalar(0.0, 255.0, 0.0));
                    deskiewedView.setImage(Tools.mat2jfxImage(dePerspectived));
                } else {
                    System.out.println("Not enough lines : " + lines.size());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 33L, 250L, TimeUnit.MILLISECONDS);
    }

    public static void calibrate(Mat uncalibrate) {
        Core.gemm((Mat)Lines.K.inv(), (Mat)uncalibrate, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)uncalibrate);
        Core.normalize((Mat)uncalibrate, (Mat)uncalibrate);
    }

    public static Mat uncalibrate(Mat calibrated) {
        Mat uncalibrate = new Mat(3, 1, CvType.CV_64FC1);
        Core.gemm((Mat)Lines.K, (Mat)calibrated, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)uncalibrate);
        if (uncalibrate.get(2, 0)[0] != 0.0) {
            uncalibrate.put(0, 0, new double[]{uncalibrate.get(0, 0)[0] / uncalibrate.get(2, 0)[0]});
            uncalibrate.put(1, 0, new double[]{uncalibrate.get(1, 0)[0] / uncalibrate.get(2, 0)[0]});
            uncalibrate.put(2, 0, new double[]{1.0});
        }
        return uncalibrate;
    }

    public Point[] rotate(Point bary, double alpha, Point ... p) {
        Mat matrix = Imgproc.getRotationMatrix2D((Point)bary, (double)(alpha / Math.PI * 180.0), (double)1.0);
        MatOfPoint2f results = new MatOfPoint2f();
        Core.transform((Mat)new MatOfPoint2f(p), (Mat)results, (Mat)matrix);
        return results.toArray();
    }

    private Mat findHomography(Point vp, Point bary, double width, double height) {
        Point B_;
        Point C_;
        Point D_;
        Point A_;
        double alpha_ = Math.atan2(vp.y - bary.y, vp.x - bary.x);
        if (alpha_ < -1.5707963267948966 && alpha_ > -Math.PI) {
            alpha_ += Math.PI;
        }
        if (alpha_ < Math.PI && alpha_ > 1.5707963267948966) {
            alpha_ -= Math.PI;
        }
        double alpha = alpha_;
        Point rotatedVp = this.rotate(bary, alpha, vp)[0];
        Point A = new Point(0.0, 0.0);
        Point B = new Point(width, 0.0);
        Point C = new Point(width, height);
        Point D = new Point(0.0, height);
        Point AB2 = new Point(width / 2.0, 0.0);
        Point CD2 = new Point(width / 2.0, height);
        if (rotatedVp.x >= width / 2.0) {
            A_ = new Line(AB2, rotatedVp).intersection(0.0);
            D_ = new Line(CD2, rotatedVp).intersection(0.0);
            C_ = new Line(A_, bary).intersection(new Line(CD2, rotatedVp));
            B_ = new Line(D_, bary).intersection(new Line(AB2, rotatedVp));
        } else {
            B_ = new Line(AB2, rotatedVp).intersection(width);
            C_ = new Line(CD2, rotatedVp).intersection(width);
            A_ = new Line(C_, bary).intersection(new Line(AB2, rotatedVp));
            D_ = new Line(B_, bary).intersection(new Line(CD2, rotatedVp));
        }
        System.out.println("vp : " + vp);
        System.out.println("rotated vp : " + rotatedVp);
        System.out.println("Alpha : " + alpha * 180.0 / Math.PI);
        return Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(this.rotate(bary, -alpha, A_, B_, C_, D_)), (Mat)new MatOfPoint2f(new Point[]{A, B, C, D}));
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.capture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Line {
        private final double x1;
        private final double y1;
        private final double x2;
        private final double y2;
        private final double angle;

        public Line(Point p1, Point p2) {
            this(p1.x, p1.y, p2.x, p2.y);
        }

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.angle = Math.atan2(y2 - y1, x2 - x1);
        }

        public double size() {
            return Math.sqrt(Math.pow(this.y2 - this.y1, 2.0) + Math.pow(this.x2 - this.x1, 2.0));
        }

        public Line transform(Mat rotationMatrix) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.transform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)rotationMatrix);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public Line perspectivTransform(Mat homography) {
            MatOfPoint2f results = new MatOfPoint2f();
            Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(Arrays.asList(new Point(this.x1, this.y1), new Point(this.x2, this.y2))), (Mat)results, (Mat)homography);
            Point[] targets = results.toArray();
            return new Line(targets[0].x, targets[0].y, targets[1].x, targets[1].y);
        }

        public void draw(Mat frame, Scalar color) {
            Imgproc.line((Mat)frame, (Point)new Point(this.x1, this.y1), (Point)new Point(this.x2, this.y2), (Scalar)color, (int)1);
        }

        public String toString() {
            return "Line : " + this.angle;
        }

        public double getAngle() {
            return this.angle;
        }

        public double geta() {
            return (this.y2 - this.y1) / (this.x2 - this.x1);
        }

        public double getOrthoa() {
            return (this.x2 - this.x1) / (this.y1 - this.y2);
        }

        public double getOrthob(Point p) {
            return p.y - this.getOrthoa() * p.x;
        }

        public double getb() {
            return this.y1 - this.geta() * this.x1;
        }

        public double distance(Point p) {
            return Math.abs(this.geta() * p.x - p.y + this.getb()) / Math.sqrt(1.0 + Math.pow(this.geta(), 2.0));
        }

        public Point intersection(double a, double b) {
            double x = (b - this.getb()) / (this.geta() - a);
            double y = a * x + b;
            return new Point(x, y);
        }

        public Point intersection(Line line) {
            double x = (line.getb() - this.getb()) / (this.geta() - line.geta());
            double y = this.geta() * x + this.getb();
            return new Point(x, y);
        }

        public Point intersection(double verticalLinex) {
            double x = verticalLinex;
            double y = this.geta() * x + this.getb();
            return new Point(x, y);
        }
    }

    public static class Lines {
        private final List<Line> lines;
        private static Mat K;

        public Lines(Mat src) {
            this.lines = new ArrayList<Line>();
            for (int i = 0; i < src.rows(); ++i) {
                double[] val = src.get(i, 0);
                Line line = new Line(val[0], val[1], val[2], val[3]);
                this.lines.add(line);
            }
        }

        public Lines(Collection<Line> lines) {
            this.lines = new ArrayList<Line>(lines);
        }

        private Mat getLineMat(Line line) {
            Mat a = new Mat(3, 1, CvType.CV_64FC1);
            Mat b = new Mat(3, 1, CvType.CV_64FC1);
            a.put(0, 0, new double[]{line.x1});
            a.put(1, 0, new double[]{line.y1});
            a.put(2, 0, new double[]{1.0});
            b.put(0, 0, new double[]{line.x2});
            b.put(1, 0, new double[]{line.y2});
            b.put(2, 0, new double[]{1.0});
            Mat li = a.cross(b);
            Core.normalize((Mat)li, (Mat)li);
            return li;
        }

        private Mat getLineMiMat(Line line) {
            Mat a = new Mat(3, 1, CvType.CV_64FC1);
            Mat b = new Mat(3, 1, CvType.CV_64FC1);
            a.put(0, 0, new double[]{line.x1});
            a.put(1, 0, new double[]{line.y1});
            a.put(2, 0, new double[]{1.0});
            b.put(0, 0, new double[]{line.x2});
            b.put(1, 0, new double[]{line.y2});
            b.put(2, 0, new double[]{1.0});
            Mat c = new Mat(3, 1, CvType.CV_64FC1);
            Core.addWeighted((Mat)a, (double)0.5, (Mat)b, (double)0.5, (double)0.0, (Mat)c);
            return c;
        }

        public Ransac<Line> vanishingPointRansac(double width, double height) {
            int minimal_sample_set_dimension = 2;
            final double maxError = 0.03246;
            if (K == null) {
                K = new Mat(3, 3, CvType.CV_64FC1, new Scalar(0.0));
                K.put(0, 0, new double[]{width});
                K.put(0, 2, new double[]{width / 2.0});
                K.put(1, 1, new double[]{height});
                K.put(1, 2, new double[]{height / 2.0});
                K.put(2, 2, new double[]{1.0});
            }
            final Mat[] vp = new Mat[1];
            Function modelProvider = datas -> {
                if (datas.size() == minimal_sample_set_dimension) {
                    Iterator it = datas.iterator();
                    vp[0] = this.getLineMat((Line)it.next()).cross(this.getLineMat((Line)it.next()));
                    LinesDetector4.calibrate(vp[0]);
                } else {
                    double r = Core.norm((Mat)vp[0]);
                    double theta = Math.acos(vp[0].get(2, 0)[0] / r);
                    double phi = Math.atan2(vp[0].get(1, 0)[0], vp[0].get(0, 0)[0]);
                    double[] parameters = new LevenbergImpl<Line>((line, params) -> {
                        Mat vn = new Mat(3, 1, CvType.CV_64FC1);
                        vn.put(0, 0, new double[]{Math.cos(params[1]) * Math.sin(params[0])});
                        vn.put(1, 0, new double[]{Math.sin(params[1]) * Math.sin(params[0])});
                        vn.put(2, 0, new double[]{Math.cos(params[0])});
                        return this.distance(LinesDetector4.uncalibrate(vn), (Line)line);
                    }, (Collection<Line>)datas, new double[]{theta, phi}).getParams();
                    vp[0].put(0, 0, new double[]{r * Math.cos(parameters[1]) * Math.sin(parameters[0])});
                    vp[0].put(1, 0, new double[]{r * Math.sin(parameters[1]) * Math.sin(parameters[0])});
                    vp[0].put(2, 0, new double[]{r * Math.cos(parameters[0])});
                }
                return new Ransac.Model<Line>(){

                    @Override
                    public double computeError(Line line) {
                        assert (Math.abs(Core.norm((Mat)vp[0]) - 1.0) < 0.001);
                        double di = this.distance(LinesDetector4.uncalibrate(vp[0]), line);
                        return di * di;
                    }

                    @Override
                    public double computeGlobalError(List<Line> datas, Collection<Line> consensusDatas) {
                        double globalError = 0.0;
                        for (Line line : datas) {
                            double error = this.computeError(line);
                            if (error > maxError) {
                                error = maxError;
                            }
                            globalError += error;
                        }
                        return globalError /= (double)datas.size();
                    }

                    @Override
                    public Object[] getParams() {
                        return new Object[]{vp[0]};
                    }
                };
            };
            return new Ransac<Line>(this.lines, modelProvider, minimal_sample_set_dimension, 100, maxError, Double.valueOf(Math.floor((double)this.lines.size() * 0.6)).intValue());
        }

        private double distance(Mat vp, Line line) {
            Mat lineSegment = this.getLineMat(line);
            double n0 = -lineSegment.get(1, 0)[0];
            double n1 = lineSegment.get(0, 0)[0];
            double nNorm = Math.sqrt(n0 * n0 + n1 * n1);
            Mat midPoint = this.getLineMiMat(line);
            double c0 = midPoint.get(0, 0)[0];
            double c1 = midPoint.get(1, 0)[0];
            double c2 = midPoint.get(2, 0)[0];
            double v0 = vp.get(0, 0)[0];
            double v1 = vp.get(1, 0)[0];
            double v2 = vp.get(2, 0)[0];
            double r0 = v1 * c2 - v2 * c1;
            double r1 = v2 * c0 - v0 * c2;
            double rNorm = Math.sqrt(r0 * r0 + r1 * r1);
            double num = r0 * n0 + r1 * n1;
            if (num < 0.0) {
                num = -num;
            }
            double d = 0.0;
            if (nNorm != 0.0 && rNorm != 0.0) {
                d = num / (nNorm * rNorm);
            }
            return d;
        }

        public Lines rotate(Mat matrix) {
            return new Lines(this.lines.stream().map(line -> line.transform(matrix)).collect(Collectors.toList()));
        }

        public Lines perspectivTransform(Mat matrix) {
            return new Lines(this.lines.stream().map(line -> line.perspectivTransform(matrix)).collect(Collectors.toList()));
        }

        public void draw(Mat frame, Scalar color) {
            this.lines.forEach(line -> line.draw(frame, color));
        }

        public int size() {
            return this.lines.size();
        }
    }
}

