/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.retriever.AbstractField;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;

public abstract class AbstractFields<F extends AbstractField>
implements Iterable<F> {
    protected List<F> fields;
    protected static final double MIN_SIMILARITY = 0.9;
    protected static final double OVERLAP_THRESHOLD = 0.3;
    protected static final double OVERLAP_CONFIDENCE = 0.9;
    protected static final String FIELDS = "fields";

    public AbstractFields() {
        this.fields = new ArrayList<F>();
    }

    public AbstractFields(List<F> fields) {
        this.fields = fields;
    }

    protected List<F> findMatchingFieldsWithConfidence(F field, double threshold) {
        return this.fields.stream().filter(f -> f.overlapsMoreThanThresh(field.getRect(), threshold)).collect(Collectors.toList());
    }

    protected List<F> findPossibleMatches(GSRect rect, double epsilon) {
        return this.fields.stream().filter(f -> f.isClusteredWith(rect, epsilon)).collect(Collectors.toList());
    }

    public abstract void performOcr(Img var1);

    public void drawOcrPerspectiveInverse(Img display, Mat homography, int thickness) {
        this.stream().forEach(field -> field.drawOcrPerspectiveInverse(display, homography, thickness));
    }

    public void drawConsolidated(Img stabilizedDisplay) {
        this.consolidatedFieldStream().forEach(field -> field.drawRect(stabilizedDisplay, new Scalar(0.0, 255.0, 0.0), 1));
    }

    public Stream<F> consolidatedFieldStream() {
        return this.stream().filter(f -> f.isConsolidated());
    }

    public Stream<F> stream() {
        return this.fields.stream();
    }

    @Override
    public Iterator<F> iterator() {
        return this.fields.iterator();
    }

    public int size() {
        return this.fields.size();
    }

    public JsonObject toJsonObject() {
        return new JsonObject().put(FIELDS, this.fields);
    }

    public List<F> getFields() {
        return this.fields;
    }
}

