/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.stabilizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.genericsystem.cv.application.Reconciliation;
import org.genericsystem.cv.application.stabilizer.ImgDescriptor;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class ReferenceManager {
    private static final Mat IDENTITY_MAT = Mat.eye((Size)new Size(3.0, 3.0), (int)6);
    private TreeMap<ImgDescriptor, Mat> toReferenceGraphy = new TreeMap(new Comparator<ImgDescriptor>(){

        @Override
        public int compare(ImgDescriptor d1, ImgDescriptor d2) {
            return new Long(d1.getTimeStamp()).compareTo(new Long(d2.getTimeStamp()));
        }
    });
    private ImgDescriptor reference;
    private Fields fields = new Fields();
    private Size frameSize;

    public ReferenceManager(Size frameSize) {
        this.frameSize = frameSize;
    }

    public boolean submit(ImgDescriptor newImgDescriptor) {
        if (this.reference == null) {
            this.toReferenceGraphy.put(newImgDescriptor, IDENTITY_MAT);
            this.reference = newImgDescriptor;
            return false;
        }
        int bestMatchingPointsCount = 0;
        ImgDescriptor bestImgDescriptor = null;
        Reconciliation bestReconciliation = null;
        ImgDescriptor lastStored = this.toReferenceGraphy.lastKey();
        Reconciliation reconciliationWithlast = newImgDescriptor.computeReconciliation(lastStored);
        if (reconciliationWithlast != null) {
            bestReconciliation = reconciliationWithlast;
            bestImgDescriptor = lastStored;
        } else {
            Reconciliation reconciliationWithRef = newImgDescriptor.computeReconciliation(this.reference);
            if (reconciliationWithRef != null) {
                bestReconciliation = reconciliationWithRef;
                bestImgDescriptor = this.reference;
            } else {
                List<ImgDescriptor> list = this.getRandomPool(lastStored, this.reference);
                Random randomGenerator = new Random();
                for (int reconciliationTries = 0; !list.isEmpty() && reconciliationTries < 5; ++reconciliationTries) {
                    int matchingPointsCount;
                    ImgDescriptor randomImgDescriptor = list.get(randomGenerator.nextInt(list.size()));
                    Reconciliation reconciliation = newImgDescriptor.computeReconciliation(randomImgDescriptor);
                    if (reconciliation == null || (matchingPointsCount = reconciliation.getPts().size()) < bestMatchingPointsCount) continue;
                    bestMatchingPointsCount = matchingPointsCount;
                    bestReconciliation = reconciliation;
                    bestImgDescriptor = randomImgDescriptor;
                }
            }
        }
        if (bestReconciliation == null) {
            if (this.toReferenceGraphy.size() <= 1) {
                this.toReferenceGraphy.clear();
                this.toReferenceGraphy.put(newImgDescriptor, IDENTITY_MAT);
                this.reference = newImgDescriptor;
            }
            return false;
        }
        Mat homographyToReference = new Mat();
        Core.gemm((Mat)bestReconciliation.getHomography(), (Mat)this.toReferenceGraphy.get(bestImgDescriptor), (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)homographyToReference);
        this.toReferenceGraphy.put(newImgDescriptor, homographyToReference);
        this.cleanReferenceNeighbours();
        return true;
    }

    private List<ImgDescriptor> getRandomPool(ImgDescriptor lastStored, ImgDescriptor reference) {
        ArrayList<ImgDescriptor> randomPool = new ArrayList<ImgDescriptor>(this.toReferenceGraphy.keySet());
        randomPool.remove(lastStored);
        randomPool.remove(reference);
        return randomPool;
    }

    private void cleanReferenceNeighbours() {
        if (this.toReferenceGraphy.size() > 30) {
            double minDistance = Double.MAX_VALUE;
            ImgDescriptor closestDescriptor = null;
            for (Map.Entry<ImgDescriptor, Mat> entry : this.toReferenceGraphy.entrySet()) {
                double distance;
                if (entry.getKey().equals(this.reference) || entry.getKey().equals(this.toReferenceGraphy.lastKey()) || !((distance = this.distance(entry.getValue())) < minDistance)) continue;
                minDistance = distance;
                closestDescriptor = entry.getKey();
            }
            this.toReferenceGraphy.remove(closestDescriptor);
        }
    }

    private void updateReference() {
        ImgDescriptor consensualDescriptor = this.findConsensualDescriptor();
        if (this.reference != consensualDescriptor) {
            System.out.println("Change reference");
            Mat homoInv = this.toReferenceGraphy.get(consensualDescriptor).inv();
            for (Map.Entry<ImgDescriptor, Mat> entry : this.toReferenceGraphy.entrySet()) {
                if (!entry.getKey().equals(consensualDescriptor)) {
                    Mat result = new Mat();
                    Core.gemm((Mat)entry.getValue(), (Mat)homoInv, (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)result);
                    this.toReferenceGraphy.put(entry.getKey(), result);
                    continue;
                }
                this.toReferenceGraphy.put(entry.getKey(), IDENTITY_MAT);
            }
            this.reference = consensualDescriptor;
            this.fields.shift(homoInv);
        }
    }

    private ImgDescriptor findConsensualDescriptor() {
        double bestDistance = Double.MAX_VALUE;
        ImgDescriptor bestDescriptor = null;
        for (Map.Entry<ImgDescriptor, Mat> entry : this.toReferenceGraphy.entrySet()) {
            double distance = 0.0;
            for (Map.Entry<ImgDescriptor, Mat> entry2 : this.toReferenceGraphy.entrySet()) {
                if (entry.getKey().equals(entry2.getKey())) continue;
                Mat betweenHomography = new Mat();
                Core.gemm((Mat)entry.getValue(), (Mat)entry2.getValue().inv(), (double)1.0, (Mat)new Mat(), (double)0.0, (Mat)betweenHomography);
                distance += this.distance(betweenHomography);
            }
            if (!(distance < bestDistance)) continue;
            bestDistance = distance;
            bestDescriptor = entry.getKey();
        }
        return bestDescriptor;
    }

    public List<Rect> getResizedFieldsRects() {
        List<Rect> referenceRects = this.getReferenceRects();
        if (referenceRects.isEmpty()) {
            return Collections.emptyList();
        }
        double minX = referenceRects.stream().mapToDouble(rect -> rect.tl().x).min().getAsDouble();
        double maxX = referenceRects.stream().mapToDouble(rect -> rect.br().x).max().getAsDouble();
        double minY = referenceRects.stream().mapToDouble(rect -> rect.tl().y).min().getAsDouble();
        double maxY = referenceRects.stream().mapToDouble(rect -> rect.br().y).max().getAsDouble();
        double horizontalRatio = this.frameSize.width / (maxX - minX) > 1.0 ? 1.0 : this.frameSize.width / (maxX - minX);
        double verticalRatio = this.frameSize.height / (maxY - minY) > 1.0 ? 1.0 : this.frameSize.height / (maxY - minY);
        return this.rescale(this.shift(referenceRects, minX, minY), Math.min(horizontalRatio, verticalRatio));
    }

    private List<Rect> rescale(List<Rect> rects, double ratio) {
        return rects.stream().map(r -> this.rescale((Rect)r, ratio)).collect(Collectors.toList());
    }

    public Rect rescale(Rect rect, double ratio) {
        return new Rect((int)((double)rect.x * ratio), (int)((double)rect.y * ratio), (int)((double)rect.width * ratio), (int)((double)rect.height * ratio));
    }

    private List<Rect> shift(List<Rect> rects, double minX, double minY) {
        return rects.stream().map(r -> this.shift((Rect)r, minX, minY)).collect(Collectors.toList());
    }

    private Rect shift(Rect rect, double minX, double minY) {
        return new Rect((int)((double)rect.x - minX), (int)((double)rect.y - minY), rect.width, rect.height);
    }

    private void consolidate(List<Rect> shiftedRects, Size frameSize) {
        Rect frameRect = new Rect(0, 0, (int)frameSize.width, (int)frameSize.height);
        List<Field> displayedFields = this.fields.getFields().stream().filter(f -> f.isInner(frameRect)).collect(Collectors.toList());
        for (Rect shiftedRect : shiftedRects) {
            List<Field> targetFields = this.fields.findOverlapingFields(shiftedRect);
            boolean toAdd = true;
            for (Field targetField2 : targetFields) {
                if (!targetField2.isEnoughOverlapping(shiftedRect, 3)) continue;
                targetField2.dump(shiftedRect, 3.0);
                targetField2.increase();
                targetField2.increase();
                toAdd = false;
            }
            if (!toAdd) continue;
            Field newField = new Field(shiftedRect);
            newField.increase();
            newField.increase();
            this.fields.add(newField);
        }
        this.decreaseAll(displayedFields);
        this.fields.clean(targetField -> targetField.getLevel() < -5);
    }

    private void decreaseAll(List<Field> displayedFields) {
        displayedFields.forEach(f -> f.decrease());
    }

    public List<Rect> getReferenceRects() {
        return this.fields.getPositiveLevelRects();
    }

    private List<Rect> shift(List<Rect> detectedRects, Mat homography) {
        ArrayList<Point> pts = new ArrayList<Point>(2 * detectedRects.size());
        detectedRects.forEach(rect -> {
            pts.add(rect.tl());
            pts.add(rect.br());
        });
        List<Point> transform = this.transform(pts, homography);
        ArrayList<Rect> result = new ArrayList<Rect>(detectedRects.size());
        for (int i = 0; i < transform.size(); i += 2) {
            result.add(new Rect(transform.get(i), transform.get(i + 1)));
        }
        return result;
    }

    private List<Point> transform(List<Point> originals, Mat homography) {
        Mat original = Converters.vector_Point2d_to_Mat(originals);
        Mat results = new Mat();
        Core.perspectiveTransform((Mat)original, (Mat)results, (Mat)homography);
        ArrayList<Point> res = new ArrayList<Point>();
        Converters.Mat_to_vector_Point2d((Mat)results, res);
        return res;
    }

    private double distance(Mat betweenHomography) {
        List<Point> originalPoints = Arrays.asList(new Point(0.0, 0.0), new Point(this.frameSize.width, 0.0), new Point(this.frameSize.width, this.frameSize.height), new Point(0.0, this.frameSize.height));
        List<Point> points = this.transform(originalPoints, betweenHomography);
        return this.distance(points, originalPoints);
    }

    private double distance(List<Point> newPointList, List<Point> oldPointList) {
        double error = 0.0;
        for (int i = 0; i < oldPointList.size(); ++i) {
            double deltaX = newPointList.get((int)i).x - oldPointList.get((int)i).x;
            double deltaY = newPointList.get((int)i).y - oldPointList.get((int)i).y;
            error += deltaX * deltaX + deltaY * deltaY;
        }
        return Math.sqrt(error) / (double)oldPointList.size();
    }

    public ImgDescriptor getReference() {
        return this.reference;
    }

    public void clear() {
        this.reference = null;
        this.toReferenceGraphy.clear();
        this.fields.clean(field -> true);
    }

    public Mat getHomography(ImgDescriptor imgDescriptor) {
        return this.toReferenceGraphy.get(imgDescriptor);
    }

    public Mat dewarp(ImgDescriptor imgDescriptor, Mat homography) {
        Mat result = new Mat();
        Imgproc.warpPerspective((Mat)imgDescriptor.getFrame().getSrc(), (Mat)result, (Mat)homography, (Size)imgDescriptor.getFrame().size(), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
        return result;
    }

    public TreeMap<ImgDescriptor, Mat> getToReferenceGraphy() {
        return this.toReferenceGraphy;
    }

    private static class Fields {
        private List<Field> fieldsList = new ArrayList<Field>();

        private Fields() {
        }

        public void clean(Predicate<Field> predicate) {
            this.fieldsList.removeIf(predicate);
        }

        public void shift(Mat homoInv) {
            this.fieldsList.forEach(field -> field.shift(homoInv));
        }

        public List<Field> findOverlapingFields(Rect shiftedRect) {
            return this.fieldsList.stream().filter(field -> field.isOverlapping(shiftedRect)).collect(Collectors.toList());
        }

        public void add(Field field) {
            this.fieldsList.add(field);
        }

        public List<Rect> getPositiveLevelRects() {
            return this.fieldsList.stream().filter(field -> field.getLevel() >= 0).map(field -> field.getRect()).collect(Collectors.toList());
        }

        public void decreaseAll() {
            this.fieldsList.forEach(field -> field.decrease());
        }

        public List<Field> getFields() {
            return this.fieldsList;
        }
    }

    private static class Field {
        private Rect rect;
        private int level = 0;

        Field(Rect rect) {
            this.rect = rect;
        }

        public int getLevel() {
            return this.level;
        }

        public void decrease() {
            --this.level;
        }

        public void increase() {
            ++this.level;
        }

        public boolean isEnoughOverlapping(Rect shiftedRect, int pts) {
            return Math.abs(this.rect.tl().x - shiftedRect.tl().x) < (double)pts && Math.abs(this.rect.tl().y - shiftedRect.tl().y) < (double)pts && Math.abs(this.rect.br().x - shiftedRect.br().x) < (double)pts && Math.abs(this.rect.br().y - shiftedRect.br().y) < (double)pts;
        }

        public boolean isOverlapping(Rect other) {
            return this.rect.tl().x <= other.br().x && other.tl().x <= this.rect.br().x && this.rect.tl().y <= other.br().y && other.tl().y <= this.rect.br().y;
        }

        public void dump(Rect shiftedRect, double dumpingSize) {
            this.rect = new Rect(new Point((double)Math.round(this.rect.tl().x * ((dumpingSize - 1.0) / dumpingSize) + shiftedRect.tl().x / dumpingSize), (double)Math.round(this.rect.tl().y * ((dumpingSize - 1.0) / dumpingSize) + shiftedRect.tl().y / dumpingSize)), new Point((double)Math.round(this.rect.br().x * (dumpingSize - 1.0) / dumpingSize + shiftedRect.br().x / dumpingSize), (double)Math.round(this.rect.br().y * (dumpingSize - 1.0) / dumpingSize + shiftedRect.br().y / dumpingSize)));
        }

        public Rect getRect() {
            return this.rect;
        }

        public void shift(Mat homography) {
            Mat original = Converters.vector_Point2d_to_Mat(Arrays.asList(this.rect.tl(), this.rect.br()));
            Mat results = new Mat();
            Core.perspectiveTransform((Mat)original, (Mat)results, (Mat)homography);
            ArrayList res = new ArrayList();
            Converters.Mat_to_vector_Point2d((Mat)results, res);
            this.rect = new Rect((Point)res.get(0), (Point)res.get(1));
        }

        public boolean contains(Rect shiftedRect) {
            return this.rect.tl().x <= shiftedRect.tl().x && this.rect.tl().y <= shiftedRect.tl().y && this.rect.br().x >= shiftedRect.br().x && this.rect.br().y >= shiftedRect.br().y;
        }

        public boolean isInner(Rect shiftedRect) {
            return this.rect.tl().x >= shiftedRect.tl().x && this.rect.tl().y >= shiftedRect.tl().y && this.rect.br().x <= shiftedRect.br().x && this.rect.br().y <= shiftedRect.br().y;
        }

        public double getX() {
            return this.rect.x;
        }
    }
}

