/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.RectToolsMapper;
import org.genericsystem.reinforcer.tools.GSRect;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class RectDetector {
    private Img img;

    public RectDetector(Img img) {
        this.img = img;
    }

    public List<GSRect> getRects(int minArea, int blockSize, double c, Size close) {
        return this.applyNoOverlapsConstraint(this.getRects(this.getClosed(blockSize, c, close), minArea));
    }

    private Img getClosed(int blockSize, double c, Size close) {
        return this.img.bilateralFilter(5, 80.0, 80.0).adaptativeGaussianInvThreshold(blockSize, c).morphologyEx(3, 0, close);
    }

    private List<GSRect> getRects(Img closed, int minArea) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)closed.getSrc(), contours, (Mat)new Mat(), (int)0, (int)2);
        return RectToolsMapper.rectToGSRect(contours.stream().filter(contour -> Imgproc.contourArea((Mat)contour) > (double)minArea).map(c -> Imgproc.boundingRect((MatOfPoint)c)).collect(Collectors.toList()));
    }

    private List<GSRect> applyNoOverlapsConstraint(List<GSRect> rects) {
        Collections.reverse(rects);
        ArrayList<GSRect> result = new ArrayList<GSRect>();
        ListIterator<GSRect> it = rects.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            GSRect rect = it.next();
            if (!rects.subList(i, rects.size() - 1).stream().filter(r -> r != rect).noneMatch(r -> r.isOverlapping(rect))) continue;
            result.add(rect);
        }
        return result;
    }
}

