/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.List;
import org.genericsystem.cv.Lines;

public class Calibrated {
    private final double x;
    private final double y;
    final double z;

    public Calibrated(double[] vp, double[] pp, double f) {
        double[] calibratedxyz = Calibrated.calibrate(vp, pp, f);
        if (calibratedxyz[2] < 0.0) {
            calibratedxyz[0] = -calibratedxyz[0];
            calibratedxyz[1] = -calibratedxyz[1];
            calibratedxyz[2] = -calibratedxyz[2];
        }
        this.x = calibratedxyz[0];
        this.y = calibratedxyz[1];
        this.z = calibratedxyz[2];
    }

    public Calibrated(double[] calibratedxyz) {
        if (calibratedxyz[2] < 0.0) {
            calibratedxyz[0] = -calibratedxyz[0];
            calibratedxyz[1] = -calibratedxyz[1];
            calibratedxyz[2] = -calibratedxyz[2];
        }
        this.x = calibratedxyz[0];
        this.y = calibratedxyz[1];
        this.z = calibratedxyz[2];
    }

    public double[] getCalibratexyz() {
        return new double[]{this.getX(), this.getY(), this.z};
    }

    Calibrated dumpXyz(double[] xyz, int dumpSize) {
        return new Calibrated(new double[]{((double)(dumpSize - 1) * this.getX() + xyz[0]) / (double)dumpSize, ((double)(dumpSize - 1) * this.getY() + xyz[1]) / (double)dumpSize, ((double)(dumpSize - 1) * this.z + xyz[2]) / (double)dumpSize});
    }

    public static double[] calibrate(double[] vpImg, double[] pp, double f) {
        double[] vp = new double[]{vpImg[0] / vpImg[2] - pp[0], vpImg[1] / vpImg[2] - pp[1], f};
        if (vp[2] == 0.0) {
            vp[2] = 0.0011;
        }
        double N = Math.sqrt(vp[0] * vp[0] + vp[1] * vp[1] + vp[2] * vp[2]);
        vp[0] = vp[0] * (1.0 / N);
        vp[1] = vp[1] * (1.0 / N);
        vp[2] = vp[2] * (1.0 / N);
        if (vp[2] < 0.0) {
            vp[0] = -vp[0];
            vp[1] = -vp[1];
            vp[2] = -vp[2];
        }
        return vp;
    }

    public double[] uncalibrate(double[] pp, double f) {
        double[] result = new double[]{this.getX() * f / this.z + pp[0], this.getY() * f / this.z + pp[1], 1.0};
        return result;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public static class AngleCalibrated
    extends Calibrated {
        final double theta = Math.atan2(this.getY(), this.getX());
        final double phi = Math.acos(this.z);

        public AngleCalibrated(double[] vp, double[] pp, double f) {
            super(vp, pp, f);
        }

        public AngleCalibrated(double[] calibratedxyz, Object nullObject) {
            super(calibratedxyz);
        }

        public AngleCalibrated(double theta, double phi) {
            this(new double[]{theta, phi});
        }

        public AngleCalibrated(double[] tethaPhi) {
            super(new double[]{Math.sin(tethaPhi[1]) * Math.cos(tethaPhi[0]), Math.sin(tethaPhi[1]) * Math.sin(tethaPhi[0]), Math.cos(tethaPhi[1])});
        }

        public double getTheta() {
            return this.theta;
        }

        public double getPhi() {
            return this.phi;
        }

        public double[] getThetaPhi() {
            return new double[]{this.theta, this.phi};
        }

        public AngleCalibrated dumpThetaPhi(double[] tethaPhi, int dumpSize) {
            return new AngleCalibrated(new double[]{((double)(dumpSize - 1) * this.theta + tethaPhi[0]) / (double)dumpSize, ((double)(dumpSize - 1) * this.phi + tethaPhi[1]) / (double)dumpSize});
        }

        @Override
        AngleCalibrated dumpXyz(double[] xyz, int dumpSize) {
            return new AngleCalibrated(new double[]{((double)(dumpSize - 1) * this.getX() + xyz[0]) / (double)dumpSize, ((double)(dumpSize - 1) * this.getY() + xyz[1]) / (double)dumpSize, ((double)(dumpSize - 1) * this.z + xyz[2]) / (double)dumpSize}, null);
        }

        public AngleCalibrated getOrthoFromAngle(double lambda) {
            double[] vp1 = this.getCalibratexyz();
            double k1 = vp1[0] * Math.sin(lambda) + vp1[1] * Math.cos(lambda);
            double k2 = vp1[2];
            double phi = Math.atan(-k2 / k1);
            double[] result = new double[]{Math.sin(phi) * Math.sin(lambda), Math.sin(phi) * Math.cos(lambda), Math.cos(phi)};
            if (result[2] == 0.0) {
                result[2] = 0.0011;
            }
            double N = Math.sqrt(result[0] * result[0] + result[1] * result[1] + result[2] * result[2]);
            result[0] = result[0] * (1.0 / N);
            result[1] = result[1] * (1.0 / N);
            result[2] = result[2] * (1.0 / N);
            return new AngleCalibrated(result, null);
        }

        public AngleCalibrated getOrthoFromVps(Calibrated calibrated2) {
            double[] vp2;
            double[] vp1 = this.getCalibratexyz();
            double[] vp3 = AngleCalibrated.cross(vp1, vp2 = calibrated2.getCalibratexyz());
            if (vp3[2] == 0.0) {
                vp3[2] = 0.0011;
            }
            double N = Math.sqrt(vp3[0] * vp3[0] + vp3[1] * vp3[1] + vp3[2] * vp3[2]);
            vp3[0] = vp3[0] * (1.0 / N);
            vp3[1] = vp3[1] * (1.0 / N);
            vp3[2] = vp3[2] * (1.0 / N);
            return new AngleCalibrated(vp3, null);
        }

        static double[] cross(double[] a, double[] b) {
            return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        }

        public String toString() {
            return "(" + this.theta * 180.0 / Math.PI + "\u00b0, " + this.phi * 180.0 / Math.PI + "\u00b0)";
        }

        public double distance(List<Lines.Line> lines, double[] pp, double f) {
            double[] uncalibrate = this.uncalibrate(pp, f);
            double error = 0.0;
            for (Lines.Line line : lines) {
                error += Math.pow(Math.min(AngleCalibrated.distance(uncalibrate, line), 0.3) * line.size(), 2.0);
            }
            return error;
        }

        public double distance(Lines.Line line, double[] pp, double f) {
            return Math.pow(Math.min(AngleCalibrated.distance(this.uncalibrate(pp, f), line), 0.3) * line.size(), 2.0);
        }

        public static double distance(double[] vp, Lines.Line line) {
            double dy = line.y1 - line.y2;
            double dx = line.x2 - line.x1;
            double dz = line.y1 * line.x2 - line.x1 * line.y2;
            double norm = Math.sqrt(dy * dy + dx * dx + dz * dz);
            double n0 = -dx / norm;
            double n1 = dy / norm;
            double nNorm = Math.sqrt(n0 * n0 + n1 * n1);
            double[] midPoint = new double[]{(line.x1 + line.x2) / 2.0, (line.y1 + line.y2) / 2.0, 1.0};
            double r0 = vp[1] * midPoint[2] - midPoint[1];
            double r1 = midPoint[0] - vp[0] * midPoint[2];
            double rNorm = Math.sqrt(r0 * r0 + r1 * r1);
            double num = r0 * n0 + r1 * n1;
            if (num < 0.0) {
                num = -num;
            }
            double d = 0.0;
            if (nNorm != 0.0 && rNorm != 0.0) {
                d = num / (nNorm * rNorm);
            }
            return d;
        }
    }
}

