/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import javafx.application.Application;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class DraggingRectangle
extends Application {
    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        Pane root = new Pane();
        Rectangle rect = this.createDraggableRectangle(200.0, 200.0, 400.0, 300.0);
        rect.setFill((Paint)Color.NAVY);
        root.getChildren().add((Object)rect);
        Scene scene = new Scene((Parent)root, 800.0, 800.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private Rectangle createDraggableRectangle(double x, double y, double width, double height) {
        double handleRadius = 10.0;
        Rectangle rect = new Rectangle(x, y, width, height);
        Circle resizeHandleNW = new Circle(10.0, (Paint)Color.GOLD);
        resizeHandleNW.centerXProperty().bind((ObservableValue)rect.xProperty());
        resizeHandleNW.centerYProperty().bind((ObservableValue)rect.yProperty());
        Circle resizeHandleSE = new Circle(10.0, (Paint)Color.GOLD);
        resizeHandleSE.centerXProperty().bind((ObservableValue)rect.xProperty().add((ObservableNumberValue)rect.widthProperty()));
        resizeHandleSE.centerYProperty().bind((ObservableValue)rect.yProperty().add((ObservableNumberValue)rect.heightProperty()));
        Circle moveHandle = new Circle(10.0, (Paint)Color.GOLD);
        moveHandle.centerXProperty().bind((ObservableValue)rect.xProperty().add((ObservableNumberValue)rect.widthProperty().divide(2)));
        moveHandle.centerYProperty().bind((ObservableValue)rect.yProperty().add((ObservableNumberValue)rect.heightProperty()));
        rect.parentProperty().addListener((obs, oldParent, newParent) -> {
            for (Circle c : Arrays.asList(resizeHandleNW, resizeHandleSE, moveHandle)) {
                Pane currentParent = (Pane)c.getParent();
                if (currentParent != null) {
                    currentParent.getChildren().remove((Object)c);
                }
                ((Pane)newParent).getChildren().add((Object)c);
            }
        });
        Wrapper<Point2D> mouseLocation = new Wrapper<Point2D>();
        this.setUpDragging(resizeHandleNW, mouseLocation);
        this.setUpDragging(resizeHandleSE, mouseLocation);
        this.setUpDragging(moveHandle, mouseLocation);
        resizeHandleNW.setOnMouseDragged(event -> {
            if (mouseLocation.value != null) {
                double newY;
                double deltaX = event.getSceneX() - ((Point2D)mouseLocation.value).getX();
                double deltaY = event.getSceneY() - ((Point2D)mouseLocation.value).getY();
                double newX = rect.getX() + deltaX;
                if (newX >= 10.0 && newX <= rect.getX() + rect.getWidth() - 10.0) {
                    rect.setX(newX);
                    rect.setWidth(rect.getWidth() - deltaX);
                }
                if ((newY = rect.getY() + deltaY) >= 10.0 && newY <= rect.getY() + rect.getHeight() - 10.0) {
                    rect.setY(newY);
                    rect.setHeight(rect.getHeight() - deltaY);
                }
                mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
            }
        });
        resizeHandleSE.setOnMouseDragged(event -> {
            if (mouseLocation.value != null) {
                double newMaxY;
                double deltaX = event.getSceneX() - ((Point2D)mouseLocation.value).getX();
                double deltaY = event.getSceneY() - ((Point2D)mouseLocation.value).getY();
                double newMaxX = rect.getX() + rect.getWidth() + deltaX;
                if (newMaxX >= rect.getX() && newMaxX <= rect.getParent().getBoundsInLocal().getWidth() - 10.0) {
                    rect.setWidth(rect.getWidth() + deltaX);
                }
                if ((newMaxY = rect.getY() + rect.getHeight() + deltaY) >= rect.getY() && newMaxY <= rect.getParent().getBoundsInLocal().getHeight() - 10.0) {
                    rect.setHeight(rect.getHeight() + deltaY);
                }
                mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
            }
        });
        moveHandle.setOnMouseDragged(event -> {
            if (mouseLocation.value != null) {
                double deltaX = event.getSceneX() - ((Point2D)mouseLocation.value).getX();
                double deltaY = event.getSceneY() - ((Point2D)mouseLocation.value).getY();
                double newX = rect.getX() + deltaX;
                double newMaxX = newX + rect.getWidth();
                if (newX >= 10.0 && newMaxX <= rect.getParent().getBoundsInLocal().getWidth() - 10.0) {
                    rect.setX(newX);
                }
                double newY = rect.getY() + deltaY;
                double newMaxY = newY + rect.getHeight();
                if (newY >= 10.0 && newMaxY <= rect.getParent().getBoundsInLocal().getHeight() - 10.0) {
                    rect.setY(newY);
                }
                mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
            }
        });
        return rect;
    }

    private void setUpDragging(Circle circle, Wrapper<Point2D> mouseLocation) {
        circle.setOnDragDetected(event -> {
            circle.getParent().setCursor(Cursor.CLOSED_HAND);
            mouseLocation.value = new Point2D(event.getSceneX(), event.getSceneY());
        });
        circle.setOnMouseReleased(event -> {
            circle.getParent().setCursor(Cursor.DEFAULT);
            mouseLocation.value = null;
        });
    }

    static class Wrapper<T> {
        T value;

        Wrapper() {
        }
    }
}

