/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.genericsystem.cv.utils.OCRPlasty;
import org.genericsystem.cv.utils.RandomStringMutator;
import org.genericsystem.reinforcer.tools.StringCompare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCRPlastyScorer {
    private static final double MUTATION_PERCENTAGE = 0.05;
    private static Random rand = new Random(System.currentTimeMillis());
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void main(String[] args) {
        OCRPlastyScorer.computeAll();
    }

    private static void computeAll() {
        ArrayList<Results> total = new ArrayList<Results>();
        for (String s : OCRPlastyScorer.getReferenceStrings()) {
            List<Results> results = OCRPlastyScorer.computeScore(s);
            total.addAll(results);
        }
        for (OCRPlasty.RANSAC option : OCRPlasty.RANSAC.values()) {
            List<Double> scores = total.stream().filter(res -> option.name().equals(res.getRansacMethod())).map(Results::getSimilarity).collect(Collectors.toList());
            Statistics scoreStat = new Statistics(scores);
            logger.info("SCORE for {} {}", (Object)option.name(), (Object)scoreStat.format());
            List<Double> durations = total.stream().filter(res -> option.name().equals(res.getRansacMethod())).map(res -> Long.valueOf(res.getDuration()).doubleValue() / (double)res.getOriginal().length()).map(x -> x / 1000000.0).collect(Collectors.toList());
            Statistics durationStat = new Statistics(durations);
            logger.info("DURATION (PER CHAR) for {} (ms) {}", (Object)option.name(), (Object)durationStat.format());
        }
    }

    private static List<Results> computeScore(String testString) {
        ArrayList<Results> results = new ArrayList<Results>();
        List<String> mutateds = OCRPlastyScorer.getMutatedStrings(testString, 10);
        mutateds.forEach(System.err::println);
        for (OCRPlasty.RANSAC option : OCRPlasty.RANSAC.values()) {
            long start = System.nanoTime();
            String corrected = OCRPlastyScorer.getCorrectedString(mutateds, option);
            long stop = System.nanoTime();
            double similarity = OCRPlastyScorer.getSimilarity(testString, corrected);
            long duration = stop - start;
            results.add(new Results(option.name(), duration, similarity, testString, corrected));
        }
        return results;
    }

    private static List<String> getReferenceStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Nom :");
        strings.add("Pr\u00e9nom :");
        strings.add("IDFRABABOUN<<<<<<<<<<<<<<<<<<<772354");
        strings.add("N\u00e9(e) le :");
        strings.add("24.07.1976");
        strings.add("PR\u00c9FECTURE DE SEINE-MARITIME (76)");
        strings.add("The quick, brown fox jumps over a lazy dog");
        strings.add("But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system");
        strings.add("The European languages are members of the same family.");
        strings.add("Their separate existence is a myth");
        strings.add("For science, music, sport, etc, Europe uses the same vocabulary");
        strings.add("The languages only differ in their grammar, their pronunciation and their most common words.");
        strings.add("One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin.");
        strings.add("He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections.");
        strings.add("A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.");
        strings.add("I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine");
        strings.add("Brick quiz whangs jumpy veldt fox. ");
        strings.add("Waltz, bad nymph, for quick jigs vex! Fox nymphs grab quick-jived waltz.");
        strings.add("Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts");
        strings.add("Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.");
        strings.add(" A small river named Duden flows by their place and supplies it with the necessary regelialia");
        return strings.stream().map(s -> s.trim()).collect(Collectors.toList());
    }

    private static double getSimilarity(String string1, String string2) {
        return StringCompare.similarity(Arrays.asList(string1, string2), (StringCompare.SIMILARITY)StringCompare.SIMILARITY.LEVENSHTEIN);
    }

    private static List<String> getMutatedStrings(String string, int size) {
        ArrayList<String> results = new ArrayList<String>(size + 1);
        results.add(".");
        IntStream.rangeClosed(0, size).forEach(i -> {
            int maxMutations = 1 + rand.nextInt((int)(1L + Math.round((double)string.length() * 0.05)));
            results.add(RandomStringMutator.mutate(string, maxMutations));
        });
        return results;
    }

    private static String getCorrectedString(List<String> labels, OCRPlasty.RANSAC options) {
        Optional<Object> result = Optional.empty();
        try {
            result = OCRPlasty.correctStrings(labels, options);
        }
        catch (Exception e) {
            logger.error("Unable to get a RANSAC model");
            result = OCRPlasty.correctStrings(labels, OCRPlasty.RANSAC.NONE);
        }
        return result.orElse("");
    }

    public static class Statistics {
        private List<Double> values;
        private boolean computed;
        private double min;
        private double max;
        private double average;
        private double sd;
        private double median;

        public Statistics(List<Double> values) {
            this.values = values;
            this.compute();
            this.computed = true;
        }

        private void compute() {
            Collections.sort(this.values, (d1, d2) -> Double.compare(d1, d2));
            this.min = this.values.get(0);
            this.max = this.values.get(this.values.size() - 1);
            this.average = this.values.stream().mapToDouble(x -> x).average().getAsDouble();
            this.sd = Math.sqrt(this.values.stream().mapToDouble(x -> Math.pow(x - this.average, 2.0)).average().getAsDouble());
            int middle = this.values.size() / 2;
            this.median = middle % 2 == 1 ? this.values.get(middle).doubleValue() : DoubleStream.of(this.values.get(middle), this.values.get(middle - 1)).average().getAsDouble();
        }

        public String format() {
            if (!this.computed) {
                this.compute();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("\n");
            sb.append(String.format("-> %10s = %.3f", "average", this.average)).append("\n");
            sb.append(String.format("-> %10s = %.3f", "median", this.median)).append("\n");
            sb.append(String.format("-> %10s = %.3f", "min", this.min)).append("\n");
            sb.append(String.format("-> %10s = %.3f", "max", this.max)).append("\n");
            sb.append(String.format("-> %10s = %.3f", "sd", this.sd)).append("\n");
            return sb.toString();
        }

        public double getMin() {
            if (!this.computed) {
                this.compute();
            }
            return this.min;
        }

        public double getMax() {
            if (!this.computed) {
                this.compute();
            }
            return this.max;
        }

        public double getAverage() {
            if (!this.computed) {
                this.compute();
            }
            return this.average;
        }

        public double getSd() {
            if (!this.computed) {
                this.compute();
            }
            return this.sd;
        }

        public double getMedian() {
            if (!this.computed) {
                this.compute();
            }
            return this.median;
        }
    }

    public static class Results {
        private long duration;
        private double similarity;
        private String original;
        private String corrected;
        private String ransacMethod;

        public Results(String ransacMethod, long duration, double similarity, String original, String corrected) {
            this.duration = duration;
            this.similarity = similarity;
            this.original = original;
            this.corrected = corrected;
            this.ransacMethod = ransacMethod;
        }

        public void printResults() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n");
            sb.append("--------------------------------------------------------").append("\n");
            sb.append("Method: ").append(this.ransacMethod).append("\n");
            sb.append("\n");
            sb.append("-> similarity = ").append(this.similarity).append("\n");
            sb.append("-> duration = ").append(String.format("%,d ms", this.duration / 1000000L)).append("\n");
            sb.append("\n");
            sb.append("Original:").append("\n").append(this.original).append("\n");
            sb.append("Corrected:").append("\n").append(this.corrected).append("\n");
            sb.append("--------------------------------------------------------").append("\n");
            logger.info(sb.toString());
        }

        public long getDuration() {
            return this.duration;
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getCorrected() {
            return this.corrected;
        }

        public String getRansacMethod() {
            return this.ransacMethod;
        }
    }
}

