/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.genericsystem.cv.utils.Ransac;
import org.genericsystem.reinforcer.tools.LetterPairSimilarity;
import org.genericsystem.reinforcer.tools.Levenshtein;
import org.genericsystem.reinforcer.tools.StringCompare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCRPlasty {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void main(String[] args) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("had I expressed the agony I frequentl felt he would have been taught to long for its alleviati");
        labels.add("gad I sed the agony I fefjuently felt he would have been to long for its alleviafcion");
        labels.add("had I expressed tbe agony I frejuently felt he would have been taught to long for its alleviationq");
        labels.add("had I expresset th agny I frequently feltu he wouald have ben taufht to lng fr its alevation");
        labels.add("had I # tly feltu he wouald have ben taufht to lng fr iets alevation");
        labels.add("fger gezrgze ertg");
        labels.add("");
        labels.add(".");
        for (RANSAC option : RANSAC.values()) {
            System.out.println(option.name());
            System.out.println(OCRPlasty.correctStrings(new ArrayList<String>(labels), option).orElse("-- none --"));
            for (StringCompare.SIMILARITY method : StringCompare.SIMILARITY.values()) {
                System.out.println(String.format("Similarity (%s): %.3f", method.name(), StringCompare.similarity(labels, (StringCompare.SIMILARITY)method)));
            }
        }
    }

    public static Optional<String> correctStrings(List<String> labels, RANSAC options) {
        return OCRPlasty.correctStrings(labels, options, StringCompare.SIMILARITY.LEVENSHTEIN);
    }

    public static Optional<String> correctStrings(List<String> labels, RANSAC options, StringCompare.SIMILARITY method) {
        Tuple res = OCRPlasty.doStringCorrection(labels, options, method, false);
        return res.getString();
    }

    public static Tuple correctStringsAndGetOutliers(List<String> labels, RANSAC options) {
        return OCRPlasty.doStringCorrection(labels, options, StringCompare.SIMILARITY.LEVENSHTEIN, true);
    }

    public static Tuple correctStringsAndGetOutliers(List<String> labels, RANSAC options, StringCompare.SIMILARITY method) {
        return OCRPlasty.doStringCorrection(labels, options, method, true);
    }

    private static Tuple doStringCorrection(List<String> labels, RANSAC options, StringCompare.SIMILARITY method, boolean needOutliers) {
        List<String> trimmed = labels.stream().map(s -> s.trim()).filter(s -> s.length() > 0).collect(Collectors.toList());
        Function<Collection<String>, Ransac.Model<String>> modelProvider = null;
        Set<String> outliers = Collections.emptySet();
        Optional<String> result = Optional.empty();
        double confidence = 0.0;
        double error = 1.0;
        switch (options) {
            default: {
                result = OCRPlasty.ocrPlasty(trimmed);
                confidence = StringCompare.similarity(trimmed, (StringCompare.SIMILARITY)method);
            }
            case LCS: {
                modelProvider = OCRPlasty.getModelProviderMaxLcs();
                error = 1.0;
                break;
            }
            case DIVERSITY: {
                modelProvider = OCRPlasty.getModelProviderDiversity();
                error = 0.1;
                break;
            }
            case LEVENSHTEIN: {
                modelProvider = OCRPlasty.getModelProviderLevenshtein();
                error = 1.0;
                break;
            }
            case NORM_LEVENSHTEIN: {
                modelProvider = OCRPlasty.getModelProviderNormLevenshtein();
                error = 0.1;
            }
        }
        if (modelProvider != null) {
            List<String> inliers = OCRPlasty.getRansacInliers(trimmed, modelProvider, error);
            HashSet<String> inliersSet = new HashSet<String>(inliers);
            confidence = StringCompare.similarity(inliers, (StringCompare.SIMILARITY)method);
            Optional<String> optional = result = inliers.isEmpty() ? OCRPlasty.ocrPlasty(trimmed) : OCRPlasty.ocrPlasty(inliers);
            if (inliers.isEmpty() || !needOutliers) {
                outliers = Collections.emptySet();
            } else {
                Map partitionnedMap = trimmed.stream().collect(Collectors.partitioningBy(s -> inliersSet.contains(s), Collectors.toSet()));
                outliers = partitionnedMap.get(false);
            }
        }
        return new Tuple(result, outliers, confidence);
    }

    private static Optional<String> ocrPlasty(List<String> labels) {
        if (labels == null) {
            throw new IllegalArgumentException("The list cannot be null");
        }
        if (labels.isEmpty()) {
            return Optional.empty();
        }
        String common = OCRPlasty.longestCommonSubsequence(labels);
        String consensus = "";
        for (int i = 0; i < common.length() + 1; ++i) {
            ArrayList<String> candidates = new ArrayList<String>();
            for (int label = 0; label < labels.size(); ++label) {
                List<String> is = i < common.length() ? OCRPlasty.interString(labels.get(label), common.charAt(i)) : OCRPlasty.endString(labels.get(label));
                labels.set(label, is.get(0));
                candidates.add(is.get(1));
            }
            consensus = consensus + OCRPlasty.selectBest(candidates);
            if (i >= common.length() - 1) continue;
            consensus = consensus + common.charAt(i);
        }
        return consensus.isEmpty() ? Optional.empty() : Optional.of(consensus);
    }

    private static List<String> getRansacInliers(List<String> labels, Function<Collection<String>, Ransac.Model<String>> modelProvider, double error) {
        List trimmed = labels.stream().map(s -> s.trim()).filter(s -> s.length() > 0).collect(Collectors.toList());
        if (trimmed.isEmpty()) {
            return Collections.emptyList();
        }
        int minSize = 1 + trimmed.size() / 2;
        if (minSize < 2) {
            return Collections.emptyList();
        }
        Map<Object, Object> bestFit = new HashMap();
        int maxAttempts = 10;
        for (int i = 1; bestFit.size() <= 3 && i <= maxAttempts; ++i) {
            try {
                Ransac ransac = new Ransac(trimmed, modelProvider, 2, 10 * i, error, minSize);
                bestFit = ransac.getBestDataSet();
                continue;
            }
            catch (Exception e) {
                logger.trace("Can't get a good model. Increase the error margin to {}", (Object)(error *= 1.5));
            }
        }
        return bestFit.values().stream().collect(Collectors.toList());
    }

    private static Function<Collection<String>, Ransac.Model<String>> getModelProviderMaxLcs() {
        return datas -> {
            Iterator it = datas.iterator();
            String subsequence = null;
            if (it.hasNext()) {
                subsequence = (String)it.next();
            }
            while (it.hasNext()) {
                String label = (String)it.next();
                if (subsequence.isEmpty() || label.isEmpty()) continue;
                subsequence = OCRPlasty.lcs(subsequence, label);
            }
            final String common = subsequence;
            return new OcrModel(){

                @Override
                public double computeError(String data) {
                    this.error = Levenshtein.distance((String)data, (String)common);
                    return this.error;
                }
            };
        };
    }

    private static Function<Collection<String>, Ransac.Model<String>> getModelProviderDiversity() {
        return datas -> new OcrModel((Collection)datas){
            final /* synthetic */ Collection val$datas;
            {
                this.val$datas = collection;
            }

            @Override
            public double computeError(String data) {
                this.error = 0.0;
                for (String s : this.val$datas) {
                    double sim = LetterPairSimilarity.compareStrings((String)data, (String)s);
                    this.error += 1.0 - sim;
                }
                return this.error / (double)this.val$datas.size();
            }
        };
    }

    private static Function<Collection<String>, Ransac.Model<String>> getModelProviderLevenshtein() {
        return datas -> new OcrModel((Collection)datas){
            final /* synthetic */ Collection val$datas;
            {
                this.val$datas = collection;
            }

            @Override
            public double computeError(String data) {
                this.error = 0.0;
                for (String s : this.val$datas) {
                    this.error += (double)Levenshtein.distance((String)data, (String)s);
                }
                return this.error / (double)this.val$datas.size();
            }
        };
    }

    private static Function<Collection<String>, Ransac.Model<String>> getModelProviderNormLevenshtein() {
        return datas -> new OcrModel((Collection)datas){
            final /* synthetic */ Collection val$datas;
            {
                this.val$datas = collection;
            }

            @Override
            public double computeError(String data) {
                this.error = 0.0;
                for (String s : this.val$datas) {
                    this.error += Levenshtein.normedDistance((String)data, (String)s);
                }
                return this.error / (double)this.val$datas.size();
            }
        };
    }

    private static String selectBest(List<String> candidates) {
        Map<String, Long> occurrences = candidates.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        long maxOcc = Collections.max(occurrences.values());
        if (maxOcc > 1L) {
            return occurrences.entrySet().stream().filter(entry -> ((Long)entry.getValue()).equals(maxOcc)).findFirst().map(e -> (String)e.getKey()).orElse(OCRPlasty.leastDifferent(candidates));
        }
        return OCRPlasty.leastDifferent(candidates);
    }

    private static List<String> interString(String string, char c) {
        String inter = "";
        int index = string.indexOf(c);
        if (index > 0) {
            inter = string.substring(0, index);
        }
        string = string.substring(index + 1);
        ArrayList<String> is = new ArrayList<String>();
        is.add(string);
        is.add(inter);
        return is;
    }

    private static List<String> endString(String string) {
        ArrayList<String> is = new ArrayList<String>();
        is.add("");
        is.add(string);
        return is;
    }

    private static String leastDifferent(List<String> strings) {
        int n = strings.size();
        int[][] distances = new int[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int dist;
                if (j <= i) continue;
                distances[i][j] = dist = Levenshtein.distance((String)strings.get(i), (String)strings.get(j));
                distances[j][i] = dist;
            }
            distances[i][i] = 0;
        }
        int minVal = Integer.MAX_VALUE;
        String leastDiff = "";
        for (int i = 0; i < n; ++i) {
            int val = IntStream.of(distances[i]).sum();
            if (val >= minVal) continue;
            leastDiff = strings.get(i);
            minVal = val;
        }
        return leastDiff;
    }

    private static String longestCommonSubsequence(List<String> labels) {
        String subsequence = labels.get(0).trim();
        for (int i = 1; i < labels.size(); ++i) {
            if (subsequence.isEmpty() || labels.get(i).trim().isEmpty()) continue;
            subsequence = OCRPlasty.lcs(subsequence, labels.get(i).trim());
        }
        return subsequence;
    }

    private static String lcs(String stringX, String stringY) {
        int index;
        int m = stringX.length();
        int n = stringY.length();
        int[][] mat = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= n; ++j) {
                mat[i][j] = i == 0 || j == 0 ? 0 : (stringX.charAt(i - 1) == stringY.charAt(j - 1) ? mat[i - 1][j - 1] + 1 : Math.max(mat[i - 1][j], mat[i][j - 1]));
            }
        }
        int temp = index = mat[m][n];
        char[] lcs = new char[index + 1];
        lcs[index] = '\u0000';
        int i = m;
        int j = n;
        while (i > 0 && j > 0) {
            if (stringX.charAt(i - 1) == stringY.charAt(j - 1)) {
                lcs[index - 1] = stringX.charAt(i - 1);
                --i;
                --j;
                --index;
                continue;
            }
            if (mat[i - 1][j] > mat[i][j - 1]) {
                --i;
                continue;
            }
            --j;
        }
        String lcsValue = "";
        for (int k = 0; k <= temp; ++k) {
            lcsValue = lcsValue + lcs[k];
        }
        return lcsValue;
    }

    public static abstract class OcrModel
    implements Ransac.Model<String> {
        protected double error = 0.0;

        @Override
        public double computeGlobalError(List<String> datas, Collection<String> consensusDatas) {
            double globalError = 0.0;
            for (String s : consensusDatas) {
                globalError += Math.pow(this.computeError(s), 2.0);
            }
            return Math.sqrt(globalError) / (double)consensusDatas.size();
        }

        @Override
        public Object[] getParams() {
            return new Object[]{this.error};
        }
    }

    public static class Tuple {
        private final Optional<String> string;
        private final Set<String> outliers;
        private final double confidence;

        public Tuple(Optional<String> string, Set<String> outliers, double confidence) {
            this.string = string;
            this.outliers = outliers;
            this.confidence = confidence;
        }

        public Optional<String> getString() {
            return this.string;
        }

        public Set<String> getOutliers() {
            return this.outliers;
        }

        public double getConfidence() {
            return this.confidence;
        }
    }

    public static enum RANSAC {
        NONE,
        LCS,
        DIVERSITY,
        LEVENSHTEIN,
        NORM_LEVENSHTEIN;

    }
}

