/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.textdetection;

import java.util.ArrayList;
import java.util.List;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.MSER;
import org.opencv.imgproc.Imgproc;
import org.opencv.imgproc.Moments;
import org.opencv.utils.Converters;

public class RobustTextDetectorManager {
    private final Mat gray;
    private Mat mserMask;
    private Mat cannyMask;
    private Mat mserAndCannyMask;
    private Mat mserAndCannyGrownMask;
    private Mat edgeEnhancedMserMask;
    private Mat edgeEnhancedMserCCMask;
    private Mat filteredStrokeWidthMask;
    private final int delta;

    public RobustTextDetectorManager(Mat gray, int delta) {
        this.gray = gray;
        this.delta = delta;
    }

    public Mat getMserMask() {
        return this.mserMask != null ? this.mserMask : (this.mserMask = this.buildMserMask(this.gray));
    }

    private Mat buildMserMask(Mat frame) {
        MSER detector = MSER.create((int)this.delta, (int)10, (int)1000, (double)0.25, (double)0.2, (int)200, (double)1.01, (double)0.03, (int)5);
        ArrayList regions = new ArrayList();
        MatOfRect mor = new MatOfRect();
        detector.detectRegions(frame, regions, mor);
        Mat mserMask = new Mat(frame.size(), CvType.CV_8UC1, new Scalar(0.0));
        for (MatOfPoint mop : regions) {
            for (Point p : mop.toArray()) {
                mserMask.put((int)p.y, (int)p.x, new double[]{255.0});
            }
        }
        return mserMask;
    }

    public Mat getMserAndCannyMask() {
        return this.mserAndCannyMask != null ? this.mserAndCannyMask : (this.mserAndCannyMask = this.buildMserAndCannyMask());
    }

    public Mat getCannyMask() {
        return this.cannyMask != null ? this.cannyMask : (this.cannyMask = this.buildCannyMask());
    }

    private Mat buildCannyMask() {
        Mat canny = new Mat();
        Imgproc.Canny((Mat)this.gray, (Mat)canny, (double)20.0, (double)80.0, (int)3, (boolean)false);
        return canny;
    }

    private Mat buildMserAndCannyMask() {
        Mat mserAndCanny = new Mat();
        Core.bitwise_and((Mat)this.getMserMask(), (Mat)this.getCannyMask(), (Mat)mserAndCanny);
        return mserAndCanny;
    }

    public Mat getMserAndCannyGrownMask() {
        return this.mserAndCannyGrownMask != null ? this.mserAndCannyGrownMask : (this.mserAndCannyGrownMask = this.buildMserAndCannyGrownMask());
    }

    private Mat buildMserAndCannyGrownMask() {
        Mat sobelx = new Mat();
        Imgproc.Sobel((Mat)this.gray, (Mat)sobelx, (int)6, (int)1, (int)0, (int)-1, (double)1.0, (double)0.0);
        Mat sobely = new Mat();
        Imgproc.Sobel((Mat)this.gray, (Mat)sobely, (int)6, (int)0, (int)1, (int)-1, (double)1.0, (double)0.0);
        Mat gradAngle = new Mat();
        Mat gradMag = new Mat();
        Core.cartToPolar((Mat)sobelx, (Mat)sobely, (Mat)gradMag, (Mat)gradAngle, (boolean)false);
        Mat edgeMser = this.getMserAndCannyMask();
        Mat edgeGrown = new Mat();
        edgeMser.copyTo(edgeGrown);
        for (int i = 0; i < edgeGrown.height(); ++i) {
            block1: for (int j = 0; j < edgeGrown.width(); ++j) {
                if (edgeMser.get(i, j)[0] == 0.0) continue;
                int x1 = j;
                int y1 = i;
                for (int l = 0; l < 2; ++l) {
                    int length = l + 1;
                    double angle = gradAngle.get(y1, x1)[0];
                    x1 = j + (int)Math.round((double)length * Math.cos(angle));
                    y1 = i + (int)Math.round((double)length * Math.sin(angle));
                    if (x1 >= edgeGrown.width() || y1 >= edgeGrown.height() || x1 < 0 || y1 < 0) continue block1;
                    edgeGrown.put(y1, x1, new double[]{255.0});
                }
            }
        }
        return edgeGrown;
    }

    public Mat getEdgeEnhancedMserMask() {
        return this.edgeEnhancedMserMask != null ? this.edgeEnhancedMserMask : (this.edgeEnhancedMserMask = this.buildEdgedEnhancedMserMask());
    }

    public Mat buildEdgedEnhancedMserMask() {
        Mat notMserAndCannyGrown = new Mat();
        Core.bitwise_not((Mat)this.getMserAndCannyGrownMask(), (Mat)notMserAndCannyGrown);
        Mat edgeEnhancedMser = new Mat();
        Core.bitwise_and((Mat)notMserAndCannyGrown, (Mat)this.mserMask, (Mat)edgeEnhancedMser);
        return edgeEnhancedMser;
    }

    public Mat getEdgeEnhanceMserCCMask() {
        return this.edgeEnhancedMserCCMask != null ? this.edgeEnhancedMserCCMask : (this.edgeEnhancedMserCCMask = this.buildEdgeEnhancedMserCCMask());
    }

    private Mat buildEdgeEnhancedMserCCMask() {
        Mat labels = new Mat();
        Mat stats = new Mat();
        Mat centroid = new Mat();
        int labelsIds = Imgproc.connectedComponentsWithStats((Mat)this.getEdgeEnhancedMserMask(), (Mat)labels, (Mat)stats, (Mat)centroid, (int)8, (int)4);
        Mat edgeEnhancedMserCCMask = Mat.zeros((Size)labels.size(), (int)CvType.CV_8UC1);
        for (int labelId = 0; labelId < labelsIds; ++labelId) {
            double minSolidity;
            double area = stats.get(labelId, 4)[0];
            if (area < 3.0 || area > 200.0) continue;
            Mat labelMask = new Mat();
            Core.inRange((Mat)labels, (Scalar)new Scalar((double)labelId), (Scalar)new Scalar((double)labelId), (Mat)labelMask);
            Moments moment = Imgproc.moments((Mat)labelMask);
            double left_comp = (moment.nu20 + moment.nu02) / 2.0;
            double right_comp = Math.sqrt(4.0 * moment.nu11 * moment.nu11 + (moment.nu20 - moment.nu02) * (moment.nu20 - moment.nu02)) / 2.0;
            double eig_val_1 = left_comp + right_comp;
            double eig_val_2 = left_comp - right_comp;
            double eccentricity = Math.sqrt(1.0 - eig_val_2 / eig_val_1);
            double minEccentricity = 0.1;
            double maxEccentricity = 0.995;
            ArrayList contours = new ArrayList();
            Imgproc.findContours((Mat)labelMask, contours, (Mat)new Mat(), (int)0, (int)2);
            MatOfInt hull = new MatOfInt();
            Imgproc.convexHull((MatOfPoint)((MatOfPoint)contours.get(0)), (MatOfInt)hull);
            MatOfPoint mopHull = new MatOfPoint();
            mopHull.create((int)hull.size().height, 1, CvType.CV_32SC2);
            int j = 0;
            while ((double)j < hull.size().height) {
                int index = (int)hull.get(j, 0)[0];
                double[] point = new double[]{((MatOfPoint)contours.get(0)).get(index, 0)[0], ((MatOfPoint)contours.get(0)).get(index, 0)[1]};
                mopHull.put(j, 0, point);
                ++j;
            }
            double solidity = area / Imgproc.contourArea((Mat)mopHull);
            if (solidity < (minSolidity = 0.35)) continue;
            Core.bitwise_or((Mat)edgeEnhancedMserCCMask, (Mat)labelMask, (Mat)edgeEnhancedMserCCMask);
        }
        return edgeEnhancedMserCCMask;
    }

    public Mat getFilteredStrokeWidthMask() {
        return this.filteredStrokeWidthMask != null ? this.filteredStrokeWidthMask : (this.filteredStrokeWidthMask = this.buildFilteredStrokeWidthMask());
    }

    private Mat buildFilteredStrokeWidthMask() {
        Mat normalized = new Mat();
        Imgproc.threshold((Mat)this.getEdgeEnhanceMserCCMask(), (Mat)normalized, (double)1.0, (double)1.0, (int)0);
        Mat mask32F = new Mat();
        normalized.convertTo(mask32F, 5);
        Mat result32F = new Mat();
        Imgproc.distanceTransform((Mat)normalized, (Mat)result32F, (int)2, (int)5);
        Core.MinMaxLocResult minMaxLocResult = Core.minMaxLoc((Mat)result32F);
        int strokeRadius = (int)Math.ceil(minMaxLocResult.maxVal);
        Mat kernel = Imgproc.getStructuringElement((int)0, (Size)new Size(3.0, 3.0));
        for (int j = 0; j < strokeRadius; ++j) {
            Imgproc.dilate((Mat)result32F, (Mat)result32F, (Mat)kernel);
            result32F = result32F.mul(mask32F);
        }
        Mat strokeWidth = result32F;
        Mat filteredStrokeWidth = new Mat(strokeWidth.size(), CvType.CV_8UC1, new Scalar(0.0));
        Mat strokeWithCV8U = new Mat();
        strokeWidth.convertTo(strokeWithCV8U, CvType.CV_8UC1);
        Mat labels = new Mat();
        Mat stats = new Mat();
        Mat centroid = new Mat();
        int labelsIds = Imgproc.connectedComponentsWithStats((Mat)strokeWithCV8U, (Mat)labels, (Mat)stats, (Mat)centroid, (int)8, (int)4);
        for (int labelId = 0; labelId < labelsIds; ++labelId) {
            Mat labelMask = new Mat();
            Core.inRange((Mat)labels, (Scalar)new Scalar((double)labelId), (Scalar)new Scalar((double)labelId), (Mat)labelMask);
            Mat temp = new Mat(strokeWithCV8U.size(), strokeWithCV8U.type(), new Scalar(0.0));
            strokeWithCV8U.copyTo(temp, labelMask);
            int area = Core.countNonZero((Mat)temp);
            MatOfDouble meanD = new MatOfDouble();
            MatOfDouble stdDev = new MatOfDouble();
            Core.meanStdDev((Mat)strokeWithCV8U, (MatOfDouble)meanD, (MatOfDouble)stdDev, (Mat)labelMask);
            if (area == 0 || stdDev.get(0, 0)[0] / meanD.get(0, 0)[0] > 0.3) continue;
            Core.bitwise_or((Mat)filteredStrokeWidth, (Mat)labelMask, (Mat)filteredStrokeWidth);
        }
        return filteredStrokeWidth;
    }

    private static int booleansToInt(boolean[] arr) {
        int n = 0;
        for (boolean b : arr) {
            n = n << 1 | (b ? 1 : 0);
        }
        return n;
    }

    private static int getNeighborsLessThan(Mat mat, int y, int x) {
        boolean[] neighbors = new boolean[8];
        boolean bl = mat.get(y, x - 1)[0] == 0.0 ? false : (neighbors[0] = mat.get(y, x - 1)[0] < mat.get(y, x)[0]);
        boolean bl2 = mat.get(y - 1, x - 1)[0] == 0.0 ? false : (neighbors[1] = mat.get(y - 1, x - 1)[0] < mat.get(y, x)[0]);
        boolean bl3 = mat.get(y - 1, x)[0] == 0.0 ? false : (neighbors[2] = mat.get(y - 1, x)[0] < mat.get(y, x)[0]);
        boolean bl4 = mat.get(y - 1, x + 1)[0] == 0.0 ? false : (neighbors[3] = mat.get(y - 1, x + 1)[0] < mat.get(y, x)[0]);
        boolean bl5 = mat.get(y, x + 1)[0] == 0.0 ? false : (neighbors[4] = mat.get(y, x + 1)[0] < mat.get(y, x)[0]);
        boolean bl6 = mat.get(y + 1, x + 1)[0] == 0.0 ? false : (neighbors[5] = mat.get(y + 1, x + 1)[0] < mat.get(y, x)[0]);
        boolean bl7 = mat.get(y + 1, x)[0] == 0.0 ? false : (neighbors[6] = mat.get(y + 1, x)[0] < mat.get(y, x)[0]);
        neighbors[7] = mat.get(y + 1, x - 1)[0] == 0.0 ? false : mat.get(y + 1, x - 1)[0] < mat.get(y, x)[0];
        return RobustTextDetectorManager.booleansToInt(neighbors);
    }

    private static Mat computeStrokeWidth(Mat dist) {
        Mat padded = new Mat(dist.rows() + 1, dist.cols() + 1, dist.type(), new Scalar(0.0));
        dist.copyTo(new Mat(padded, new Rect(1, 1, dist.cols(), dist.rows())));
        Mat lookup = new Mat(padded.size(), CvType.CV_8UC1, new Scalar(0.0));
        for (int y = 1; y < padded.rows() - 1; ++y) {
            for (int x = 1; x < padded.cols() - 1; ++x) {
                if (padded.get(y, x)[0] == 0.0) continue;
                lookup.put(y, x, new double[]{RobustTextDetectorManager.getNeighborsLessThan(padded, y, x)});
            }
        }
        Core.MinMaxLocResult minMaxLocResult = Core.minMaxLoc((Mat)padded);
        int maxStroke = (int)Math.round(minMaxLocResult.maxVal);
        for (double stroke = (double)maxStroke; stroke > 0.0; stroke -= 1.0) {
            Mat stroke_indices_mat = new Mat();
            Mat mask = new Mat();
            Core.inRange((Mat)padded, (Scalar)new Scalar(stroke - 0.1), (Scalar)new Scalar(stroke + 0.1), (Mat)mask);
            Mat masked = new Mat();
            padded.copyTo(masked, mask);
            masked.convertTo(masked, CvType.CV_8UC1);
            Core.findNonZero((Mat)masked, (Mat)stroke_indices_mat);
            ArrayList stroke_indices = new ArrayList();
            if (stroke_indices_mat.cols() > 0) {
                Converters.Mat_to_vector_Point((Mat)stroke_indices_mat, stroke_indices);
            }
            ArrayList<Point> neighbors = new ArrayList<Point>();
            for (Point stroke_index : stroke_indices) {
                List<Point> temp = RobustTextDetectorManager.convertToCoords((int)stroke_index.x, (int)stroke_index.y, (int)lookup.get((int)stroke_index.y, (int)stroke_index.x)[0]);
                neighbors.addAll(temp);
            }
            while (!neighbors.isEmpty()) {
                for (Point neighbor : neighbors) {
                    padded.put((int)neighbor.y, (int)neighbor.x, new double[]{stroke});
                }
                neighbors.clear();
                ArrayList temp = new ArrayList(neighbors);
                neighbors.clear();
                for (Point neighbor : temp) {
                    List<Point> temp2 = RobustTextDetectorManager.convertToCoords((int)neighbor.x, (int)neighbor.y, (int)lookup.get((int)neighbor.y, (int)neighbor.x)[0]);
                    neighbors.addAll(temp2);
                }
            }
        }
        return new Mat(padded, new Rect(1, 1, dist.cols(), dist.rows()));
    }

    private static List<Point> convertToCoords(int x, int y, int neighbors) {
        ArrayList<Point> coords = new ArrayList<Point>();
        if ((neighbors & (int)Math.pow(2.0, 7.0)) != 0) {
            coords.add(new Point((double)(x - 1), (double)y));
        }
        if ((neighbors & (int)Math.pow(2.0, 6.0)) != 0) {
            coords.add(new Point((double)(x - 1), (double)(y - 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 5.0)) != 0) {
            coords.add(new Point((double)x, (double)(y - 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 4.0)) != 0) {
            coords.add(new Point((double)(x + 1), (double)(y - 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 3.0)) != 0) {
            coords.add(new Point((double)(x + 1), (double)y));
        }
        if ((neighbors & (int)Math.pow(2.0, 2.0)) != 0) {
            coords.add(new Point((double)(x + 1), (double)(y + 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 1.0)) != 0) {
            coords.add(new Point((double)x, (double)(y + 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 0.0)) != 0) {
            coords.add(new Point((double)(x - 1), (double)(y + 1)));
        }
        return coords;
    }

    public static int toBin(double angle, int neighbors) {
        float divisor = 180.0f / (float)neighbors;
        return (int)(((Math.floor(angle / (double)divisor) - 1.0) / 2.0 + 1.0) % (double)neighbors + 1.0);
    }

    public static Mat growEdges(Mat gray, Mat edges) {
        Mat grad_x = new Mat();
        Mat grad_y = new Mat();
        Imgproc.Sobel((Mat)gray, (Mat)grad_x, (int)CvType.CV_64FC1, (int)1, (int)0, (int)-1, (double)1.0, (double)0.0);
        Imgproc.Sobel((Mat)gray, (Mat)grad_y, (int)CvType.CV_64FC1, (int)0, (int)1, (int)-1, (double)1.0, (double)0.0);
        Mat grad_mag = new Mat();
        Mat grad_dir = new Mat();
        Core.cartToPolar((Mat)grad_x, (Mat)grad_y, (Mat)grad_mag, (Mat)grad_dir, (boolean)true);
        for (int y = 0; y < grad_dir.rows(); ++y) {
            for (int x = 0; x < grad_dir.cols(); ++x) {
                grad_dir.put(y, x, new double[]{RobustTextDetectorManager.toBin(grad_dir.get(y, x)[0], 8)});
            }
        }
        grad_dir.convertTo(grad_dir, CvType.CV_8UC1);
        Mat result = new Mat();
        edges.copyTo(result);
        for (int y = 1; y < edges.rows() - 1; ++y) {
            block13: for (int x = 1; x < edges.cols() - 1; ++x) {
                if (edges.get(y, x)[0] == 0.0) continue;
                switch ((int)grad_dir.get(y, x)[0]) {
                    case 1: {
                        result.put(y, x + 1, new double[]{255.0});
                        continue block13;
                    }
                    case 2: {
                        result.put(y + 1, x + 1, new double[]{255.0});
                        continue block13;
                    }
                    case 3: {
                        result.put(y + 1, x, new double[]{255.0});
                        continue block13;
                    }
                    case 4: {
                        result.put(y + 1, x - 1, new double[]{255.0});
                        continue block13;
                    }
                    case 5: {
                        result.put(y, x - 1, new double[]{255.0});
                        continue block13;
                    }
                    case 6: {
                        result.put(y - 1, x - 1, new double[]{255.0});
                        continue block13;
                    }
                    case 7: {
                        result.put(y - 1, x, new double[]{255.0});
                        continue block13;
                    }
                    case 8: {
                        result.put(y - 1, x + 1, new double[]{255.0});
                        continue block13;
                    }
                    default: {
                        System.out.println("Error : " + (int)grad_dir.get(y, x)[0]);
                    }
                }
            }
        }
        return result;
    }

    static {
        NativeLibraryLoader.load();
    }
}

