/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.fht;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.OrientedPoint;
import org.genericsystem.cv.application.Segment;
import org.genericsystem.cv.application.SplineInterpolator;
import org.genericsystem.cv.application.TrajectStep;
import org.genericsystem.cv.application.fht.FHT;
import org.genericsystem.cv.application.fht.FHTManager;
import org.genericsystem.cv.application.mesh.MeshManager;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.layout.Layout;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class FHTDemo
extends AbstractApp {
    private GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3]};
    private int frameCount = 0;
    private FHTManager fhtManager = new FHTManager(this.gsCapture.getResize());

    public static void main(String[] args) {
        FHTDemo.launch((String[])args);
    }

    public FHTDemo() {
        this.addIntegerSliderProperty("hBlurSize", this.fhtManager.gethBlurSize(), 0.0, 200.0);
        this.addIntegerSliderProperty("vBlurSize", this.fhtManager.getvBlurSize(), 0.0, 200.0);
        this.addDoubleSliderProperty("hAnglePenality", this.fhtManager.gethAnglePenality(), -1.0, 0.0);
        this.addDoubleSliderProperty("vAnglePenality", this.fhtManager.getvAnglePenality(), -1.0, 0.0);
        this.addDoubleSliderProperty("vRecover", this.fhtManager.getvRecover(), 0.0, 1.0);
        this.addDoubleSliderProperty("hRecover", this.fhtManager.gethRecover(), 0.0, 1.0);
        this.addIntegerSliderProperty("vStripsNumber", this.fhtManager.getvStripsNumber(), 1.0, 32.0);
        this.addIntegerSliderProperty("hStripsNumber", this.fhtManager.gethStripsNumber(), 1.0, 32.0);
        this.addDoubleSliderProperty("vLocalThreshold", this.fhtManager.getvLocalThreshold(), 0.0, 1.0);
        this.addDoubleSliderProperty("hLocalThreshold", this.fhtManager.gethLocalThreshold(), 0.0, 1.0);
        this.addDoubleSliderProperty("vGlobalThreshold", this.fhtManager.getvGlobalThreshold(), 0.0, 0.2);
        this.addDoubleSliderProperty("hGlobalThreshold", this.fhtManager.gethGlobalThreshold(), 0.0, 0.2);
        this.addDoubleSliderProperty("vMaxConnectDistance", this.fhtManager.getvMaxConnectDistance(), 0.0, 0.1);
        this.addDoubleSliderProperty("hMaxConnectDistance", this.fhtManager.gethMaxConnectDistance(), 0.0, 0.1);
        this.addDoubleSliderProperty("interpolatorPow", this.fhtManager.getInterpolatorPow(), 0.0, 10.0);
        this.addDoubleSliderProperty("interpolatorMinDist", this.fhtManager.getInterpolatorMinDist(), 0.0, 10.0);
        this.addIntegerSliderProperty("halfGridWidth", this.fhtManager.getHalfGridWidth(), 1.0, 32.0);
        this.addIntegerSliderProperty("halfGridHeight", this.fhtManager.getHalfGridHeight(), 1.0, 32.0);
        this.addDoubleSliderProperty("focale", this.fhtManager.getFocale(), 0.0, 1500.0);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 3000L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.0;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
            ++this.frameCount;
        }
        Image[] images = new Image[20];
        long ref = System.currentTimeMillis();
        images[0] = this.frame.toJfxImage();
        Img binarized = this.frame.adaptativeGaussianInvThreshold(7, 5.0);
        images[1] = binarized.toJfxImage();
        if (this.frameCount < 30) {
            return images;
        }
        this.fhtManager.init(binarized.getSrc());
        ref = this.trace("FHT init", ref);
        double minVerticalAccuracy = 180.0 * Math.atan(1.0 / (this.fhtManager.getStripWidth().get() - 1.0)) / Math.PI;
        System.out.println(this.fhtManager.getvStripsNumber().get() + " verticals strips with width : " + this.fhtManager.getStripWidth().get() + " each step : " + this.fhtManager.getvStep().get() + " min accuracy : " + minVerticalAccuracy);
        double minHorizontalAccuracy = 180.0 * Math.atan(1.0 / (this.fhtManager.getStripHeight().get() - 1.0)) / Math.PI;
        System.out.println(this.fhtManager.gethStripsNumber().get() + " horizontal strips with height : " + this.fhtManager.getStripHeight().get() + " each step : " + this.fhtManager.gethStep().get() + " min accuracy : " + minHorizontalAccuracy);
        List<Mat> vStrips = this.fhtManager.getVStrips();
        List<Mat> hStrips = this.fhtManager.getHStrips();
        ref = this.trace("Extract strips", ref);
        List<Mat> vHoughs = this.fhtManager.getvHoughs();
        List<Mat> hHoughs = this.fhtManager.gethHoughs();
        ref = this.trace("Compute FHT", ref);
        List<List<TrajectStep>> vHoughTrajs = this.fhtManager.getvHoughTrajs();
        List<List<TrajectStep>> hHoughTrajs = this.fhtManager.gethHoughTrajs();
        ref = this.trace("Compute trajects", ref);
        List<List<OrientedPoint>[]> fhtHorizontals = this.fhtManager.getFhtHorizontals();
        List<List<OrientedPoint>[]> fhtVerticals = this.fhtManager.getFhtVerticals();
        List<List<Segment>>[] horizontalSegments = this.fhtManager.getHorizontalSegments();
        List<List<Segment>>[] verticalSegments = this.fhtManager.getVerticalSegments();
        Img frameDisplayFHT = new Img(this.frame.getSrc().clone(), false);
        Segment.displayHorizontalOps(horizontalSegments[0], frameDisplayFHT.getSrc(), this.fhtManager.getvStep().get(), this.fhtManager.gethStep().get(), new Scalar(0.0, 255.0, 0.0));
        Segment.displayHorizontalOps(horizontalSegments[1], frameDisplayFHT.getSrc(), this.fhtManager.getvStep().get(), this.fhtManager.gethStep().get(), new Scalar(0.0, 0.0, 255.0));
        Segment.displayVerticalOps(verticalSegments[0], frameDisplayFHT.getSrc(), this.fhtManager.getvStep().get(), this.fhtManager.gethStep().get(), new Scalar(255.0, 255.0, 0.0));
        Segment.displayVerticalOps(verticalSegments[1], frameDisplayFHT.getSrc(), this.fhtManager.getvStep().get(), this.fhtManager.gethStep().get(), new Scalar(255.0, 0.0, 255.0));
        images[2] = frameDisplayFHT.toJfxImage();
        ref = this.trace("Display lines", ref);
        List<PolynomialSplineFunction>[] horizontalSplines = this.fhtManager.gethSplines();
        List<PolynomialSplineFunction>[] verticalSplines = this.fhtManager.getvSplines();
        Img splineDisplay = new Img(this.frame.getSrc().clone(), false);
        FHT.displayHSplines(horizontalSplines[0], splineDisplay.getSrc(), 0.0, 255.0, 0.0);
        FHT.displayHSplines(horizontalSplines[1], splineDisplay.getSrc(), 0.0, 0.0, 255.0);
        FHT.displayVSplines(verticalSplines[0], splineDisplay.getSrc(), 255.0, 255.0, 0.0);
        FHT.displayVSplines(verticalSplines[1], splineDisplay.getSrc(), 255.0, 0.0, 255.0);
        images[3] = splineDisplay.toJfxImage();
        ref = this.trace("Display splines", ref);
        SplineInterpolator superInterpolator = this.fhtManager.getSuperInterpolator();
        ref = this.trace("Prepare interpolator", ref);
        MeshManager meshManager = this.fhtManager.getMeshManager();
        images[4] = new Img(meshManager.draw(this.frame.getSrc().clone(), new Scalar(0.0, 255.0, 0.0), new Scalar(0.0, 0.0, 255.0)), false).toJfxImage();
        ref = this.trace("Build and draw mesh", ref);
        images[5] = new Img(meshManager.draw3Dsurface(new Scalar(0.0, 255.0, 0.0), new Scalar(0.0, 0.0, 255.0)), false).toJfxImage();
        ref = this.trace("3D surface / svd", ref);
        Img dewarpFHT3D = new Img(this.fhtManager.dewarp(this.frame.getSrc().clone()));
        images[6] = dewarpFHT3D.toJfxImage();
        ref = this.trace("Dewarp 3D", ref);
        Img binarized3D = dewarpFHT3D.adaptativeGaussianInvThreshold(7, 5.0);
        images[7] = binarized3D.toJfxImage();
        ref = this.trace("Binarize dewarp 3D", ref);
        Layout layout3D = binarized3D.buildLayout(new Size(2.0, 0.0), new Size(0.001, 0.001), 8);
        layout3D.draw(dewarpFHT3D, new Scalar(255.0, 0.0, 0.0), new Scalar(0.0, 0.0, 255.0), 0, -1);
        images[8] = dewarpFHT3D.toJfxImage();
        ref = this.trace("Layout 3D", ref);
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

