/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Ocr;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.text.ERFilter;
import org.opencv.text.Text;
import org.opencv.videoio.VideoCapture;

public class TextDetector
extends AbstractApp {
    private final VideoCapture camera = new VideoCapture(0);
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) {
        TextDetector.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        ImageView imgView = new ImageView();
        mainGrid.add((Node)imgView, 0, 0);
        Mat frame = new Mat();
        this.camera.read(frame);
        imgView.setImage(Tools.mat2jfxImage(frame));
        this.timer.scheduleAtFixedRate(() -> {
            this.camera.read(frame);
            this.detect(frame);
            imgView.setImage(Tools.mat2jfxImage(frame));
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    public void detect(Mat src) {
        ERFilter er_filter1 = Text.createERFilterNM1((String)"resources/trained_classifierNM1.xml", (int)16, (float)1.5E-4f, (float)0.13f, (float)0.2f, (boolean)true, (float)0.1f);
        ERFilter er_filter2 = Text.createERFilterNM2((String)"resources/trained_classifierNM2.xml", (float)0.5f);
        MatOfRect groups_rects = new MatOfRect();
        Text.detectRegions((Mat)src, (ERFilter)er_filter1, (ERFilter)er_filter2, (MatOfRect)groups_rects, (int)0, (String)"resources/trained_classifier_erGrouping.xml", (float)0.5f);
        for (Rect rect : groups_rects.toArray()) {
            if (!(rect.tl().x >= 0.0) || !(rect.tl().y >= 0.0) || !(rect.br().x < (double)src.cols()) || !(rect.br().y < (double)src.height())) continue;
            Mat bordered = new Mat(src, rect);
            System.out.println(Ocr.doWork(bordered));
            Imgproc.rectangle((Mat)src, (Point)rect.tl(), (Point)rect.br(), (Scalar)(src.type() == CvType.CV_8UC3 ? new Scalar(0.0, 255.0, 0.0) : new Scalar(255.0)), (int)1, (int)8, (int)0);
        }
    }

    public void stop() throws Exception {
        this.timer.shutdown();
        this.camera.release();
        super.stop();
    }

    static {
        NativeLibraryLoader.load();
    }
}

