/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.stabilizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.fht.FHTManager;
import org.genericsystem.cv.application.mesh.Points;
import org.genericsystem.cv.application.stabilizer.ImgDescriptor;
import org.genericsystem.cv.application.stabilizer.ReferenceManager;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class StabilizerDemo
extends AbstractApp {
    private final GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame;
    private ReferenceManager referenceManager;
    private Config config = new Config();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private FHTManager fhtManager = new FHTManager(this.gsCapture.getResize());
    private ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3]};
    private int frameCount = 0;

    public static void main(String[] args) {
        StabilizerDemo.launch((String[])args);
    }

    public StabilizerDemo() {
        this.frame = this.gsCapture.read();
        this.referenceManager = new ReferenceManager(this.gsCapture.getResize());
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.0;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 2000L, 50L, TimeUnit.MILLISECONDS);
    }

    public boolean contains(Rect rect, Rect shiftedRect) {
        return rect.tl().x <= shiftedRect.tl().x && rect.tl().y <= shiftedRect.tl().y && rect.br().x >= shiftedRect.br().x && rect.br().y >= shiftedRect.br().y;
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
            ++this.frameCount;
        }
        long ref = System.currentTimeMillis();
        Image[] images = new Image[10];
        images[0] = this.frame.toJfxImage();
        if (this.frameCount < 30) {
            return images;
        }
        ImgDescriptor newImgDescriptor = new ImgDescriptor(this.frame);
        if (newImgDescriptor.getDescriptors().empty()) {
            System.out.println("Empty descriptors");
            return null;
        }
        if (!this.referenceManager.submit(newImgDescriptor)) {
            System.out.println("No reconciliation found");
            return null;
        }
        Mat homography = this.referenceManager.getHomography(newImgDescriptor);
        if (homography == null) {
            this.referenceManager = new ReferenceManager(this.frame.size());
            System.out.println("Refernce manager is full");
            return null;
        }
        Mat stabilized = this.referenceManager.dewarp(newImgDescriptor, homography);
        MatOfPoint trackedFeatures = new MatOfPoint();
        MatOfPoint corners = new MatOfPoint();
        Imgproc.goodFeaturesToTrack((Mat)new Img(stabilized, false).bgr2Gray().getSrc(), (MatOfPoint)trackedFeatures, (int)300, (double)0.01, (double)10.0);
        Mat stabilizedDisplay = stabilized.clone();
        Arrays.stream(trackedFeatures.toArray()).forEach(corner -> Imgproc.circle((Mat)stabilizedDisplay, (Point)corner, (int)3, (Scalar)new Scalar(0.0, 255.0, 0.0)));
        images[1] = new Img(stabilizedDisplay, false).toJfxImage();
        Mat binarized = new Img(stabilized, false).adaptativeGaussianInvThreshold(7, 5.0).getSrc();
        if (!this.fhtManager.isInitialized() || this.frameCount % 30 == 0) {
            this.fhtManager.init(binarized);
        }
        this.fhtManager.init(binarized);
        images[1] = new Img(this.fhtManager.getMeshManager().drawReverse(stabilized, new Scalar(255.0, 0.0, 0.0), new Scalar(0.0, 255.0, 0.0)), false).toJfxImage();
        Img dewarped = new Img(this.fhtManager.getMeshManager().dewarpReverse(stabilized), false);
        images[2] = dewarped.toJfxImage();
        Img dewarpedBinary = dewarped.adaptativeGaussianInvThreshold(7, 5.0);
        Mat horizontalHisto = new Mat();
        Core.reduce((Mat)dewarpedBinary.getSrc(), (Mat)horizontalHisto, (int)1, (int)0, (int)CvType.CV_64FC1);
        Mat verticalHisto = new Mat();
        Core.reduce((Mat)dewarpedBinary.getSrc(), (Mat)verticalHisto, (int)0, (int)0, (int)CvType.CV_64FC1);
        Core.normalize((Mat)horizontalHisto, (Mat)horizontalHisto, (double)0.0, (double)255.0, (int)32);
        Mat transposedVerticalHisto = verticalHisto.t();
        Core.normalize((Mat)transposedVerticalHisto, (Mat)transposedVerticalHisto, (double)0.0, (double)255.0, (int)32);
        Mat hHisto = Mat.zeros((Size)new Size(255.0, (double)dewarpedBinary.height()), (int)CvType.CV_8UC1);
        ArrayList<Mag> magnitudes = new ArrayList<Mag>();
        for (int index = 0; index < horizontalHisto.rows(); ++index) {
            magnitudes.add(new Mag(index, horizontalHisto.get(index, 0)[0]));
        }
        List<Mag[]> histoLines = StabilizerDemo.getHistoLines(magnitudes, 0.3, 0.1);
        for (Mag[] mags : histoLines) {
            Imgproc.rectangle((Mat)hHisto, (Rect)new Rect(new Point(0.0, (double)mags[0].index), new Point(255.0, (double)mags[1].index)), (Scalar)new Scalar(255.0), (int)-1);
        }
        images[3] = new Img(hHisto, false).toJfxImage();
        Mat vHisto = Mat.zeros((Size)new Size((double)dewarpedBinary.width(), 255.0), (int)CvType.CV_8UC1);
        ArrayList<Mag> vMagnitudes = new ArrayList<Mag>();
        for (int index = 0; index < transposedVerticalHisto.rows(); ++index) {
            vMagnitudes.add(new Mag(index, transposedVerticalHisto.get(index, 0)[0]));
        }
        histoLines = StabilizerDemo.getHistoLines(vMagnitudes, 0.5, 0.3);
        for (Mag[] mags : histoLines) {
            Imgproc.rectangle((Mat)vHisto, (Rect)new Rect(new Point((double)mags[0].index, 0.0), new Point((double)mags[1].index, 255.0)), (Scalar)new Scalar(255.0), (int)-1);
        }
        images[4] = new Img(vHisto, false).toJfxImage();
        int nbrCell = 6;
        Points pts = this.fhtManager.getMeshManager().getReverseMesh().getPoints();
        Point[] basePts = new Point[]{pts.getPoint(-nbrCell, -nbrCell), pts.getPoint(-nbrCell, nbrCell), pts.getPoint(nbrCell, nbrCell), pts.getPoint(nbrCell, -nbrCell)};
        double width = stabilized.size().width / (double)(2 * this.fhtManager.getHalfGridWidth().get());
        double height = stabilized.size().height / (double)(2 * this.fhtManager.getHalfGridHeight().get());
        Point[] targetPts = new Point[]{new Point(stabilized.size().width / 2.0 - (double)nbrCell * width, stabilized.size().height / 2.0 - (double)nbrCell * height), new Point(stabilized.size().width / 2.0 + (double)nbrCell * width, stabilized.size().height / 2.0 - (double)nbrCell * height), new Point(stabilized.size().width / 2.0 + (double)nbrCell * width, stabilized.size().height / 2.0 + (double)nbrCell * height), new Point(stabilized.size().width / 2.0 - (double)nbrCell * width, stabilized.size().height / 2.0 + (double)nbrCell * height)};
        Mat homography2 = Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(basePts), (Mat)new MatOfPoint2f(targetPts));
        Mat stabilized2 = new Mat();
        Imgproc.warpPerspective((Mat)this.fhtManager.getMeshManager().buildEnlarged(stabilized), (Mat)stabilized2, (Mat)homography2, (Size)stabilized.size());
        Mat binarized2 = new Img(stabilized2, false).adaptativeGaussianInvThreshold(7, 5.0).getSrc();
        this.fhtManager.init(binarized2);
        images[5] = new Img(this.fhtManager.getMeshManager().drawReverse(stabilized2, new Scalar(255.0, 0.0, 0.0), new Scalar(0.0, 255.0, 0.0)), false).toJfxImage();
        images[6] = new Img(this.fhtManager.getMeshManager().dewarpReverse(stabilized2), false).toJfxImage();
        return images;
    }

    public static List<Mag[]> getHistoLines(List<Mag> magnitudes, double localTheshold, double globalTheshold) {
        Mag mag;
        HashSet<Mag> alreadyComputed = new HashSet<Mag>();
        double max = magnitudes.stream().mapToDouble(ts -> ((Mag)ts).magnitude).max().getAsDouble();
        ArrayList<Mag[]> result = new ArrayList<Mag[]>();
        Iterator iterator = magnitudes.stream().sorted().collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !((mag = (Mag)iterator.next()).magnitude < globalTheshold * max)) {
            int y;
            int y2;
            int y1;
            if (alreadyComputed.contains(mag)) continue;
            double tAlpha = localTheshold * mag.magnitude;
            for (y1 = mag.index; y1 >= 0 && magnitudes.get(y1).magnitude >= tAlpha; --y1) {
            }
            if (y1 != 0) {
                ++y1;
            }
            for (y2 = mag.index; y2 < magnitudes.size() && magnitudes.get(y2).magnitude >= tAlpha; ++y2) {
            }
            if (y2 != magnitudes.size() - 1) {
                --y2;
            }
            boolean alreadyVisited = false;
            for (y = y1; y <= y2; ++y) {
                if (!alreadyComputed.contains(magnitudes.get(y))) continue;
                alreadyVisited = true;
                break;
            }
            for (y = y1; y <= y2; ++y) {
                alreadyComputed.add(magnitudes.get(y));
            }
            if (alreadyVisited) continue;
            result.add(new Mag[]{magnitudes.get(y1), magnitudes.get(y2)});
        }
        return result;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onR() {
        this.timer.schedule(() -> this.referenceManager.clear(), 0L, TimeUnit.MILLISECONDS);
    }

    List<Rect> detectRects(Mat mask, int minArea, int maxArea) {
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)mask, contours, (Mat)new Mat(), (int)0, (int)2);
        Size size = mask.size();
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (MatOfPoint contour : contours) {
            double area = Imgproc.contourArea((Mat)contour);
            if (!(area >= (double)minArea) || !(area <= (double)maxArea)) continue;
            Rect rect = Imgproc.boundingRect((MatOfPoint)contour);
            result.add(rect);
        }
        Collections.reverse(result);
        return result;
    }

    public double getFillRatio(MatOfPoint contour, Rect rect) {
        Mat mask = Mat.zeros((Size)rect.size(), (int)CvType.CV_8UC1);
        Imgproc.drawContours((Mat)mask, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0), (int)-1, (int)8, (Mat)new Mat(), (int)Integer.MAX_VALUE, (Point)new Point(-rect.tl().x, -rect.tl().y));
        Mat mat = new Mat();
        Core.findNonZero((Mat)mask, (Mat)mat);
        return (double)mat.rows() / rect.area();
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }

    public static class Mag
    implements Comparable<Mag> {
        private final double magnitude;
        private final int index;

        public Mag(int index, double magnitude) {
            this.index = index;
            this.magnitude = magnitude;
        }

        @Override
        public int compareTo(Mag mag) {
            int result = Double.compare(mag.magnitude, this.magnitude);
            return result != 0 ? result : Double.compare(mag.index, this.index);
        }
    }
}

