/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.video.KalmanFilter;

public class Kalman {
    KalmanFilter kf = new KalmanFilter(4, 2, 1, 6);

    public Kalman() {
        Mat transitionMatrix = new Mat(4, 4, 6, new Scalar(0.0));
        double[] tM = new double[]{1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        transitionMatrix.put(0, 0, tM);
        this.kf.set_transitionMatrix(transitionMatrix);
        Mat mm = Mat.eye((int)2, (int)4, (int)6);
        this.kf.set_measurementMatrix(mm);
        Mat processNoiseCov = Mat.eye((int)4, (int)4, (int)6);
        processNoiseCov = processNoiseCov.mul(processNoiseCov, 1.0E-4);
        this.kf.set_processNoiseCov(processNoiseCov);
        Mat id1 = Mat.eye((int)2, (int)2, (int)6);
        id1 = id1.mul(id1, 0.1);
        this.kf.set_measurementNoiseCov(id1);
        Mat id2 = Mat.eye((int)4, (int)4, (int)6);
        this.kf.set_errorCovPost(id2);
    }

    public static void main(String[] args) {
        double[][] samplesArr = new double[][]{{0.0, 0.0}, {1.0, -1.0}, {2.0, -2.0}, {3.0, -3.0}, {4.0, -4.0}, {4.0, -5.0}, {4.0, -6.0}, {4.0, -7.0}, {4.0, -8.0}};
        Kalman kalman = new Kalman();
        for (int i = 0; i < samplesArr.length; ++i) {
            double[] prediction = kalman.predict();
            System.out.println("Pr\u00e9diction : " + Arrays.toString(prediction));
            System.out.println("Correction : " + Arrays.toString(samplesArr[i]));
            kalman.correct(samplesArr[i]);
        }
    }

    public double[] predict() {
        Mat prediction = this.kf.predict();
        return new double[]{prediction.get(0, 0)[0], prediction.get(1, 0)[0]};
    }

    public void correct(double[] correction) {
        Mat meas = new Mat(2, 1, 6, new Scalar(correction[0], correction[1]));
        meas.put(0, 0, correction);
        this.kf.correct(meas);
    }

    static {
        NativeLibraryLoader.load();
    }
}

