/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.nn;

import java.io.File;
import java.util.List;
import org.datavec.api.io.labels.ParentPathLabelGenerator;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.util.ndarray.RecordConverter;
import org.datavec.api.writable.Writable;
import org.datavec.image.recordreader.BaseImageRecordReader;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public class ImageFeaturesRecordReader
extends BaseImageRecordReader {
    private static final long serialVersionUID = 4031311017700609257L;

    public ImageFeaturesRecordReader(int height, int width, int channels, ParentPathLabelGenerator labelMaker, Mat vocabulary) {
        super(height, width, channels, (PathLabelGenerator)labelMaker);
    }

    public boolean batchesSupported() {
        return false;
    }

    public List<Writable> next() {
        if (this.iter != null) {
            List ret;
            File image;
            this.currentFile = image = (File)this.iter.next();
            if (image.isDirectory()) {
                return this.next();
            }
            try {
                this.invokeListeners(image);
                try (Img img0 = new Img(image.toString());
                     Img img = img0.resize(new Size((double)this.width, (double)this.height));){
                    INDArray row = Nd4j.create((float[])img.getHogDescriptor().toArray());
                    ret = RecordConverter.toRecord((INDArray)row);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
        if (this.record != null) {
            this.hitImage = true;
            this.invokeListeners(this.record);
            return this.record;
        }
        throw new IllegalStateException("No more elements");
    }

    static {
        NativeLibraryLoader.load();
    }
}

