/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Lines;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class DirectionalEnhancerDemo
extends AbstractApp {
    private GSCapture gsCapture = new GSVideoCapture(0, GSVideoCapture.HD, GSVideoCapture.VGA);
    private Img frame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        DirectionalEnhancerDemo.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 1000L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth((double)this.frame.width() / displaySizeReduction);
                imageView.setFitHeight((double)this.frame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.frame = this.gsCapture.read();
        }
        Image[] images = new Image[12];
        long ref = System.currentTimeMillis();
        Mat mat = new Mat();
        Imgproc.cvtColor((Mat)this.frame.getSrc(), (Mat)mat, (int)6);
        Imgproc.GaussianBlur((Mat)mat, (Mat)mat, (Size)new Size(13.0, 13.0), (double)0.0);
        images[0] = new Img(mat, false).toJfxImage();
        Imgproc.adaptiveThreshold((Mat)mat, (Mat)mat, (double)255.0, (int)0, (int)1, (int)7, (double)2.0);
        images[1] = new Img(mat, false).toJfxImage();
        Imgproc.morphologyEx((Mat)mat, (Mat)mat, (int)3, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(9.0, 9.0)));
        images[2] = new Img(mat, false).toJfxImage();
        ArrayList contours = new ArrayList();
        Imgproc.findContours((Mat)mat, contours, (Mat)new Mat(), (int)0, (int)2);
        for (MatOfPoint contour : contours) {
            Imgproc.drawContours((Mat)mat, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)-1);
        }
        images[3] = new Img(mat, false).toJfxImage();
        Mat gradient = new Mat();
        Imgproc.morphologyEx((Mat)mat, (Mat)gradient, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(4.0, 4.0)));
        images[4] = new Img(gradient, false).toJfxImage();
        Mat smallLines = new Mat();
        Mat bigLines = new Mat();
        Imgproc.HoughLinesP((Mat)gradient, (Mat)bigLines, (double)1.0, (double)(Math.PI / 180), (int)10, (double)30.0, (double)10.0);
        Imgproc.HoughLinesP((Mat)gradient, (Mat)smallLines, (double)1.0, (double)(Math.PI / 180), (int)10, (double)30.0, (double)10.0);
        Lines slines = new Lines(smallLines);
        Lines blines = new Lines(bigLines);
        Mat result = Mat.zeros((Size)this.frame.getSrc().size(), (int)this.frame.getSrc().type());
        Lines horizontalLines = new Lines(blines.getLines().stream().filter(l -> Math.abs(l.y2 - l.y1) < Math.abs(l.x2 - l.x1)).collect(Collectors.toList()));
        horizontalLines.draw(result, new Scalar(0.0, 255.0, 0.0), 2);
        Lines verticalLines = new Lines(slines.getLines().stream().filter(l -> Math.abs(l.y2 - l.y1) > Math.abs(l.x2 - l.x1)).collect(Collectors.toList()));
        verticalLines.draw(result, new Scalar(0.0, 0.0, 255.0), 2);
        images[5] = new Img(result, false).toJfxImage();
        horizontalLines.draw(mat, new Scalar(255.0), 2);
        verticalLines.draw(mat, new Scalar(255.0), 2);
        ref = this.trace("Draw lines", ref);
        Imgproc.findContours((Mat)mat, contours, (Mat)new Mat(), (int)0, (int)2);
        for (MatOfPoint contour : contours) {
            Imgproc.drawContours((Mat)mat, Arrays.asList(contour), (int)0, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)-1);
        }
        images[6] = new Img(mat, false).toJfxImage();
        Imgproc.morphologyEx((Mat)mat, (Mat)gradient, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(3.0, 3.0)));
        images[7] = new Img(gradient, false).toJfxImage();
        Imgproc.HoughLinesP((Mat)gradient, (Mat)bigLines, (double)1.0, (double)(Math.PI / 180), (int)100, (double)300.0, (double)50.0);
        Imgproc.HoughLinesP((Mat)gradient, (Mat)smallLines, (double)1.0, (double)(Math.PI / 180), (int)25, (double)40.0, (double)13.0);
        slines = new Lines(smallLines);
        blines = new Lines(bigLines);
        result = Mat.zeros((Size)this.frame.getSrc().size(), (int)this.frame.getSrc().type());
        horizontalLines = new Lines(blines.getLines().stream().filter(l -> Math.abs(l.y2 - l.y1) < Math.abs(l.x2 - l.x1)).collect(Collectors.toList()));
        horizontalLines.draw(result, new Scalar(0.0, 255.0, 0.0), 2);
        verticalLines = new Lines(slines.getLines().stream().filter(l -> Math.abs(l.y2 - l.y1) > Math.abs(l.x2 - l.x1)).collect(Collectors.toList()));
        verticalLines.draw(result, new Scalar(0.0, 0.0, 255.0), 2);
        images[8] = new Img(result, false).toJfxImage();
        mat.release();
        result.release();
        return images;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

