/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Ransac<DATA> {
    private final List<DATA> datas;
    private final int n;
    private final int k;
    private Model<DATA> bestModel;
    private Map<Integer, DATA> bestDataMap;
    private double bestError = Double.MAX_VALUE;
    private double t;
    private int d;
    private final Function<Collection<DATA>, Model<DATA>> modelProvider;

    public Ransac(List<DATA> datas, Function<Collection<DATA>, Model<DATA>> modelProvider, int n, int k, double t, int d) {
        if (n > datas.size()) {
            throw new IllegalStateException("n parameter must be inferior or equal to data size");
        }
        if (d > datas.size()) {
            throw new IllegalStateException("d parameter must be inferior or equal to data size");
        }
        if (n > d) {
            throw new IllegalStateException("d parameter must be superior or equal to n parameter");
        }
        assert (n < datas.size());
        assert (n <= d);
        this.datas = datas;
        this.t = t;
        this.n = n;
        this.k = k;
        this.d = d;
        this.modelProvider = modelProvider;
        this.compute();
    }

    private void compute() {
        for (int i = 0; i < this.k; ++i) {
            double error;
            HashMap<Integer, DATA> randomDataMap = new HashMap<Integer, DATA>();
            int j = 0;
            while (j < this.n) {
                int random = Double.valueOf(Math.floor(Math.random() * (double)this.datas.size())).intValue();
                if (randomDataMap.put(random, this.datas.get(random)) != null) continue;
                ++j;
            }
            Model<DATA> possibleModel = this.modelProvider.apply(randomDataMap.values());
            for (int pt = 0; pt < this.datas.size(); ++pt) {
                if (randomDataMap.containsKey(pt) || !(possibleModel.computeError(this.datas.get(pt)) < this.t)) continue;
                randomDataMap.put(pt, this.datas.get(pt));
            }
            if (randomDataMap.size() < this.d || !((error = (possibleModel = this.modelProvider.apply(randomDataMap.values())).computeGlobalError(this.datas, randomDataMap.values())) < this.bestError)) continue;
            this.bestModel = possibleModel;
            this.bestDataMap = randomDataMap;
            this.bestError = error;
            if (this.bestError == 0.0) break;
        }
        if (this.bestModel == null) {
            throw new IllegalStateException("Unable to find a good model. Please, check your parameters n = " + this.n + ", t = " + this.t + ", d = " + this.d);
        }
    }

    public Model<DATA> getBestModel() {
        return this.bestModel;
    }

    public double getBestError() {
        return this.bestError;
    }

    public Map<Integer, DATA> getBestDataSet() {
        return this.bestDataMap;
    }

    public static void main(String[] args) {
        Function modelProvider = datas -> {
            double mean = 0.0;
            for (Double data : datas) {
                mean += data.doubleValue();
            }
            final double meanParam = mean /= (double)datas.size();
            return new Model<Double>(){

                @Override
                public double computeError(Double data) {
                    return Math.abs(data - meanParam);
                }

                @Override
                public Object[] getParams() {
                    return new Object[]{meanParam};
                }
            };
        };
        List<Double> datas2 = Arrays.asList(1.0, 1.0, 2.0, 3.0, 1.0, 2.0, 1.0, 1.0);
        Ransac<Double> ransac = new Ransac<Double>(datas2, modelProvider, 4, 100, 0.1, datas2.size() / 2);
        super.compute();
        System.out.println("Result : " + ransac.getBestModel().getParams()[0]);
    }

    public static interface Model<DATA> {
        public double computeError(DATA var1);

        default public double computeGlobalError(List<DATA> datas, Collection<DATA> consensusDatas) {
            double error = 0.0;
            for (DATA data : consensusDatas) {
                error += this.computeError(data);
            }
            return error;
        }

        public Object[] getParams();
    }
}

