/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.invoke.MethodHandles;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.Ocr;
import org.genericsystem.cv.utils.OCRPlasty;
import org.genericsystem.cv.utils.RectToolsMapper;
import org.genericsystem.reinforcer.tools.GSRect;
import org.genericsystem.reinforcer.tools.RectangleTools;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractField {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int MIN_SIZE_CONSOLIDATION = 5;
    private static final int OCR_CONFIDENCE_THRESH = 0;
    @JsonIgnore
    protected GSRect rect;
    protected GSRect ocrRect;
    protected Map<String, Integer> labels;
    @JsonIgnore
    protected String consolidated;
    @JsonIgnore
    protected double confidence;
    @JsonIgnore
    protected long attempts;

    public AbstractField() {
        this(new GSRect());
    }

    public AbstractField(GSRect rect) {
        this.rect = rect;
        this.ocrRect = rect;
        this.labels = new HashMap<String, Integer>();
        this.consolidated = null;
        this.attempts = 0L;
        this.confidence = 0.0;
    }

    void updateRect(GSRect rect) {
        this.rect = rect;
    }

    void updateOcrRect(GSRect rect) {
        this.ocrRect = rect;
    }

    public void setConsolidated(String consolidated) {
        this.consolidated = consolidated;
    }

    public String ocr(Img rootImg) {
        if (rootImg.getSrc().empty() || rootImg.getSrc().width() <= 3 || rootImg.getSrc().height() <= 3) {
            return null;
        }
        if (this.ocrRect.isNearEdge(rootImg.width(), rootImg.height(), 10)) {
            return null;
        }
        Rect rect = new Rect((int)this.getOcrRect().getX(), (int)this.getOcrRect().getY(), (int)this.getOcrRect().getWidth(), (int)this.getOcrRect().getHeight());
        if (rect.empty() || rect.width <= 3 || rect.height <= 3) {
            return null;
        }
        if (0 > rect.x || 0 > rect.y || rect.x + rect.width >= rootImg.getSrc().cols() || rect.y + rect.height >= rootImg.getSrc().rows()) {
            return null;
        }
        Mat roi = new Mat(rootImg.getSrc(), rect);
        String ocr = Ocr.doWork(roi, 0);
        if (!ocr.isEmpty()) {
            this.labels.merge(ocr, 1, Integer::sum);
            ++this.attempts;
        }
        return ocr;
    }

    public void consolidateOcr() {
        int labelsSize = this.getLabelsSize();
        if (labelsSize >= 5) {
            List strings = this.labels.entrySet().stream().collect(ArrayList::new, (list, e) -> IntStream.range(0, (Integer)e.getValue()).forEach(count -> list.add(e.getKey())), List::addAll);
            OCRPlasty.Tuple res = OCRPlasty.correctStringsAndGetOutliers(strings, OCRPlasty.RANSAC.NORM_LEVENSHTEIN);
            this.consolidated = res.getString().orElse(null);
            this.confidence = res.getConfidence();
            if (labelsSize >= 10) {
                res.getOutliers().forEach(outlier -> this.labels.remove(outlier));
            }
        } else {
            logger.trace("Not enough labels to consolidate OCR (current minimum = {})", (Object)5);
            this.consolidated = null;
            this.confidence = 0.0;
        }
    }

    public void drawOcrPerspectiveInverse(Img display, Mat homography, int thickness) {
        Point[] targets = this.getRectPointsWithHomography(homography);
        this.drawRect(display, targets, new Scalar(0.0, 255.0, 0.0), thickness);
        this.drawText(display, targets, new Scalar(0.0, 255.0, 0.0), thickness);
    }

    public void drawRect(Img stabilizedDisplay, Scalar color, int thickness) {
        Point[] points = RectToolsMapper.gsPointToPoint(Arrays.asList(this.rect.decomposeClockwise())).toArray(new Point[0]);
        this.drawRect(stabilizedDisplay, points, color, thickness);
    }

    public void drawRect(Img display, Point[] targets, Scalar color, int thickness) {
        for (int i = 0; i < targets.length; ++i) {
            Imgproc.line((Mat)display.getSrc(), (Point)targets[i], (Point)targets[(i + 1) % targets.length], (Scalar)color, (int)thickness);
        }
    }

    public void drawText(Img display, Scalar color, int thickness) {
        Point[] points = RectToolsMapper.gsPointToPoint(Arrays.asList(this.rect.decomposeClockwise())).toArray(new Point[0]);
        this.drawText(display, points, color, thickness);
    }

    public void drawText(Img display, Point[] targets, Scalar color, int thickness) {
        if (this.consolidated != null) {
            String text = Normalizer.normalize(this.consolidated, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            Point topCenter = new Point((targets[0].x + targets[1].x) / 2.0, (targets[0].y + targets[1].y) / 2.0);
            double l = Math.sqrt(Math.pow(targets[0].x - topCenter.x, 2.0) + Math.pow(targets[0].y - topCenter.y, 2.0));
            Imgproc.line((Mat)display.getSrc(), (Point)new Point(topCenter.x, topCenter.y - 2.0), (Point)new Point(topCenter.x, topCenter.y - 12.0), (Scalar)color, (int)1);
            Imgproc.putText((Mat)display.getSrc(), (String)text, (Point)new Point(topCenter.x - l, topCenter.y - 14.0), (int)4, (double)0.45, (Scalar)color, (int)1);
        }
    }

    public void drawDebugText(Img display, Scalar color, int thickness) {
        Point[] points = RectToolsMapper.gsPointToPoint(Arrays.asList(this.rect.decomposeClockwise())).toArray(new Point[0]);
        this.drawDebugText(display, points, color, thickness);
    }

    public void drawDebugText(Img display, Point[] targets, Scalar color, int thickness) {
        String conf = String.format("%.3f", this.confidence);
        Point topCenter = new Point((targets[0].x + targets[1].x) / 2.0, (targets[0].y + targets[1].y) / 2.0);
        double l = Math.sqrt(Math.pow(targets[0].x - topCenter.x, 2.0) + Math.pow(targets[0].y - topCenter.y, 2.0));
        Imgproc.putText((Mat)display.getSrc(), (String)conf, (Point)new Point(topCenter.x - l, topCenter.y - 12.0), (int)4, (double)0.35, (Scalar)color);
    }

    protected Point[] getRectPointsWithHomography(Mat homography) {
        List<Point> points = RectToolsMapper.gsPointToPoint(Arrays.asList(this.rect.decomposeClockwise()));
        MatOfPoint2f results = new MatOfPoint2f();
        Core.perspectiveTransform((Mat)Converters.vector_Point2f_to_Mat(points), (Mat)results, (Mat)homography);
        return results.toArray();
    }

    public Rect getLargeRect(Img imgRoot, double deltaW, double deltaH) {
        int adjustW = 3 + Double.valueOf(Math.floor(this.rect.getWidth() * deltaW)).intValue();
        int adjustH = 3 + Double.valueOf(Math.floor(this.rect.getHeight() * deltaH)).intValue();
        Point tl = new Point(this.rect.tl().getX() - (double)adjustW > 0.0 ? this.rect.tl().getX() - (double)adjustW : 0.0, this.rect.tl().getY() - (double)adjustH > 0.0 ? this.rect.tl().getY() - (double)adjustH : 0.0);
        Point br = new Point(this.rect.br().getX() + (double)adjustW > (double)imgRoot.width() ? (double)imgRoot.width() : this.rect.br().getX() + (double)adjustW, this.rect.br().getY() + (double)adjustH > (double)imgRoot.height() ? (double)imgRoot.height() : this.rect.br().getY() + (double)adjustH);
        return new Rect(tl, br);
    }

    public boolean isOverlapping(GSRect otherRect) {
        return this.rect.isOverlapping(otherRect);
    }

    public boolean overlapsMoreThanThresh(GSRect otherRect, double overlapThreshold) {
        return this.rect.inclusiveArea(otherRect) > overlapThreshold;
    }

    public boolean isClusteredWith(GSRect otherRect, double epsilon) {
        return RectangleTools.isInCluster((GSRect)this.rect, (GSRect)otherRect, (double)epsilon);
    }

    public boolean isClusteredWith(GSRect otherRect, double epsilon, int sides) {
        return RectangleTools.isInCluster((GSRect)this.rect, (GSRect)otherRect, (double)epsilon, (int)sides);
    }

    public boolean isConsolidated() {
        return this.consolidated != null;
    }

    @JsonIgnore
    public int getLabelsSize() {
        return this.labels.entrySet().stream().mapToInt(entry -> (Integer)entry.getValue()).sum();
    }

    public Map<String, Integer> getLabels() {
        return this.labels;
    }

    public String getConsolidated() {
        return this.consolidated;
    }

    public long getAttempts() {
        return this.attempts;
    }

    public GSRect getRect() {
        return this.rect;
    }

    public GSRect getOcrRect() {
        return this.ocrRect;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String toString() {
        return "AbstractField: \n -> rect: " + this.rect + "\n -> labels size: " + this.getLabelsSize() + "\n -> consolidated: " + this.consolidated + "\n -> confidence: " + this.confidence;
    }
}

