/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.supercontour;

import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

public class SuperContour
implements Comparable<SuperContour> {
    public final MatOfPoint contour;
    public SuperContour succ;
    public SuperContour pred;
    public final Point center;
    public final double angle;
    public final double antiAngle;
    public final Point left;
    public final Point right;
    public final Point top;
    public final Point bottom;
    public final Rect rect;
    public final double lxmin;
    public final double lxmax;
    public final double lymin;
    public final double lymax;
    public final double dx;
    public final double dy;

    public SuperContour(MatOfPoint contour) {
        this.contour = contour;
        this.rect = Imgproc.boundingRect((MatOfPoint)contour);
        Mat dataPts = this.convertContourToMat(contour);
        Mat mean = new Mat();
        Mat eigen = new Mat();
        Core.PCACompute((Mat)dataPts, (Mat)mean, (Mat)eigen);
        Mat project = new Mat();
        Core.PCAProject((Mat)dataPts, (Mat)mean, (Mat)eigen, (Mat)project);
        Mat min = new Mat();
        Core.reduce((Mat)project, (Mat)min, (int)0, (int)3);
        Mat max = new Mat();
        Core.reduce((Mat)project, (Mat)max, (int)0, (int)2);
        this.center = new Point(mean.get(0, 0)[0], mean.get(0, 1)[0]);
        this.lxmin = min.get(0, 0)[0];
        this.lymin = min.get(0, 1)[0];
        this.lxmax = max.get(0, 0)[0];
        this.lymax = max.get(0, 1)[0];
        Point tangent = new Point(eigen.get(0, 0)[0], eigen.get(0, 1)[0]);
        Point antiTangent = new Point(-eigen.get(0, 1)[0], eigen.get(0, 0)[0]);
        this.left = new Point(this.center.x + tangent.x * this.lxmin, this.center.y + tangent.y * this.lxmin);
        this.right = new Point(this.center.x + tangent.x * this.lxmax, this.center.y + tangent.y * this.lxmax);
        this.top = new Point(this.center.x + antiTangent.x * this.lymin, this.center.y + antiTangent.y * this.lymin);
        this.bottom = new Point(this.center.x + antiTangent.x * this.lymax, this.center.y + antiTangent.y * this.lymax);
        this.angle = Math.atan2(tangent.y, tangent.x);
        this.antiAngle = Math.atan2(antiTangent.y, antiTangent.x);
        this.dx = this.lxmax - this.lxmin;
        this.dy = this.lymax - this.lymin;
    }

    Mat convertContourToMat(MatOfPoint contour) {
        Point[] pts = contour.toArray();
        Mat result = new Mat(pts.length, 2, CvType.CV_64FC1);
        for (int i = 0; i < result.rows(); ++i) {
            result.put(i, 0, new double[]{pts[i].x});
            result.put(i, 1, new double[]{pts[i].y});
        }
        return result;
    }

    @Override
    public int compareTo(SuperContour c) {
        int xCompare = Double.compare(this.center.x, c.center.x);
        return xCompare != 0 ? xCompare : Double.compare(this.center.y, c.center.y);
    }
}

