/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import java.util.ArrayList;
import java.util.List;
import org.genericsystem.cv.utils.GPUTools;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Point3;
import org.opencv.core.Scalar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Svd {
    private static final Logger logger = LoggerFactory.getLogger(Svd.class);

    public static List<Point3> solve(List<Point> srcPts, int[][] rects) {
        int i;
        ArrayList<Point3> pts = new ArrayList<Point3>();
        for (Point point : srcPts) {
            pts.add(new Point3(point.x, point.y, 1.0));
        }
        double[] stdxy = new double[]{Math.sqrt(pts.stream().mapToDouble(pt -> pt.x * pt.x).average().getAsDouble()), Math.sqrt(pts.stream().mapToDouble(pt -> pt.y * pt.y).average().getAsDouble())};
        for (Point3 pt2 : pts) {
            pt2.x /= stdxy[0];
            pt2.y /= stdxy[1];
        }
        double d = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (Point3 pt3 : pts) {
            if (pt3.x < d) {
                d = pt3.x;
            }
            if (pt3.y < ymin) {
                ymin = pt3.y;
            }
            if (pt3.x > xmax) {
                xmax = pt3.x;
            }
            if (!(pt3.y > ymax)) continue;
            ymax = pt3.y;
        }
        double meanspan = Math.max(Math.max(Math.abs(d), Math.abs(xmax)), Math.max(Math.abs(ymin), Math.abs(ymax)));
        double lambda = 1.0 / (meanspan * meanspan);
        System.out.println("lambda : " + lambda);
        int n = pts.size();
        int m = rects.length;
        double[] polarity = new double[]{-1.0, 1.0, -1.0, 1.0};
        int nDim = 3;
        System.out.println("n = " + n);
        Mat A = new Mat(nDim * m, 3 * n, CvType.CV_32FC1, new Scalar(0.0));
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < nDim; ++j) {
                int constraint_index = nDim * i2 + j;
                for (int k = 0; k < 4; ++k) {
                    A.put(constraint_index, 3 * rects[i2][k] + j, new double[]{polarity[k]});
                }
            }
        }
        Mat B = new Mat(2 * n, 3 * n, CvType.CV_32FC1, new Scalar(0.0));
        for (int i3 = 0; i3 < n; ++i3) {
            B.put(2 * i3, 3 * i3, new double[]{1.0});
            B.put(2 * i3, 3 * i3 + 2, new double[]{-((Point3)pts.get((int)i3)).x});
            B.put(2 * i3 + 1, 3 * i3 + 1, new double[]{1.0});
            B.put(2 * i3 + 1, 3 * i3 + 2, new double[]{-((Point3)pts.get((int)i3)).y});
        }
        long ref = System.currentTimeMillis();
        Mat dst = GPUTools.gemm(A, A, 1);
        Mat dst2 = GPUTools.gemm(B, B, 1);
        Mat M = GPUTools.addWeighted(dst, 1.0, dst2, lambda, 0.0);
        System.out.println("gemm cuda : " + (System.currentTimeMillis() - ref));
        ref = System.currentTimeMillis();
        Mat eigenValues = new Mat();
        Mat eigenVectors = new Mat();
        Core.eigen((Mat)M, (Mat)eigenValues, (Mat)eigenVectors);
        int minIndex = -1;
        minIndex = eigenValues.rows() - 1;
        Mat result = eigenVectors.row(minIndex);
        System.out.println("Eigen normal : " + (System.currentTimeMillis() - ref));
        double sum = 0.0;
        for (i = 0; i < pts.size(); ++i) {
            sum += result.get(0, 3 * i + 2)[0];
        }
        for (i = 0; i < pts.size(); ++i) {
            ((Point3)pts.get((int)i)).x = sum > 0.0 ? result.get(0, 3 * i)[0] : -result.get(0, 3 * i)[0];
            ((Point3)pts.get((int)i)).y = sum > 0.0 ? result.get(0, 3 * i + 1)[0] : -result.get(0, 3 * i + 1)[0];
            ((Point3)pts.get((int)i)).z = sum > 0.0 ? result.get(0, 3 * i + 2)[0] : -result.get(0, 3 * i + 2)[0];
        }
        for (i = 0; i < pts.size(); ++i) {
            ((Point3)pts.get((int)i)).x *= stdxy[0];
            ((Point3)pts.get((int)i)).y *= stdxy[1];
        }
        return pts;
    }

    static {
        NativeLibraryLoader.load();
    }
}

