/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application.mesh;

import java.util.Collection;
import java.util.HashMap;
import org.genericsystem.cv.application.mesh.Key;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public abstract class AbstractMesh<T> {
    protected final int halfWidth;
    protected final int halfHeight;
    private final HashMap<Key, T[]> internal = new HashMap();

    public AbstractMesh(int halfWidth, int halfHeight) {
        this.halfHeight = halfHeight;
        this.halfWidth = halfWidth;
    }

    public Collection<T[]> values() {
        return this.internal.values();
    }

    protected final void deWarp(Mat src, Mat dewarpedImage, Point[] polygon, double x, double y, double rectWidth, double rectHeight) {
        if (this.inBordedImage(src, polygon)) {
            Point dewarpedTopLeft = new Point(0.0, 0.0);
            Point dewarpedTopRight = new Point(0.0 + rectWidth, 0.0);
            Point dewarpedBottomRight = new Point(0.0 + rectWidth, 0.0 + rectHeight);
            Point dewarpedBottomLeft = new Point(0.0, 0.0 + rectHeight);
            Mat homography = Imgproc.getPerspectiveTransform((Mat)new MatOfPoint2f(polygon), (Mat)new MatOfPoint2f(new Point[]{dewarpedTopLeft, dewarpedTopRight, dewarpedBottomRight, dewarpedBottomLeft}));
            Mat subDewarpedImage = new Mat(dewarpedImage, new Rect(new Point(x, y), new Point(x + rectWidth, y + rectHeight)));
            Imgproc.warpPerspective((Mat)src, (Mat)subDewarpedImage, (Mat)homography, (Size)subDewarpedImage.size(), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
            subDewarpedImage.release();
            homography.release();
        }
    }

    private boolean inBordedImage(Mat img, Point[] pts) {
        for (Point p : pts) {
            if (!(p.x < 0.0 || p.x >= (double)img.width() || p.y < 0.0) && !(p.y >= (double)img.height())) continue;
            return false;
        }
        return true;
    }

    protected void drawPolygon(Mat image, Point[] polygon, Scalar meshColor, Scalar ptsColor) {
        Point topLeft = polygon[0];
        Point topRight = polygon[1];
        Point bottomRight = polygon[2];
        Point bottomLeft = polygon[3];
        Imgproc.circle((Mat)image, (Point)topLeft, (int)3, (Scalar)ptsColor, (int)-1);
        Imgproc.circle((Mat)image, (Point)topRight, (int)3, (Scalar)ptsColor, (int)-1);
        Imgproc.circle((Mat)image, (Point)bottomRight, (int)3, (Scalar)ptsColor, (int)-1);
        Imgproc.circle((Mat)image, (Point)bottomLeft, (int)3, (Scalar)ptsColor, (int)-1);
        Imgproc.line((Mat)image, (Point)topLeft, (Point)topRight, (Scalar)meshColor);
        Imgproc.line((Mat)image, (Point)topRight, (Point)bottomRight, (Scalar)meshColor);
        Imgproc.line((Mat)image, (Point)bottomRight, (Point)bottomLeft, (Scalar)meshColor);
        Imgproc.line((Mat)image, (Point)bottomLeft, (Point)topLeft, (Scalar)meshColor);
    }

    public final void put(int i, int j, T ... points) {
        this.internal.put(new Key(i, j), points);
    }

    public final T[] get(int i, int j) {
        return this.internal.get(new Key(i, j));
    }

    public int getHalfWidth() {
        return this.halfWidth;
    }

    public int getHalfHeight() {
        return this.halfHeight;
    }
}

