/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import org.genericsystem.cv.Img;
import org.genericsystem.cv.PdfToPngConverter;
import org.opencv.core.Size;

public interface GSCapture {
    public static final Size HD = new Size(1280.0, 720.0);
    public static final Size VGA = new Size(640.0, 360.0);

    public Img read();

    public void release();

    public Size getResize();

    public static class GSPhotoCapture
    implements GSCapture {
        private final Img img;

        public GSPhotoCapture(String url) {
            Img img = url.endsWith(".pdf") ? PdfToPngConverter.imgFromPdf(url, 0) : new Img(url);
            double coeff = Math.min(GSPhotoCapture.VGA.width / (double)img.width(), GSPhotoCapture.VGA.height / (double)img.height());
            this.img = img.resize(new Size(coeff * (double)img.width(), coeff * (double)img.height()));
        }

        @Override
        public Img read() {
            return this.img;
        }

        @Override
        public void release() {
            this.img.getSrc().release();
        }

        @Override
        public Size getResize() {
            return this.img.size();
        }
    }
}

