/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.util.Arrays;
import org.opencv.core.Mat;

public class Matrix {
    private int m;
    private int n;
    private double[][] A;

    public Matrix(int i, int j) {
        this.m = i;
        this.n = j;
        this.A = new double[i][j];
    }

    public Matrix(double[][] arrayDouble) {
        this.A = arrayDouble;
        this.n = arrayDouble[0].length;
        this.m = arrayDouble.length;
    }

    public Matrix() {
    }

    public Matrix(double[] array) {
        this.A = new double[][]{{array[0]}, {array[1]}, {array[2]}};
        this.n = 1;
        this.m = array.length;
    }

    public void set(int i, int j, double value) {
        this.A[i][j] = value;
    }

    public Matrix times(Matrix matrix, double alpha) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix is null");
        }
        if (this.n != matrix.getm()) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree. (" + this.m + "," + this.n + ") vs (" + matrix.getm() + "," + matrix.getn() + ")");
        }
        Matrix localMatrix = new Matrix(this.m, matrix.getn());
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < matrix.getn(); ++j) {
                double d = 0.0;
                for (int k = 0; k < matrix.getm(); ++k) {
                    d += this.A[i][k] * matrix.get(k, j);
                }
                localMatrix.set(i, j, d * alpha);
            }
        }
        return localMatrix;
    }

    public double[] get(int j) {
        return this.A[j];
    }

    public double get(int i, int j) {
        return this.A[i][j];
    }

    public int getm() {
        return this.m;
    }

    public int getn() {
        return this.n;
    }

    public double[][] getA() {
        return this.A;
    }

    public static Matrix crossProduct(Matrix mat1, Matrix mat2) {
        if (mat1.getm() != 3 && mat2.getm() != 3 && mat1.getn() != 1 && mat2.getn() != 1) {
            throw new IllegalArgumentException("matrix dimension must be (3,1)");
        }
        Matrix array = new Matrix(3, 1);
        array.set(0, 0, mat1.get(1, 0) * mat2.get(2, 0) - mat1.get(2, 0) * mat2.get(1, 0));
        array.set(1, 0, mat1.get(2, 0) * mat2.get(0, 0) - mat1.get(0, 0) * mat2.get(2, 0));
        array.set(2, 0, mat1.get(0, 0) * mat2.get(1, 0) - mat1.get(1, 0) * mat2.get(0, 0));
        return array;
    }

    public Matrix normalize() {
        double d = this.norm();
        if (d == 0.0) {
            throw new IllegalStateException("norm is 0, cannot normalize");
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                this.A[j][i] = this.A[j][i] / d;
            }
        }
        return this;
    }

    public Matrix inv() {
        return Matrix.convert(this.convert().inv());
    }

    public Matrix t() {
        Matrix localMatrix = new Matrix(this.n, this.m);
        double[][] arrayOfDouble = localMatrix.getA();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                arrayOfDouble[j][i] = this.A[i][j];
            }
        }
        return localMatrix;
    }

    public Mat convert() {
        Mat convertedMat = new Mat(this.m, this.n, 6);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                convertedMat.put(i, j, new double[]{this.A[i][j]});
            }
        }
        return convertedMat;
    }

    public static Matrix convert(Mat mat) {
        Matrix matrix = new Matrix(mat.rows(), mat.cols());
        for (int i = 0; i < mat.rows(); ++i) {
            for (int j = 0; j < mat.cols(); ++j) {
                matrix.set(i, j, mat.get(i, j)[0]);
            }
        }
        return matrix;
    }

    public double dot(Matrix matrix) {
        if (this.m != matrix.getm() && this.n != matrix.getn()) {
            throw new IllegalArgumentException("vectors dimensions must be the same");
        }
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                d += this.A[i][j] * matrix.get(i, j);
            }
        }
        return d;
    }

    public double norm() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                d += this.A[j][i] * this.A[j][i];
            }
        }
        return Math.sqrt(d);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix matrix = (Matrix)o;
        for (int i = 0; i < matrix.getm(); ++i) {
            for (int j = 0; j < matrix.getn(); ++j) {
                if (matrix.get(i, j) == this.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                hash += (int)Math.floor(this.get(i, j)) * 7;
            }
        }
        return hash;
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.A);
    }
}

