/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.genericsystem.cv.Classifier;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.Size;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.FeatureDetector;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class ClassifierParametersTest
extends Application {
    private static final String pngDirectoryPath = "png";
    private static final String adjustedDirectoryPath = "adjusted";
    private final double displayWidth = 200.0;

    public static void main(String[] args) {
        ClassifierParametersTest.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        GridPane gridPane = new GridPane();
        List pngImgs = Arrays.stream(new File(pngDirectoryPath).listFiles()).filter(img -> img.getName().endsWith(".png")).collect(Collectors.toList());
        List adjustedImages = Arrays.stream(new File(adjustedDirectoryPath).listFiles()).filter(img -> img.getName().endsWith(".png")).collect(Collectors.toList());
        int row = 0;
        FeatureDetector detector = FeatureDetector.create((int)7);
        DescriptorExtractor extractor = DescriptorExtractor.create((int)1003);
        for (File img1 : pngImgs) {
            System.out.println("================== image : " + img1.getName());
            int column = 0;
            Mat mat1 = Imgcodecs.imread((String)img1.getPath());
            gridPane.add((Node)this.getImageViewFromMat(mat1), column++, row);
            for (File img2 : adjustedImages) {
                Mat mat2 = Imgcodecs.imread((String)img2.getPath());
                gridPane.add((Node)this.getImageViewFromMat(mat2), column++, row);
                Mat result = Classifier.compareFeature(img1.getPath(), img2.getPath(), 50, detector, extractor);
                if (result != null) {
                    gridPane.add((Node)this.getImageViewFromMat(result), column++, row);
                    continue;
                }
                gridPane.add((Node)new Label("Not matching"), column++, row);
            }
            ++row;
        }
        Scene scene = new Scene((Parent)new Group());
        stage.setTitle("Generic System Computer Vision");
        ScrollPane scrollPane = new ScrollPane((Node)gridPane);
        scrollPane.setFitToHeight(true);
        VBox root = new VBox(new Node[]{scrollPane});
        scene.setRoot((Parent)root);
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                try {
                    ClassifierParametersTest.this.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        stage.setScene(scene);
        stage.show();
    }

    private <T> List<List<T>> partition(List<T> elements, BiFunction<T, T, Boolean> equivalent) {
        ArrayList results = new ArrayList();
        elements.forEach(element -> {
            for (List testList : results) {
                if (!((Boolean)equivalent.apply(element, testList.get(0))).booleanValue()) continue;
                testList.add(element);
                return;
            }
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.add(element);
            results.add(newList);
        });
        return results;
    }

    private ImageView getImageViewFromMat(Mat src) {
        Mat target = new Mat();
        Imgproc.resize((Mat)src, (Mat)target, (Size)new Size(200.0, Math.floor(200.0 / (double)src.width() * (double)src.height())));
        MatOfByte buffer = new MatOfByte();
        Imgcodecs.imencode((String)".png", (Mat)target, (MatOfByte)buffer);
        ImageView imageView = new ImageView(new Image((InputStream)new ByteArrayInputStream(buffer.toArray())));
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(200.0);
        return imageView;
    }

    static {
        NativeLibraryLoader.load();
    }
}

