/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.List;
import org.genericsystem.cv.application.Interpolator;
import org.genericsystem.cv.application.SuperContour;

public class SuperContourInterpolator
implements Interpolator {
    private final double pow;
    private List<SuperContour> superContours;
    private double hCoef;
    private double vCoef;
    private double sumHCoefs;
    private double sumVCoefs;
    private double hAngle;
    private double vAngle;

    public SuperContourInterpolator(List<SuperContour> superContours, double pow) {
        this.superContours = superContours;
        this.pow = pow;
    }

    private double squaredEuclidianDistance(double x, double y, SuperContour sc) {
        double minDist;
        double result = Math.pow(x - sc.center.x, 2.0) + Math.pow(y - sc.center.y, 2.0);
        return result >= Math.pow(minDist = 10.0, 2.0) ? result : Math.pow(minDist, 2.0);
    }

    @Override
    public double interpolateHorizontals(double x, double y) {
        double sumHCoefs = 0.0;
        double hAngle = 0.0;
        for (SuperContour op : this.superContours) {
            double geoCoef = Math.pow(1.0 / this.squaredEuclidianDistance(x, y, op), this.pow / 2.0);
            this.hCoef = geoCoef * op.dx;
            hAngle += this.hCoef * op.angle;
            sumHCoefs += this.hCoef;
        }
        return hAngle / sumHCoefs;
    }

    @Override
    public double interpolateVerticals(double x, double y) {
        double vAngle = 0.0;
        double sumVCoefs = 0.0;
        for (SuperContour op : this.superContours) {
            double geoCoef = Math.pow(1.0 / this.squaredEuclidianDistance(x, y, op), this.pow / 2.0);
            this.vCoef = geoCoef * op.dx;
            vAngle += this.vCoef * op.vertical;
            sumVCoefs += this.vCoef;
        }
        return vAngle / sumVCoefs;
    }
}

