/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.MSER;
import org.opencv.imgproc.Imgproc;
import org.opencv.utils.Converters;

public class RobustTextDetector
extends AbstractApp {
    private final double f = 672.5555555555555;
    private final GSCapture gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
    private SuperFrameImg superFrame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        RobustTextDetector.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 30L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth(this.superFrame.width() / displaySizeReduction);
                imageView.setFitHeight(this.superFrame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.superFrame = this.gsCapture.read();
        }
        Image[] images = new Image[8];
        MSER detector = MSER.create((int)3, (int)10, (int)2000, (double)0.25, (double)0.1, (int)100, (double)1.01, (double)0.03, (int)5);
        Img gray = this.superFrame.getFrame().bgr2Gray();
        ArrayList regions = new ArrayList();
        MatOfRect mor = new MatOfRect();
        detector.detectRegions(gray.getSrc(), regions, mor);
        Mat mserMask = new Mat(gray.size(), CvType.CV_8UC1, new Scalar(0.0));
        for (MatOfPoint mop : regions) {
            for (Point p : mop.toList()) {
                mserMask.put((int)p.y, (int)p.x, new double[]{255.0});
            }
        }
        Mat edges = new Mat();
        Imgproc.Canny((Mat)gray.getSrc(), (Mat)edges, (double)20.0, (double)100.0);
        Mat edge_mser_intersection = new Mat();
        Core.bitwise_and((Mat)edges, (Mat)mserMask, (Mat)edge_mser_intersection);
        Mat gradientGrown = RobustTextDetector.growEdges(gray.getSrc(), edge_mser_intersection);
        Mat edgeEnhancedMser = new Mat();
        Mat notGradientGrown = new Mat();
        Core.bitwise_not((Mat)gradientGrown, (Mat)notGradientGrown);
        Core.bitwise_and((Mat)notGradientGrown, (Mat)mserMask, (Mat)edgeEnhancedMser);
        Mat labels = new Mat();
        Mat stats = new Mat();
        Mat centroid = new Mat();
        int labelsIds = Imgproc.connectedComponentsWithStats((Mat)edgeEnhancedMser, (Mat)labels, (Mat)stats, (Mat)centroid, (int)4, (int)4);
        Mat result2 = new Mat(labels.size(), CvType.CV_8UC1, new Scalar(0.0));
        for (int labelId = 0; labelId < labelsIds; ++labelId) {
            double area = stats.get(labelId, 4)[0];
            if (area < 3.0 || area > 600.0) continue;
            Mat labelMask = new Mat();
            Core.inRange((Mat)labels, (Scalar)new Scalar((double)labelId), (Scalar)new Scalar((double)labelId), (Mat)labelMask);
            Core.bitwise_or((Mat)result2, (Mat)labelMask, (Mat)result2);
        }
        Imgproc.distanceTransform((Mat)result2, (Mat)result2, (int)2, (int)3);
        result2.convertTo(result2, CvType.CV_32SC1);
        Mat strokeWidth = RobustTextDetector.computeStrokeWidth(result2);
        Mat filtered_stroke_width = new Mat(strokeWidth.size(), CvType.CV_8UC1, new Scalar(0.0));
        Mat strokeWithCV8U = new Mat();
        strokeWidth.convertTo(strokeWithCV8U, CvType.CV_8UC1);
        labelsIds = Imgproc.connectedComponentsWithStats((Mat)strokeWithCV8U, (Mat)labels, (Mat)stats, (Mat)centroid, (int)4, (int)4);
        for (int labelId = 0; labelId < labelsIds; ++labelId) {
            Mat labelMask = new Mat();
            Core.inRange((Mat)labels, (Scalar)new Scalar((double)labelId), (Scalar)new Scalar((double)labelId), (Mat)labelMask);
            Mat temp = new Mat(strokeWithCV8U.size(), strokeWithCV8U.type(), new Scalar(0.0));
            strokeWithCV8U.copyTo(temp, labelMask);
            int area = Core.countNonZero((Mat)temp);
            MatOfDouble meanD = new MatOfDouble();
            MatOfDouble stdDev = new MatOfDouble();
            Core.meanStdDev((Mat)strokeWithCV8U, (MatOfDouble)meanD, (MatOfDouble)stdDev, (Mat)labelMask);
            if (area == 0 || stdDev.get(0, 0)[0] / meanD.get(0, 0)[0] > 0.5) continue;
            Core.bitwise_or((Mat)filtered_stroke_width, (Mat)labelMask, (Mat)filtered_stroke_width);
        }
        Mat bounding_region = new Mat();
        Imgproc.morphologyEx((Mat)filtered_stroke_width, (Mat)bounding_region, (int)3, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(25.0, 25.0)));
        Imgproc.morphologyEx((Mat)bounding_region, (Mat)bounding_region, (int)2, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(7.0, 7.0)));
        Mat result3 = new Mat();
        this.superFrame.getFrame().getSrc().copyTo(result3, bounding_region);
        images[0] = new Img(result3, false).toJfxImage();
        return images;
    }

    private static int booleansToInt(boolean[] arr) {
        int n = 0;
        for (boolean b : arr) {
            n = n << 1 | (b ? 1 : 0);
        }
        return n;
    }

    private static int getNeighborsLessThan(Mat mat, int y, int x) {
        boolean[] neighbors = new boolean[8];
        boolean bl = mat.get(y, x - 1)[0] == 0.0 ? false : (neighbors[0] = mat.get(y, x - 1)[0] < mat.get(y, x)[0]);
        boolean bl2 = mat.get(y - 1, x - 1)[0] == 0.0 ? false : (neighbors[1] = mat.get(y - 1, x - 1)[0] < mat.get(y, x)[0]);
        boolean bl3 = mat.get(y - 1, x)[0] == 0.0 ? false : (neighbors[2] = mat.get(y - 1, x)[0] < mat.get(y, x)[0]);
        boolean bl4 = mat.get(y - 1, x + 1)[0] == 0.0 ? false : (neighbors[3] = mat.get(y - 1, x + 1)[0] < mat.get(y, x)[0]);
        boolean bl5 = mat.get(y, x + 1)[0] == 0.0 ? false : (neighbors[4] = mat.get(y, x + 1)[0] < mat.get(y, x)[0]);
        boolean bl6 = mat.get(y + 1, x + 1)[0] == 0.0 ? false : (neighbors[5] = mat.get(y + 1, x + 1)[0] < mat.get(y, x)[0]);
        boolean bl7 = mat.get(y + 1, x)[0] == 0.0 ? false : (neighbors[6] = mat.get(y + 1, x)[0] < mat.get(y, x)[0]);
        neighbors[7] = mat.get(y + 1, x - 1)[0] == 0.0 ? false : mat.get(y + 1, x - 1)[0] < mat.get(y, x)[0];
        return RobustTextDetector.booleansToInt(neighbors);
    }

    private static Mat computeStrokeWidth(Mat dist) {
        Mat padded = new Mat(dist.rows() + 1, dist.cols() + 1, dist.type(), new Scalar(0.0));
        dist.copyTo(new Mat(padded, new Rect(1, 1, dist.cols(), dist.rows())));
        Mat lookup = new Mat(padded.size(), CvType.CV_8UC1, new Scalar(0.0));
        for (int y = 1; y < padded.rows() - 1; ++y) {
            for (int x = 1; x < padded.cols() - 1; ++x) {
                if (padded.get(y, x)[0] == 0.0) continue;
                lookup.put(y, x, new double[]{RobustTextDetector.getNeighborsLessThan(padded, y, x)});
            }
        }
        Core.MinMaxLocResult minMaxLocResult = Core.minMaxLoc((Mat)padded);
        int maxStroke = (int)Math.round(minMaxLocResult.maxVal);
        for (double stroke = (double)maxStroke; stroke > 0.0; stroke -= 1.0) {
            Mat stroke_indices_mat = new Mat();
            Mat mask = new Mat();
            Core.inRange((Mat)padded, (Scalar)new Scalar(stroke - 0.1), (Scalar)new Scalar(stroke + 0.1), (Mat)mask);
            Mat masked = new Mat();
            padded.copyTo(masked, mask);
            masked.convertTo(masked, CvType.CV_8UC1);
            Core.findNonZero((Mat)masked, (Mat)stroke_indices_mat);
            ArrayList stroke_indices = new ArrayList();
            if (stroke_indices_mat.cols() > 0) {
                Converters.Mat_to_vector_Point((Mat)stroke_indices_mat, stroke_indices);
            }
            ArrayList<Point> neighbors = new ArrayList<Point>();
            for (Point stroke_index : stroke_indices) {
                List<Point> temp = RobustTextDetector.convertToCoords((int)stroke_index.x, (int)stroke_index.y, (int)lookup.get((int)stroke_index.y, (int)stroke_index.x)[0]);
                neighbors.addAll(temp);
            }
            while (!neighbors.isEmpty()) {
                for (Point neighbor : neighbors) {
                    padded.put((int)neighbor.y, (int)neighbor.x, new double[]{stroke});
                }
                neighbors.clear();
                ArrayList temp = new ArrayList(neighbors);
                neighbors.clear();
                for (Point neighbor : temp) {
                    List<Point> temp2 = RobustTextDetector.convertToCoords((int)neighbor.x, (int)neighbor.y, (int)lookup.get((int)neighbor.y, (int)neighbor.x)[0]);
                    neighbors.addAll(temp2);
                }
            }
        }
        return new Mat(padded, new Rect(1, 1, dist.cols(), dist.rows()));
    }

    private static List<Point> convertToCoords(int x, int y, int neighbors) {
        ArrayList<Point> coords = new ArrayList<Point>();
        if ((neighbors & (int)Math.pow(2.0, 7.0)) != 0) {
            coords.add(new Point((double)(x - 1), (double)y));
        }
        if ((neighbors & (int)Math.pow(2.0, 6.0)) != 0) {
            coords.add(new Point((double)(x - 1), (double)(y - 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 5.0)) != 0) {
            coords.add(new Point((double)x, (double)(y - 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 4.0)) != 0) {
            coords.add(new Point((double)(x + 1), (double)(y - 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 3.0)) != 0) {
            coords.add(new Point((double)(x + 1), (double)y));
        }
        if ((neighbors & (int)Math.pow(2.0, 2.0)) != 0) {
            coords.add(new Point((double)(x + 1), (double)(y + 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 1.0)) != 0) {
            coords.add(new Point((double)x, (double)(y + 1)));
        }
        if ((neighbors & (int)Math.pow(2.0, 0.0)) != 0) {
            coords.add(new Point((double)(x - 1), (double)(y + 1)));
        }
        return coords;
    }

    public static int toBin(double angle, int neighbors) {
        float divisor = 180.0f / (float)neighbors;
        return (int)((Math.floor(angle / (double)divisor) - 1.0) / 2.0 + 1.0) % neighbors + 1;
    }

    public static Mat growEdges(Mat image, Mat edges) {
        Mat grad_x = new Mat();
        Mat grad_y = new Mat();
        Imgproc.Sobel((Mat)image, (Mat)grad_x, (int)CvType.CV_64FC1, (int)1, (int)0);
        Imgproc.Sobel((Mat)image, (Mat)grad_y, (int)CvType.CV_64FC1, (int)0, (int)1);
        Core.subtract((Mat)Mat.zeros((Size)image.size(), (int)CvType.CV_64FC1), (Mat)grad_x, (Mat)grad_x);
        Mat grad_mag = new Mat();
        Mat grad_dir = new Mat();
        Core.cartToPolar((Mat)grad_x, (Mat)grad_y, (Mat)grad_mag, (Mat)grad_dir, (boolean)true);
        for (int y = 0; y < grad_dir.rows(); ++y) {
            for (int x = 0; x < grad_dir.cols(); ++x) {
                grad_dir.put(y, x, new double[]{RobustTextDetector.toBin(grad_dir.get(y, x)[0], 8)});
            }
        }
        grad_dir.convertTo(grad_dir, CvType.CV_8UC1);
        Mat result = new Mat();
        edges.copyTo(result);
        for (int y = 1; y < edges.rows() - 1; ++y) {
            block13: for (int x = 1; x < edges.cols() - 1; ++x) {
                if (edges.get(y, x)[0] == 0.0) continue;
                switch ((int)grad_dir.get(y, x)[0]) {
                    case 1: {
                        result.put(y, x - 1, new double[]{255.0});
                        continue block13;
                    }
                    case 2: {
                        result.put(y - 1, x - 1, new double[]{255.0});
                        continue block13;
                    }
                    case 3: {
                        result.put(y - 1, x, new double[]{255.0});
                        continue block13;
                    }
                    case 4: {
                        result.put(y - 1, x + 1, new double[]{255.0});
                        continue block13;
                    }
                    case 5: {
                        result.put(y, x + 1, new double[]{255.0});
                        continue block13;
                    }
                    case 6: {
                        result.put(y + 1, x + 1, new double[]{255.0});
                        continue block13;
                    }
                    case 7: {
                        result.put(y + 1, x, new double[]{255.0});
                        continue block13;
                    }
                    case 8: {
                        result.put(y + 1, x - 1, new double[]{255.0});
                        continue block13;
                    }
                    default: {
                        System.out.println("Error : " + (int)grad_dir.get(y, x)[0]);
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onT() {
        this.config.textsEnabledMode = !this.config.textsEnabledMode;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

