/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.RadonTransform;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.application.TrajectStep;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class RadonTransformDemo2
extends AbstractApp {
    private final double f = 672.5555555555555;
    private GSCapture gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
    private SuperFrameImg superFrame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        RadonTransformDemo2.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 1000L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth(this.superFrame.width() / displaySizeReduction);
                imageView.setFitHeight(this.superFrame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.superFrame = this.gsCapture.read();
        }
        Image[] images = new Image[9];
        long ref = System.currentTimeMillis();
        Img binarized = this.superFrame.getFrame().adaptativeGaussianInvThreshold(7, 5.0);
        images[0] = binarized.toJfxImage();
        ref = this.trace("Binarization", ref);
        int stripWidth = 72;
        Mat vStrip = RadonTransform.extractStrip(binarized.getSrc(), binarized.width() / 2 - stripWidth / 2, stripWidth);
        Mat vStripDisplay = Mat.zeros((Size)binarized.size(), (int)binarized.type());
        Mat roi = new Mat(vStripDisplay, new Range(0, binarized.height()), new Range(binarized.width() / 2 - stripWidth / 2, binarized.width() / 2 + stripWidth / 2));
        vStrip.copyTo(roi);
        images[1] = new Img(vStripDisplay, false).toJfxImage();
        ref = this.trace("Extract strip", ref);
        Mat houghTransform = RadonTransform.fastHoughTransform(vStrip);
        ref = this.trace("FHT", ref);
        images[3] = new Img(houghTransform, false).toJfxImage();
        System.out.println(houghTransform);
        Imgproc.morphologyEx((Mat)houghTransform, (Mat)houghTransform, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0)));
        images[4] = new Img(houghTransform, false).toJfxImage();
        ref = this.trace("FHT compute", ref);
        TrajectStep[] houghVtraj = RadonTransform.bestTraject(houghTransform, -5000.0, 3.0);
        int stripSize = (houghTransform.width() + 1) / 2;
        for (int y = 0; y < houghVtraj.length; ++y) {
            houghVtraj[y].theta = (int)Math.round(Math.atan((double)(houghVtraj[y].theta - stripSize + 1) / (double)(stripSize - 1)) / Math.PI * 180.0 + 45.0);
        }
        Mat vHoughColor = Mat.zeros((int)(houghTransform.height() - stripWidth), (int)91, (int)CvType.CV_8UC3);
        houghTransform.release();
        for (int y = 0; y < vHoughColor.height(); ++y) {
            vHoughColor.put(y, houghVtraj[y].theta, new double[]{0.0, 0.0, 255.0});
        }
        ref = this.trace("Best traject hough", ref);
        Function<Double, Double> approxHoughVFunction = RadonTransform.approxTraject(houghVtraj);
        for (int y = 0; y < vHoughColor.height(); ++y) {
            int x = (int)Math.round(approxHoughVFunction.apply(Double.valueOf(y)));
            if (x < 0) {
                x = 0;
            }
            if (x >= vHoughColor.width()) {
                x = vHoughColor.width() - 1;
            }
            vHoughColor.put(y, x, new double[]{0.0, 255.0, 0.0});
        }
        ref = this.trace("Display approx hough", ref);
        images[5] = new Img(vHoughColor, false).toJfxImage();
        Mat vTransform = RadonTransform.radonTransform(vStrip, -45, 45);
        Mat vProjection = RadonTransform.radonRemap(vTransform, -45);
        images[6] = new Img(vProjection, false).toJfxImage();
        System.out.println(vProjection);
        Imgproc.morphologyEx((Mat)vProjection, (Mat)vProjection, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0)));
        ref = this.trace("Radon + Projection", ref);
        images[7] = new Img(vProjection, false).toJfxImage();
        TrajectStep[] vtraj = RadonTransform.bestTraject(vProjection, -10000.0, 3.0);
        Mat vProjectionColor = Mat.zeros((Size)vProjection.size(), (int)CvType.CV_8UC3);
        for (int y = 0; y < vProjectionColor.height(); ++y) {
            vProjectionColor.put(y, vtraj[y].theta, new double[]{0.0, 0.0, 255.0});
        }
        ref = this.trace("Best traject radon", ref);
        Function<Double, Double> approxRadonVFunction = RadonTransform.approxTraject(vtraj);
        for (int y = 0; y < vProjectionColor.height(); ++y) {
            int x = (int)Math.round(approxRadonVFunction.apply(Double.valueOf(y)));
            if (x < 0) {
                x = 0;
            }
            if (x >= vProjectionColor.width()) {
                x = vProjectionColor.width() - 1;
            }
            vProjectionColor.put(y, x, new double[]{255.0, 0.0, 0.0});
            x = (int)Math.round(approxHoughVFunction.apply(Double.valueOf(y)));
            if (x < 0) {
                x = 0;
            }
            if (x >= vProjectionColor.width()) {
                x = vProjectionColor.width() - 1;
            }
            vProjectionColor.put(y, x, new double[]{0.0, 255.0, 0.0});
        }
        System.out.println("Radon : " + (vtraj[100].theta - 45));
        System.out.println("Hough : " + (houghVtraj[100].theta - 45));
        ref = this.trace("Display approx radon", ref);
        images[8] = new Img(vProjectionColor, false).toJfxImage();
        return images;
    }

    private long trace(String message, long ref) {
        long last = System.currentTimeMillis();
        System.out.println(message + " : " + (last - ref));
        return last;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onT() {
        this.config.textsEnabledMode = !this.config.textsEnabledMode;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

