/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.GeneralInterpolator;
import org.genericsystem.cv.application.MeshGrid;
import org.genericsystem.cv.application.RadonTransform;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.application.TrajectStep;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class RadonTransformDemo
extends AbstractApp {
    private final double f = 672.5555555555555;
    private GSCapture gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
    private SuperFrameImg superFrame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        RadonTransformDemo.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 3000L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth(this.superFrame.width() / displaySizeReduction);
                imageView.setFitHeight(this.superFrame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        double angle;
        int k;
        int y;
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.superFrame = this.gsCapture.read();
        }
        Image[] images = new Image[9];
        long ref = System.currentTimeMillis();
        Img binarized = this.superFrame.getFrame().adaptativeGaussianInvThreshold(7, 5.0);
        images[0] = binarized.toJfxImage();
        Img transposedBinarized = binarized.transpose();
        ref = this.trace("Binarization", ref);
        int stripWidth = 50;
        List<Mat> vStrips = RadonTransform.extractStrips(binarized.getSrc(), stripWidth);
        int stripHeight = 50;
        List<Mat> hStrips = RadonTransform.extractStrips(transposedBinarized.getSrc(), stripHeight);
        ref = this.trace("Extract strips", ref);
        int minAngle = -45;
        int maxAngle = 45;
        ref = this.trace("Compute radons", ref);
        ref = this.trace("Compute radon remap", ref);
        List vHoughs = vStrips.stream().map(strip -> RadonTransform.fastHoughTransform(strip)).collect(Collectors.toList());
        List hHoughs = hStrips.stream().map(strip -> RadonTransform.fastHoughTransform(strip)).collect(Collectors.toList());
        vHoughs.stream().forEach(projectionMap -> Imgproc.morphologyEx((Mat)projectionMap, (Mat)projectionMap, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0))));
        hHoughs.stream().forEach(projectionMap -> Imgproc.morphologyEx((Mat)projectionMap, (Mat)projectionMap, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0))));
        ref = this.trace("Compute FHT", ref);
        ref = this.trace("Compute FHT remap", ref);
        List vHoughTrajs = vHoughs.stream().map(projectionMap -> RadonTransform.bestTraject(projectionMap, -5000.0, 3.0)).collect(Collectors.toList());
        List hHoughTrajs = hHoughs.stream().map(projectionMap -> RadonTransform.bestTraject(projectionMap, -5000.0, 3.0)).collect(Collectors.toList());
        ref = this.trace("Compute trajects", ref);
        for (TrajectStep[] houghVtraj : vHoughTrajs) {
            for (y = 0; y < houghVtraj.length; ++y) {
                houghVtraj[y].theta = (int)Math.round(Math.atan((double)(houghVtraj[y].theta - stripWidth + 1) / (double)(stripWidth - 1)) / Math.PI * 180.0 + 45.0);
            }
        }
        for (TrajectStep[] houghHtraj : hHoughTrajs) {
            for (y = 0; y < houghHtraj.length; ++y) {
                houghHtraj[y].theta = (int)Math.round(Math.atan((double)(houghHtraj[y].theta - stripHeight + 1) / (double)(stripHeight - 1)) / Math.PI * 180.0 + 45.0);
            }
        }
        ref = this.trace("Transform trajects", ref);
        List approxVFHTFunctions = vHoughTrajs.stream().map(traj -> RadonTransform.approxTraject(traj)).collect(Collectors.toList());
        List approxHFHTFunctions = hHoughTrajs.stream().map(traj -> RadonTransform.approxTraject(traj)).collect(Collectors.toList());
        ref = this.trace("Compute approxs", ref);
        int hStep = stripHeight / 2;
        int vStrip = 0;
        int vStep = stripWidth / 2;
        int hStrip = 0;
        vStrip = 0;
        ArrayList<GeneralInterpolator.OrientedPoint> fhtHorizontals = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (Object f : approxVFHTFunctions) {
            fhtHorizontals.addAll(RadonTransform.toHorizontalOrientedPoints((Function<Double, Double>)f, vStrip++, stripWidth, binarized.height(), hStep, minAngle));
        }
        hStrip = 0;
        ArrayList<GeneralInterpolator.OrientedPoint> fhtVerticals = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (Function f : approxHFHTFunctions) {
            fhtVerticals.addAll(RadonTransform.toVerticalOrientedPoints(f, hStrip++, stripHeight, binarized.width(), vStep, minAngle));
        }
        GeneralInterpolator interpolatorFHT = new GeneralInterpolator(fhtHorizontals, fhtVerticals, 6.0, 20.0);
        ref = this.trace("Prepare interpolator", ref);
        Img frameDisplayFHT = new Img(this.superFrame.getFrame().getSrc().clone(), false);
        vStrip = 0;
        for (Function f : approxVFHTFunctions) {
            k = hStep;
            while (k + hStep <= binarized.height()) {
                angle = ((Double)f.apply(Double.valueOf(k)) - (double)minAngle) / 180.0 * Math.PI;
                Imgproc.line((Mat)frameDisplayFHT.getSrc(), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) - Math.cos(angle) * (double)stripWidth / 6.0, (double)k - Math.sin(angle) * (double)stripWidth / 6.0), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) + Math.cos(angle) * (double)stripWidth / 6.0, (double)k + Math.sin(angle) * (double)stripWidth / 6.0), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)2);
                angle = interpolatorFHT.interpolateHorizontals((vStrip + 1) * stripWidth / 2, k);
                Imgproc.line((Mat)frameDisplayFHT.getSrc(), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) - Math.cos(angle) * (double)stripWidth / 6.0, (double)k - Math.sin(angle) * (double)stripWidth / 6.0), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) + Math.cos(angle) * (double)stripWidth / 6.0, (double)k + Math.sin(angle) * (double)stripWidth / 6.0), (Scalar)new Scalar(255.0, 0.0, 0.0), (int)2);
                k += hStep;
            }
            ++vStrip;
        }
        hStrip = 0;
        for (Function f : approxHFHTFunctions) {
            k = vStep;
            while (k + vStep <= binarized.width()) {
                angle = ((double)(90 + minAngle) - (Double)f.apply(Double.valueOf(k))) / 180.0 * Math.PI;
                Imgproc.line((Mat)frameDisplayFHT.getSrc(), (Point)new Point((double)k - Math.cos(angle) * (double)stripHeight / 6.0, (double)((hStrip + 1) * stripHeight / 2) - Math.sin(angle) * (double)stripHeight / 6.0), (Point)new Point((double)k + Math.cos(angle) * (double)stripHeight / 6.0, (double)((hStrip + 1) * stripHeight / 2) + Math.sin(angle) * (double)stripHeight / 6.0), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)2);
                angle = interpolatorFHT.interpolateVerticals(k, (hStrip + 1) * stripHeight / 2);
                Imgproc.line((Mat)frameDisplayFHT.getSrc(), (Point)new Point((double)k - Math.cos(angle) * (double)stripHeight / 6.0, (double)((hStrip + 1) * stripHeight / 2) - Math.sin(angle) * (double)stripHeight / 6.0), (Point)new Point((double)k + Math.cos(angle) * (double)stripHeight / 6.0, (double)((hStrip + 1) * stripHeight / 2) + Math.sin(angle) * (double)stripHeight / 6.0), (Scalar)new Scalar(255.0, 0.0, 0.0), (int)2);
                k += vStep;
            }
            ++hStrip;
        }
        images[2] = frameDisplayFHT.toJfxImage();
        ref = this.trace("Display lines", ref);
        MeshGrid meshGridFHT = new MeshGrid(new Size(8.0, 5.0), interpolatorFHT, 20.0, 20.0, this.superFrame.getFrame().getSrc());
        meshGridFHT.build();
        ref = this.trace("Build mesh", ref);
        images[5] = new Img(meshGridFHT.drawOnCopy(new Scalar(0.0, 255.0, 0.0)), false).toJfxImage();
        ref = this.trace("Draw mesh", ref);
        Img dewarpFHT = new Img(meshGridFHT.dewarp());
        images[8] = dewarpFHT.toJfxImage();
        ref = this.trace("Dewarp", ref);
        return images;
    }

    private long trace(String message, long ref) {
        long last = System.currentTimeMillis();
        System.out.println(message + " : " + (last - ref));
        return last;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onT() {
        this.config.textsEnabledMode = !this.config.textsEnabledMode;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

