/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.GeneralInterpolator;
import org.genericsystem.cv.application.TrajectStep;
import org.genericsystem.cv.lm.LevenbergImpl;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.ximgproc.Ximgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadonTransform {
    private static final Logger logger;

    public static Mat radonTransform(Mat src, int minAngle, int maxAngle) {
        Mat dst = Mat.zeros((int)src.rows(), (int)src.rows(), (int)CvType.CV_64FC1);
        int center = dst.rows() / 2;
        src.convertTo(new Mat(dst, new Rect(new Point((double)(center - src.cols() / 2), 0.0), new Point((double)(center + src.cols() / 2), (double)src.rows()))), CvType.CV_64FC1);
        Mat radon = Mat.zeros((int)dst.rows(), (int)(-minAngle + maxAngle + 1), (int)CvType.CV_64FC1);
        for (int t = minAngle; t <= maxAngle; ++t) {
            Mat rotated = new Mat();
            Mat rotation = Imgproc.getRotationMatrix2D((Point)new Point((double)center, (double)center), (double)t, (double)1.0);
            Imgproc.warpAffine((Mat)dst, (Mat)rotated, (Mat)rotation, (Size)new Size((double)dst.cols(), (double)dst.rows()), (int)0);
            Core.reduce((Mat)rotated, (Mat)radon.col(t - minAngle), (int)1, (int)0);
            rotated.release();
            rotation.release();
        }
        dst.release();
        Core.normalize((Mat)radon, (Mat)radon, (double)0.0, (double)255.0, (int)32);
        return radon;
    }

    public static Mat radonRemap(Mat radon, int minAngle) {
        Mat projectionMap = Mat.zeros((int)radon.rows(), (int)radon.cols(), (int)CvType.CV_64FC1);
        for (int k = 0; k < projectionMap.rows(); ++k) {
            for (int tetha = 0; tetha < projectionMap.cols(); ++tetha) {
                int p = (int)((double)(k - projectionMap.rows() / 2) * Math.sin(((double)tetha - (double)minAngle) / 180.0 * Math.PI) + (double)(radon.rows() / 2));
                projectionMap.put(k, tetha, new double[]{radon.get(p, tetha)[0]});
            }
        }
        return projectionMap;
    }

    public static Mat fastHoughTransform(Mat vStrip) {
        Mat houghTransform = new Mat();
        Ximgproc.FastHoughTransform((Mat)vStrip, (Mat)houghTransform, (int)CvType.CV_64FC1, (int)5, (int)2, (int)1);
        Core.transpose((Mat)houghTransform, (Mat)houghTransform);
        Core.normalize((Mat)houghTransform, (Mat)houghTransform, (double)0.0, (double)255.0, (int)32);
        return new Mat(houghTransform, new Range(vStrip.width() / 2, houghTransform.height() - vStrip.width() / 2), new Range(0, houghTransform.width()));
    }

    public static Mat fhtRemap(Mat houghTransform) {
        Mat result = Mat.zeros((int)houghTransform.rows(), (int)91, (int)CvType.CV_64FC1);
        for (double col = 0.0; col < (double)houghTransform.width(); col += 0.25) {
            for (int row = 0; row < houghTransform.rows(); ++row) {
                int stripSize = (houghTransform.width() + 1) / 2;
                double angle = Math.round(Math.atan((col - (double)stripSize + 1.0) / (double)(stripSize - 1)) / Math.PI * 180.0 + 45.0);
                if (angle < 0.0 || angle > 90.0) {
                    throw new IllegalStateException("Angle : " + angle);
                }
                result.put(row, (int)angle, new double[]{Math.max(result.get(row, (int)Math.round(angle))[0], houghTransform.get(row, (int)col)[0])});
            }
        }
        return result;
    }

    public static TrajectStep[] bestTraject(Mat projectionMap, double anglePenality, double pow) {
        double[][] score = new double[projectionMap.rows()][projectionMap.cols()];
        int[][] thetaPrev = new int[projectionMap.rows()][projectionMap.cols()];
        for (int theta = 0; theta < projectionMap.cols(); ++theta) {
            score[0][theta] = Math.pow(projectionMap.get(0, theta)[0], pow);
        }
        for (int k = 1; k < projectionMap.rows(); ++k) {
            for (int theta = 0; theta < projectionMap.cols(); ++theta) {
                double magnitude = projectionMap.get(k, theta)[0];
                double scoreFromPrevTheta = theta != 0 ? score[k - 1][theta - 1] : Double.NEGATIVE_INFINITY;
                double scoreFromSameTheta = score[k - 1][theta];
                double scoreFromNextTheta = theta < projectionMap.cols() - 1 ? score[k - 1][theta + 1] : Double.NEGATIVE_INFINITY;
                double bestScore4Pos = -1.0;
                if (scoreFromSameTheta >= scoreFromPrevTheta + anglePenality && scoreFromSameTheta >= scoreFromNextTheta + anglePenality) {
                    bestScore4Pos = scoreFromSameTheta;
                    thetaPrev[k][theta] = theta;
                } else if (scoreFromPrevTheta + anglePenality >= scoreFromSameTheta && scoreFromPrevTheta + anglePenality >= scoreFromNextTheta + anglePenality) {
                    bestScore4Pos = scoreFromPrevTheta + anglePenality;
                    thetaPrev[k][theta] = theta - 1;
                } else {
                    bestScore4Pos = scoreFromNextTheta + anglePenality;
                    thetaPrev[k][theta] = theta + 1;
                }
                score[k][theta] = Math.pow(magnitude, pow) + bestScore4Pos;
            }
        }
        double maxScore = Double.NEGATIVE_INFINITY;
        int prevTheta = -1;
        for (int theta = 0; theta < projectionMap.cols(); ++theta) {
            double lastScore = score[projectionMap.rows() - 1][theta];
            if (!(lastScore > maxScore)) continue;
            maxScore = lastScore;
            prevTheta = theta;
        }
        assert (prevTheta != -1);
        TrajectStep[] thetas = new TrajectStep[projectionMap.rows()];
        for (int k = projectionMap.rows() - 1; k >= 0; --k) {
            thetas[k] = new TrajectStep(k, prevTheta, projectionMap.get(k, prevTheta)[0]);
            prevTheta = thetaPrev[k][prevTheta];
        }
        return thetas;
    }

    public static List<Mat> extractStrips(Mat src, int stripWidth) {
        ArrayList<Mat> strips = new ArrayList<Mat>();
        int col = 0;
        while (col + stripWidth <= src.cols()) {
            strips.add(RadonTransform.extractStrip(src, col, stripWidth));
            col += stripWidth / 2;
        }
        return strips;
    }

    public static Mat extractStrip(Mat src, int startX, int width) {
        return new Mat(src, new Range(0, src.rows()), new Range(startX, startX + width));
    }

    public static List<PolynomialSplineFunction> estimateBaselines(Mat image, double anglePenalty, int minAngle, int maxAngle, double magnitudePow, int yStep) {
        Mat preprocessed = new Img(image, false).adaptativeGaussianInvThreshold(5, 3.0).getSrc();
        ArrayList<PolynomialSplineFunction> hLines = new ArrayList<PolynomialSplineFunction>();
        int n = 20;
        float r = 0.5f;
        double w = (float)image.width() / ((float)n * (1.0f - r) + r);
        double step = (int)((double)(1.0f - r) * w);
        TrajectStep[][] angles = new TrajectStep[n][];
        double[] xs = new double[n + 2];
        BiFunction<Double, double[], Double> f = (y, params) -> params[0] + params[1] * y + params[2] * y * y;
        double[][] approxParams = new double[n][];
        int x = 0;
        for (int i = 0; i < n; ++i) {
            Mat radonTransform = RadonTransform.radonTransform(RadonTransform.extractStrip(preprocessed, x, (int)w), minAngle, maxAngle);
            Mat projMap = RadonTransform.radonRemap(radonTransform, minAngle);
            Imgproc.morphologyEx((Mat)projMap, (Mat)projMap, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(2.0, 4.0)));
            angles[i] = RadonTransform.bestTraject(projMap, anglePenalty, magnitudePow);
            projMap.release();
            radonTransform.release();
            ArrayList<double[]> values = new ArrayList<double[]>();
            for (int k = 0; k < image.height(); ++k) {
                values.add(new double[]{k, angles[i][k].theta, angles[i][k].magnitude});
            }
            approxParams[i] = LevenbergImpl.fromBiFunction(f, values, new double[]{0.0, 0.0, 0.0}).getParams();
            xs[i + 1] = (double)x + 0.5 * w;
            x = (int)((double)x + step);
        }
        xs[n + 1] = image.width() - 1;
        int lines = (image.height() - 1) / yStep + 1;
        logger.info("Image width {}, xs {}, step {}, w {}", new Object[]{image.width(), Arrays.toString(xs), step, w});
        for (int i = 0; i < lines; ++i) {
            double theta;
            int j;
            double[] ys = new double[n + 2];
            ys[n / 2] = (double)(i * yStep) + 0.5 * (double)yStep;
            for (j = n / 2; j <= n; ++j) {
                theta = (f.apply(ys[j], approxParams[j - 1]) + (double)minAngle) / 180.0 * Math.PI;
                if (j == n) {
                    ys[n + 1] = ys[n] + ((double)(image.width() - 1) - xs[j]) * Math.tan(theta);
                    continue;
                }
                ys[j + 1] = ys[j] + step * Math.tan(theta);
            }
            for (j = n / 2; j > 0; --j) {
                theta = (f.apply(ys[j], approxParams[j - 1]) + (double)minAngle) / 180.0 * Math.PI;
                ys[j - 1] = ys[j] - step * Math.tan(theta);
            }
            PolynomialSplineFunction psf = new LinearInterpolator().interpolate(xs, ys);
            hLines.add(psf);
        }
        return hLines;
    }

    public static Function<Double, Double> approxTraject(TrajectStep[] traj) {
        ArrayList<double[]> values = new ArrayList<double[]>();
        for (int k = 0; k < traj.length; ++k) {
            values.add(new double[]{k, traj[k].theta, traj[k].magnitude});
        }
        BiFunction<Double, double[], Double> f = (x, params) -> params[0] + params[1] * x + params[2] * x * x;
        BiFunction<double[], double[], Double> error = (xy, params) -> (Double)f.apply(xy[0], (double[])params) - xy[1];
        double[] params2 = new LevenbergImpl<double[]>(error, values, new double[]{0.0, 0.0, 0.0}).getParams();
        return x -> (Double)f.apply((Double)x, params2);
    }

    public static List<GeneralInterpolator.OrientedPoint> toHorizontalOrientedPoints(Function<Double, Double> f, int vStrip, int stripWidth, int height, int step, int minAngle) {
        ArrayList<GeneralInterpolator.OrientedPoint> orientedPoints = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (int k = 0; k <= height; k += step) {
            double angle = (f.apply(Double.valueOf(k)) + (double)minAngle) / 180.0 * Math.PI;
            orientedPoints.add(new GeneralInterpolator.OrientedPoint(new Point((double)((vStrip + 1) * stripWidth / 2), (double)k), angle, 1.0));
        }
        return orientedPoints;
    }

    public static List<GeneralInterpolator.OrientedPoint> toVerticalOrientedPoints(Function<Double, Double> f, int hStrip, int stripHeight, int width, int step, int minAngle) {
        ArrayList<GeneralInterpolator.OrientedPoint> orientedPoints = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (int k = 0; k <= width; k += step) {
            double angle = ((double)(90 - minAngle) - f.apply(Double.valueOf(k))) / 180.0 * Math.PI;
            orientedPoints.add(new GeneralInterpolator.OrientedPoint(new Point((double)k, (double)((hStrip + 1) * stripHeight / 2)), angle, 1.0));
        }
        return orientedPoints;
    }

    private static boolean inImage(Point p, Mat img) {
        return p.x >= 0.0 && p.y >= 0.0 && p.x < (double)img.width() && p.y < (double)img.height();
    }

    static {
        NativeLibraryLoader.load();
        logger = LoggerFactory.getLogger(RadonTransform.class);
    }
}

