/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.function.Constant;
import org.apache.commons.math3.analysis.function.Identity;
import org.apache.commons.math3.analysis.function.Minus;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.analysis.solvers.BisectionSolver;
import org.genericsystem.cv.Svd;
import org.genericsystem.cv.application.DirectionalFilter;
import org.genericsystem.cv.application.MeshGrid;
import org.genericsystem.cv.application.RadonTransform;
import org.genericsystem.cv.application.VerticalInterpolator;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Point3;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshGridRadon
extends MeshGrid {
    private static final Logger logger = LoggerFactory.getLogger(MeshGridRadon.class);
    private List<Point3> points3D;
    private Map<MeshGrid.Key, Point3[]> mesh3D;
    private final int xStep;
    private final int yStep;
    private final int nVerts;
    private final int nLines;

    public MeshGridRadon(int border, int xStep, int yStep, Mat image) {
        super(image, border, border);
        this.xStep = xStep;
        this.yStep = yStep;
        this.nLines = (image.height() - 1) / yStep + 1;
        this.nVerts = (image.width() - 1) / xStep + 1;
    }

    private int[][] toRectIndices() {
        int[][] rects = new int[this.mesh.size()][4];
        ArrayList meshPoints = new ArrayList(this.mesh.values());
        for (int i = 0; i < rects.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                rects[i][j] = this.points.indexOf(((Point[])meshPoints.get(i))[j]);
            }
        }
        return rects;
    }

    private Map<MeshGrid.Key, Point3[]> toPoint3d() {
        if (this.mesh3D == null) {
            this.points3D = Svd.solve(this.points, this.toRectIndices());
            this.mesh3D = new HashMap<MeshGrid.Key, Point3[]>();
            for (Map.Entry entry : this.mesh.entrySet()) {
                Point3[] para3D = new Point3[4];
                for (int j = 0; j < 4; ++j) {
                    para3D[j] = this.points3D.get(this.points.indexOf(((Point[])entry.getValue())[j]));
                }
                this.mesh3D.put((MeshGrid.Key)entry.getKey(), para3D);
            }
        }
        return this.mesh3D;
    }

    public void build(double anglePenalty, int minAngle, int maxAngle, double magnitudePow) {
        DirectionalFilter df = new DirectionalFilter();
        int firstBin = 1;
        int nBin = 64;
        int nSide = 50;
        int lambda = 7;
        Mat grayFrame = new Mat();
        Imgproc.cvtColor((Mat)this.image, (Mat)grayFrame, (int)6);
        List<Integer> patchXs = df.imgPartition(grayFrame, nSide, 0.5f, false);
        List<Integer> patchYs = df.imgPartition(grayFrame, nSide, 0.5f, true);
        Mat gx = df.gx(grayFrame);
        Core.subtract((Mat)Mat.zeros((Size)gx.size(), (int)gx.type()), (Mat)gx, (Mat)gx);
        Mat gy = df.gy(grayFrame);
        Mat mag = new Mat();
        Mat ori = new Mat();
        Core.cartToPolar((Mat)gx, (Mat)gy, (Mat)mag, (Mat)ori);
        int[][] bin = df.bin(ori, nBin);
        int[][] dirs = df.findSecondDirection(grayFrame, bin, mag, nSide, firstBin, nBin, lambda, patchXs, patchYs);
        VerticalInterpolator interpolator = new VerticalInterpolator(patchXs, patchYs, dirs, nSide, nBin);
        List<PolynomialSplineFunction> hLines = RadonTransform.estimateBaselines(this.image, anglePenalty, minAngle, maxAngle, magnitudePow, this.yStep);
        Point[] prevLine = null;
        double angleTolerance = Math.PI / 180;
        int j = 0;
        int x = 0;
        while (j < this.nVerts) {
            int i;
            Point[] currLine = new Point[this.nLines];
            currLine[0] = new Point((double)x, hLines.get(0).value((double)x));
            for (i = 1; i < this.nLines; ++i) {
                double theta = interpolator.interpolate(currLine[i - 1].x, currLine[i - 1].y);
                Point p = currLine[i - 1];
                PolynomialSplineFunction hLine = hLines.get(i);
                if (Math.abs(theta - 1.5707963267948966) < angleTolerance || Math.abs(theta + 1.5707963267948966) < angleTolerance) {
                    currLine[i] = new Point(p.x, hLine.value((double)x));
                    continue;
                }
                double d = Math.tan(theta);
                UnivariateDifferentiableFunction vLine = FunctionUtils.add((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{new Constant(p.y - p.x * d), FunctionUtils.multiply((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{new Identity(), new Constant(d)})});
                UnivariateDifferentiableFunction f = FunctionUtils.add((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{hLine, FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{new Minus(), vLine})});
                double newX = new BisectionSolver().solve(100, (UnivariateFunction)f, Math.max(p.x - (double)this.xStep, 0.0), Math.min(p.x + (double)this.xStep, (double)(this.image.width() - 1)), p.x);
                currLine[i] = new Point(newX, vLine.value(newX));
            }
            if (j > 0) {
                for (i = 0; i < this.nLines - 1; ++i) {
                    this.mesh.put(new MeshGrid.Key(i, j - 1), new Point[]{prevLine[i], currLine[i], currLine[i + 1], prevLine[i + 1]});
                }
            }
            this.points.addAll(Arrays.asList(currLine));
            prevLine = currLine;
            ++j;
            x += this.xStep;
        }
    }

    public Mat draw3Dsurface(Scalar colorStart, Scalar colorEnd) {
        Map<MeshGrid.Key, Point3[]> mesh3D = this.toPoint3d();
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double zMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        for (Point3 p3 : this.points3D) {
            if (p3.x > xMax) {
                xMax = p3.x;
            }
            if (p3.x < xMin) {
                xMin = p3.x;
            }
            if (p3.y > yMax) {
                yMax = p3.y;
            }
            if (p3.y < yMin) {
                yMin = p3.y;
            }
            if (p3.z > zMax) {
                zMax = p3.z;
            }
            if (!(p3.z < zMin)) continue;
            zMin = p3.z;
        }
        int newWidth = this.image.width();
        int newHeight = (int)Math.ceil((yMax - yMin) * (double)this.image.width() / (xMax - xMin));
        Mat result = new Mat(newHeight, newWidth, CvType.CV_16SC3, new Scalar(0.0, 0.0, 0.0));
        double xMin_ = xMin;
        double xMax_ = xMax;
        double yMin_ = yMin;
        double yMax_ = yMax;
        double zMin_ = zMin;
        double zMax_ = zMax;
        List<Point3> normalizedPoints = this.points3D.stream().map(p -> this.normalize((Point3)p, 0.0, result.width() - 1, 0.0, result.height() - 1, xMin_, xMax_, yMin_, yMax_)).collect(Collectors.toList());
        Map<MeshGrid.Key, Point3[]> normalizedMesh = this.normalize(mesh3D, normalizedPoints);
        normalizedMesh.values().forEach(p -> {
            Point[] p2 = new Point[]{new Point(p[0].x, p[0].y), new Point(p[1].x, p[1].y), new Point(p[2].x, p[2].y), new Point(p[3].x, p[3].y)};
            double lambda = (p[0].z - zMin_) / (zMax_ - zMin_);
            this.drawPolygon(result, p2, this.combine(colorStart, colorEnd, lambda));
        });
        return result;
    }

    private Map<MeshGrid.Key, Point3[]> normalize(Map<MeshGrid.Key, Point3[]> mesh, List<Point3> newPoints) {
        HashMap<MeshGrid.Key, Point3[]> newMesh = new HashMap<MeshGrid.Key, Point3[]>();
        for (Map.Entry<MeshGrid.Key, Point3[]> entry : mesh.entrySet()) {
            newMesh.put(entry.getKey(), this.exchangePoints(entry.getValue(), this.points3D, newPoints));
        }
        return newMesh;
    }

    private Point3[] exchangePoints(Point3[] pts, List<Point3> oldPts, List<Point3> newPts) {
        Point3[] result = new Point3[pts.length];
        for (int i = 0; i < pts.length; ++i) {
            result[i] = newPts.get(oldPts.indexOf(pts[i]));
        }
        return result;
    }

    private Point3 normalize(Point3 p, double xMin, double xMax, double yMin, double yMax, double xMinOrig, double xMaxOrig, double yMinOrig, double yMaxOrig) {
        return new Point3(this.normalize(p.x, xMin, xMax, xMinOrig, xMaxOrig), this.normalize(p.y, yMin, yMax, yMinOrig, yMaxOrig), p.z);
    }

    private double normalize(double x, double xMin, double xMax, double xMinOrig, double xMaxOrig) {
        return (xMax - xMin) * (x - xMinOrig) / (xMaxOrig - xMinOrig) + xMin;
    }

    private Scalar combine(Scalar colorStart, Scalar colorEnd, double lambda) {
        double[] c1 = colorStart.val;
        double[] c2 = colorEnd.val;
        double[] c = new double[c1.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (1.0 - lambda) * c1[i] + lambda * c2[i];
        }
        return new Scalar(c);
    }

    @Override
    public Mat dewarp() {
        int j;
        Point3[] para;
        Map<MeshGrid.Key, Point3[]> mesh3D = this.toPoint3d();
        double[] widths = new double[this.nVerts - 1];
        for (int j2 = 0; j2 < widths.length; ++j2) {
            double sum = 0.0;
            for (int i = 0; i < this.nLines - 1; ++i) {
                para = mesh3D.get(new MeshGrid.Key(i, j2));
                sum += this.euclideanDistance(para[0], para[1]);
            }
            Point3[] para2 = mesh3D.get(new MeshGrid.Key(this.nLines - 2, j2));
            widths[j2] = (sum += this.euclideanDistance(para2[2], para2[3])) / (double)this.nLines;
        }
        double[] heights = new double[this.nLines - 1];
        for (int i = 0; i < heights.length; ++i) {
            double sum = 0.0;
            for (int j3 = 0; j3 < this.nVerts - 1; ++j3) {
                Point3[] para3 = mesh3D.get(new MeshGrid.Key(i, j3));
                sum += this.euclideanDistance(para3[0], para3[3]);
            }
            para = mesh3D.get(new MeshGrid.Key(i, this.nVerts - 2));
            heights[i] = (sum += this.euclideanDistance(para[1], para[2])) / (double)this.nVerts;
        }
        double totalHeight = this.sum(heights, heights.length);
        int i = 0;
        while (i < heights.length) {
            int n = i++;
            heights[n] = heights[n] * ((double)this.image.height() / totalHeight);
        }
        i = 0;
        while (i < widths.length) {
            int n = i++;
            widths[n] = widths[n] * ((double)this.image.width() / totalHeight);
        }
        Mat dewarpedImage = new Mat(this.image.height(), (int)Math.round(this.sum(widths, widths.length)) + 1, CvType.CV_8UC3, new Scalar(255.0, 255.0, 255.0));
        int y = 0;
        for (int i2 = 0; i2 < this.nLines - 1; ++i2) {
            int x = 0;
            for (j = 0; j < this.nVerts - 1; ++j) {
                Rect subImageRect;
                if (this.inImageBorders((Point[])this.mesh.get(new MeshGrid.Key(i2, j))) && !(subImageRect = this.subImageRect(i2, j)).empty()) {
                    Mat homography = this.dewarpPolygon((Point[])this.mesh.get(new MeshGrid.Key(i2, j)), subImageRect, heights[i2], widths[j]);
                    Rect dewarpedRect = new Rect(new Point((double)x, (double)y), new Point((double)x + widths[j], (double)y + heights[i2]));
                    Mat subDewarpedImage = new Mat(dewarpedImage, dewarpedRect);
                    Mat subImage = new Mat(this.image, subImageRect);
                    Imgproc.warpPerspective((Mat)subImage, (Mat)subDewarpedImage, (Mat)homography, (Size)subDewarpedImage.size(), (int)1, (int)1, (Scalar)Scalar.all((double)0.0));
                    subImage.release();
                    subDewarpedImage.release();
                    homography.release();
                }
                x = (int)((double)x + widths[j]);
            }
            y = (int)((double)y + heights[i2]);
        }
        int y2 = 0;
        for (int i3 = 0; i3 < this.nLines - 1; ++i3) {
            Imgproc.line((Mat)dewarpedImage, (Point)new Point(0.0, (double)y2), (Point)new Point((double)(dewarpedImage.width() - 1), (double)y2), (Scalar)new Scalar(255.0, 0.0, 255.0), (int)1);
            y2 = (int)((double)y2 + heights[i3]);
        }
        Imgproc.line((Mat)dewarpedImage, (Point)new Point(0.0, (double)y2), (Point)new Point((double)(dewarpedImage.width() - 1), (double)y2), (Scalar)new Scalar(255.0, 0.0, 255.0), (int)1);
        int x = 0;
        for (j = 0; j < this.nVerts - 1; ++j) {
            Imgproc.line((Mat)dewarpedImage, (Point)new Point((double)x, 0.0), (Point)new Point((double)x, (double)(dewarpedImage.height() - 1)), (Scalar)new Scalar(255.0, 0.0, 255.0), (int)1);
            x = (int)((double)x + widths[j]);
        }
        Imgproc.line((Mat)dewarpedImage, (Point)new Point((double)x, 0.0), (Point)new Point((double)x, (double)(dewarpedImage.height() - 1)), (Scalar)new Scalar(255.0, 0.0, 255.0), (int)1);
        return dewarpedImage;
    }

    private double sum(double[] array, int end) {
        double sum = 0.0;
        for (int i = 0; i < end; ++i) {
            sum += array[i];
        }
        return sum;
    }

    protected boolean inImageBorders(Point[] p) {
        for (Point pt : p) {
            if (this.inImage(pt)) continue;
            return false;
        }
        for (Point pt : p) {
            if (!this.inImageBorders(pt)) continue;
            return true;
        }
        return false;
    }

    private boolean inImage(Point p) {
        return p.x >= 0.0 && p.x < (double)this.image.width() && p.y >= 0.0 && p.y < (double)this.image.height();
    }

    private boolean inImageBorders(Point p) {
        return p.x >= (double)this.xBorder && p.x < (double)(this.image.width() - this.xBorder) && p.y >= (double)this.yBorder && p.y < (double)(this.image.height() - this.yBorder);
    }

    private double euclideanDistance(Point3 p1, Point3 p2) {
        return Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y) + (p2.z - p1.z) * (p2.z - p1.z));
    }
}

