/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectionalFilter
extends AbstractApp {
    private static final Logger logger = LoggerFactory.getLogger(DirectionalFilter.class);
    private final double difScl = 0.7;
    private final int hSz = (int)Math.ceil(2.0999999999999996);
    private final Mat filterGauss = Mat.zeros((int)(2 * this.hSz + 1), (int)1, (int)CvType.CV_64FC1);
    private final Mat filterGaussDerivative = Mat.zeros((int)(2 * this.hSz + 1), (int)1, (int)CvType.CV_64FC1);
    private final Map<Integer, int[]> orientDistances = new HashMap<Integer, int[]>();

    public DirectionalFilter() {
        int i;
        for (i = 0; i < this.filterGauss.rows(); ++i) {
            this.filterGauss.put(i, 0, new double[]{Math.exp(-Math.pow(i - this.hSz, 2.0) / 2.0 / Math.pow(0.7, 2.0)) / 0.7 / Math.sqrt(Math.PI * 2)});
        }
        for (i = 0; i < this.filterGaussDerivative.rows(); ++i) {
            this.filterGaussDerivative.put(i, 0, new double[]{(double)(-(i - this.hSz)) * Math.exp(-Math.pow(i - this.hSz, 2.0) / 2.0 / Math.pow(0.7, 2.0)) / Math.pow(0.7, 3.0) / Math.sqrt(Math.PI * 2)});
        }
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        int firstBin = 1;
        int nBin = 64;
        int nSide = 20;
        int lambda = 7;
        VideoCapture vc = new VideoCapture(0);
        Mat frame = new Mat();
        while (true) {
            vc.read(frame);
            Mat grayFrame = new Mat();
            Imgproc.cvtColor((Mat)frame, (Mat)grayFrame, (int)6);
            Mat gx = this.gx(grayFrame);
            Core.subtract((Mat)Mat.zeros((Size)gx.size(), (int)gx.type()), (Mat)gx, (Mat)gx);
            Mat gy = this.gy(grayFrame);
            Mat mag = new Mat();
            Mat ori = new Mat();
            Core.cartToPolar((Mat)gx, (Mat)gy, (Mat)mag, (Mat)ori);
            int[][] bin = this.bin(ori, nBin);
            double[] histo = this.getHistogram(mag, bin, nBin);
            double maxValue = Double.MIN_VALUE;
            double nbin = Double.MIN_VALUE;
            for (int row = 0; row < histo.length; ++row) {
                double value = histo[row];
                if (!(value > maxValue)) continue;
                maxValue = value;
                nbin = row;
            }
            System.out.println("Result : " + nbin);
            List<Integer> patchXs = this.imgPartition(grayFrame, nSide, 0.5f, false);
            List<Integer> patchYs = this.imgPartition(grayFrame, nSide, 0.5f, true);
            int[][] dirs = this.findSecondDirection(grayFrame, bin, mag, nSide, firstBin, nBin, lambda, patchXs, patchYs);
            Mat imgDirs = this.addDirs(grayFrame, dirs, nSide, nBin, patchXs, patchYs);
            mainGrid.add((Node)new ImageView(Tools.mat2jfxImage(grayFrame)), 0, 0);
            mainGrid.add((Node)new ImageView(Tools.mat2jfxImage(imgDirs)), 1, 0);
            gx.release();
            gy.release();
            mag.release();
            ori.release();
            imgDirs.release();
        }
    }

    public Mat addDirs(Mat img, int[][] dirs, int nSide, int nBin, List<Integer> patchXs, List<Integer> patchYs) {
        Mat imgDirs = new Mat();
        img.copyTo(imgDirs);
        imgDirs.convertTo(imgDirs, CvType.CV_8SC3);
        for (int j = 0; j < patchXs.size(); ++j) {
            for (int i = 0; i < patchYs.size(); ++i) {
                int centerX = patchXs.get(j) + nSide / 2;
                int centerY = patchYs.get(i) + nSide / 2;
                Imgproc.line((Mat)imgDirs, (Point)new Point((double)centerX, (double)centerY), (Point)this.getLineEnd(centerX, centerY, dirs[i][j], nBin, nSide / 3), (Scalar)new Scalar(0.0, 0.0, 0.0), (int)2);
            }
        }
        return imgDirs;
    }

    public Point getLineEnd(int startX, int startY, int dir, int nBin, int length) {
        double step = Math.PI / (double)nBin;
        double theta = ((double)dir - 0.5) * step;
        return new Point((double)startX + (double)length * Math.cos(theta), (double)startY + (double)length * Math.sin(theta));
    }

    public Mat gx(Mat frame) {
        Mat gx = new Mat();
        Imgproc.sepFilter2D((Mat)frame, (Mat)gx, (int)CvType.CV_64FC1, (Mat)this.filterGauss, (Mat)this.filterGaussDerivative, (Point)new Point(-1.0, -1.0), (double)0.0, (int)1);
        return DirectionalFilter.cleanContour(gx);
    }

    public Mat gy(Mat frame) {
        Mat gy = new Mat();
        Imgproc.sepFilter2D((Mat)frame, (Mat)gy, (int)CvType.CV_64FC1, (Mat)this.filterGaussDerivative, (Mat)this.filterGauss, (Point)new Point(-1.0, -1.0), (double)0.0, (int)1);
        return DirectionalFilter.cleanContour(gy);
    }

    public static Mat cleanContour(Mat mat) {
        for (int row = 0; row < mat.rows(); ++row) {
            mat.put(row, 0, new double[]{0.0});
            mat.put(row, mat.cols() - 1, new double[]{0.0});
        }
        for (int col = 0; col < mat.cols(); ++col) {
            mat.put(0, col, new double[]{0.0});
            mat.put(mat.rows() - 1, col, new double[]{0.0});
        }
        return mat;
    }

    public int[][] bin(Mat ori, int nBin) {
        double step = Math.PI / (double)nBin;
        int[][] binning = new int[ori.rows()][ori.cols()];
        for (int r = 0; r < ori.rows(); ++r) {
            for (int c = 0; c < ori.cols(); ++c) {
                int bin;
                double angle = ori.get(r, c)[0] + step / 2.0;
                for (bin = (int)Math.ceil(angle / step); bin > nBin; bin -= nBin) {
                }
                while (bin <= 0) {
                    bin += nBin;
                }
                binning[r][c] = bin;
            }
        }
        return binning;
    }

    public static void main(String[] args) {
        DirectionalFilter.launch((String[])args);
    }

    public double[] getHistogram(Mat mag, int[][] binning, int nBin) {
        double[] histogram = new double[nBin];
        for (int i = 0; i < binning.length; ++i) {
            for (int j = 0; j < binning[0].length; ++j) {
                int n = binning[i][j] - 1;
                histogram[n] = histogram[n] + mag.get(i, j)[0];
            }
        }
        return histogram;
    }

    public double getMeanMag(Mat layer) {
        Mat gx = this.gx(layer);
        Mat gy = this.gy(layer);
        Mat mag = new Mat();
        Mat ori = new Mat();
        Core.cartToPolar((Mat)gx, (Mat)gy, (Mat)mag, (Mat)ori);
        gx.release();
        gy.release();
        Core.pow((Mat)mag, (double)2.0, (Mat)mag);
        double result = Core.mean((Mat)mag).val[0];
        mag.release();
        ori.release();
        return result;
    }

    public Mat scale(Mat img) {
        int maxIndex;
        double scale;
        int nScale = 10;
        double scaleFactor = 0.8;
        Mat[] imgLayers = new Mat[nScale];
        imgLayers[0] = img;
        Double[] meanMags = new Double[nScale];
        for (int i = 0; i < nScale; ++i) {
            meanMags[i] = this.getMeanMag(imgLayers[i]);
            if (i >= nScale - 1) continue;
            imgLayers[i + 1] = new Mat();
            scale = Math.pow(scaleFactor, i + 1);
            Imgproc.resize((Mat)imgLayers[0], (Mat)imgLayers[i + 1], (Size)new Size(0.0, 0.0), (double)scale, (double)scale, (int)2);
        }
        for (maxIndex = 1; !(maxIndex >= meanMags.length - 1 || meanMags[maxIndex] > meanMags[maxIndex - 1] && meanMags[maxIndex] > meanMags[maxIndex + 1]); ++maxIndex) {
        }
        scale = Math.pow(scaleFactor, maxIndex);
        Mat result = new Mat();
        Imgproc.resize((Mat)img, (Mat)result, (Size)new Size(0.0, 0.0), (double)scale, (double)scale, (int)2);
        for (int i = 1; i < imgLayers.length; ++i) {
            imgLayers[i].release();
        }
        return result;
    }

    public int[][] findSecondDirection(Mat img, int[][] binning, Mat mag, int nSide, int firstBin, int nBin, int lambda, List<Integer> patchXs, List<Integer> patchYs) {
        int nXs = patchXs.size();
        int nYs = patchYs.size();
        double[][][] hists = new double[nYs][nXs][nBin];
        for (int i = 0; i < nYs; ++i) {
            Range ySel = new Range(patchYs.get(i).intValue(), patchYs.get(i) + nSide);
            for (int j = 0; j < nXs; ++j) {
                Range xSel = new Range(patchXs.get(j).intValue(), patchXs.get(j) + nSide);
                hists[i][j] = this.getHistogram(new Mat(mag, ySel, xSel), this.subArray(binning, ySel, xSel), nBin);
            }
        }
        ArrayList<int[]> histsIntersectLabels = new ArrayList<int[]>();
        ArrayList<double[]> histsIntersect = new ArrayList<double[]>();
        for (int i1 = 0; i1 < nYs; ++i1) {
            Range ySel1 = new Range(patchYs.get(i1).intValue(), patchYs.get(i1) + nSide);
            for (int i2 = 0; i2 < nYs; ++i2) {
                Range ySel2 = new Range(patchYs.get(i2).intValue(), patchYs.get(i2) + nSide);
                Range ySel = this.intersect(ySel1, ySel2);
                if (ySel.empty()) continue;
                for (int j1 = 0; j1 < nXs; ++j1) {
                    Range xSel1 = new Range(patchXs.get(j1).intValue(), patchXs.get(j1) + nSide);
                    for (int j2 = 0; j2 < nXs; ++j2) {
                        Range xSel2 = new Range(patchXs.get(j2).intValue(), patchXs.get(j2) + nSide);
                        Range xSel = this.intersect(xSel1, xSel2);
                        if (i1 == i2 && j1 == j2 || xSel.empty()) continue;
                        histsIntersectLabels.add(new int[]{i1, j1, i2, j2});
                        histsIntersect.add(this.getHistogram(new Mat(mag, ySel, xSel), this.subArray(binning, ySel, xSel), nBin));
                    }
                }
            }
        }
        int initGuess = nBin / 2;
        int[][] dirs = new int[nYs][nXs];
        for (int i = 0; i < nYs; ++i) {
            for (int j = 0; j < nXs; ++j) {
                dirs[i][j] = initGuess;
            }
        }
        int maxIter = 100;
        double funcVal = Double.MAX_VALUE;
        List[][] indices = new List[nYs][nXs];
        double[][][][] histograms = new double[nYs][nXs][][];
        for (int i = 0; i < nYs; ++i) {
            for (int j = 0; j < nXs; ++j) {
                ArrayList<Integer> localIndices = new ArrayList<Integer>();
                for (int ind = 0; ind < histsIntersectLabels.size(); ++ind) {
                    int[] labels = (int[])histsIntersectLabels.get(ind);
                    assert (0 <= labels[0] && labels[0] < nYs);
                    assert (0 <= labels[1] && labels[1] < nXs);
                    if (labels[0] != i || labels[1] != j) continue;
                    localIndices.add(ind);
                }
                indices[i][j] = localIndices;
                int nNeighbor = localIndices.size();
                double[][] localHistograms = new double[nBin][nNeighbor + 1];
                for (int k = 0; k < nNeighbor; ++k) {
                    int histIndex = (Integer)localIndices.get(k);
                    for (int r = 0; r < nBin; ++r) {
                        localHistograms[r][k] = ((double[])histsIntersect.get(histIndex))[r];
                    }
                    int intersectI = ((int[])histsIntersectLabels.get(histIndex))[2];
                    int intersectJ = ((int[])histsIntersectLabels.get(histIndex))[3];
                    assert (0 <= intersectI && intersectI < nYs);
                    assert (0 <= intersectJ && intersectJ < nXs);
                }
                for (int r = 0; r < nBin; ++r) {
                    localHistograms[r][nNeighbor] = hists[i][j][r];
                }
                histograms[i][j] = localHistograms;
            }
        }
        for (int iter = 0; iter < maxIter; ++iter) {
            double prevFuncVal = funcVal;
            funcVal = this.computeObjective(dirs, mag, binning, firstBin, nBin, patchXs, patchYs, nSide, lambda);
            logger.info("Iteration {}, funcVal = {}.", (Object)iter, (Object)funcVal);
            if (Math.abs(prevFuncVal - funcVal) < Math.pow(10.0, -8.0) * Math.abs(funcVal)) break;
            for (int i = 0; i < nYs; ++i) {
                for (int j = 0; j < nXs; ++j) {
                    int nNeighbor = indices[i][j].size();
                    int[] dirsThis = new int[nNeighbor + 1];
                    for (int k = 0; k < nNeighbor; ++k) {
                        int histIndex = (Integer)indices[i][j].get(k);
                        int intersectI = ((int[])histsIntersectLabels.get(histIndex))[2];
                        int intersectJ = ((int[])histsIntersectLabels.get(histIndex))[3];
                        dirsThis[k] = dirs[intersectI][intersectJ];
                    }
                    double minValue = Double.MAX_VALUE;
                    int minDir = -1;
                    for (int candidateDir = firstBin; candidateDir < nBin + firstBin; ++candidateDir) {
                        dirsThis[dirsThis.length - 1] = candidateDir;
                        double currValue = this.computeObjectiveIJ(histograms[i][j], dirsThis, lambda, firstBin);
                        if (!(currValue < minValue)) continue;
                        minValue = currValue;
                        minDir = candidateDir;
                    }
                    dirs[i][j] = minDir;
                }
            }
        }
        return dirs;
    }

    int[][] subArray(int[][] array, Range rowRange, Range colRange) {
        int[][] result = new int[rowRange.size()][colRange.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Arrays.copyOfRange(array[rowRange.start + i], colRange.start, colRange.end);
        }
        return result;
    }

    public double computeObjectiveIJ(double[][] histograms, int[] dirs, int lambda, int firstBin) {
        int nBin = histograms.length;
        int nHist = histograms[0].length;
        double[] dists = new double[nBin];
        for (int i = 0; i < nHist; ++i) {
            int[] distance = this.orientDistance(dirs[i], firstBin, nBin);
            for (int j = 0; j < nBin; ++j) {
                dists[j] = dists[j] + (double)(distance[j] - lambda) * histograms[j][i];
            }
        }
        double sum = 0.0;
        for (double elt : dists) {
            if (!(elt < 0.0)) continue;
            sum += elt;
        }
        return sum;
    }

    public double computeObjective(int[][] dirs, Mat mag, int[][] binning, int firstBin, int nBin, List<Integer> patchXs, List<Integer> patchYs, int nSide, int lambda) {
        int nXs = patchXs.size();
        int nYs = patchYs.size();
        double[][] dists = new double[mag.rows()][mag.cols()];
        for (int i = 0; i < nXs; ++i) {
            Range xSel = new Range(patchXs.get(i).intValue(), patchXs.get(i) + nSide);
            for (int j = 0; j < nYs; ++j) {
                Range ySel = new Range(patchYs.get(j).intValue(), patchYs.get(j) + nSide);
                int[] distance = this.orientDistance(dirs[j][i], firstBin, nBin);
                for (int k = ySel.start; k < ySel.end; ++k) {
                    for (int l = xSel.start; l < xSel.end; ++l) {
                        double[] dArray = dists[k];
                        int n = l;
                        dArray[n] = dArray[n] + (double)(distance[binning[k][l] - firstBin] - lambda) * mag.get(k, l)[0];
                    }
                }
            }
        }
        double sum = 0.0;
        for (int i = 0; i < dists.length; ++i) {
            for (int j = 0; j < dists[0].length; ++j) {
                sum += dists[i][j] < 0.0 ? dists[i][j] : 0.0;
            }
        }
        return sum;
    }

    public int[] orientDistance(int ind, int firstBin, int nBin) {
        if (!this.orientDistances.containsKey(ind)) {
            int[] distances = new int[nBin];
            for (int i = 0; i < nBin; ++i) {
                distances[i] = this.computeDistance(ind, firstBin + i, nBin);
            }
            this.orientDistances.put(ind, distances);
        }
        return this.orientDistances.get(ind);
    }

    private int computeDistance(int ind, int other, int nBin) {
        return Math.min(Math.min(Math.abs(ind - other), Math.abs(ind - other - nBin)), Math.abs(ind - other + nBin));
    }

    public Range intersect(Range r1, Range r2) {
        int start = Math.max(r1.start, r2.start);
        int end = Math.min(r1.end, r2.end);
        return new Range(start, end);
    }

    public List<Integer> imgPartition(Mat img, int w, float ratio, boolean vertical) {
        int length = vertical ? img.height() : img.width();
        int step = (double)Math.abs(ratio) < Math.pow(10.0, -8.0) ? 1 : (int)Math.floor((float)w * ratio);
        ArrayList<Integer> patches = new ArrayList<Integer>();
        int x = 0;
        do {
            patches.add(x);
        } while ((x += step) <= length - w);
        if (length - w - (Integer)patches.get(patches.size() - 1) > step / 2) {
            patches.add(length - w);
        }
        return patches;
    }

    static {
        NativeLibraryLoader.load();
    }
}

