/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.genericsystem.cv.utils.Tools;
import org.opencv.calib3d.Calib3d;
import org.opencv.core.Core;
import org.opencv.core.DMatch;
import org.opencv.core.KeyPoint;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.DescriptorMatcher;
import org.opencv.features2d.FeatureDetector;
import org.opencv.features2d.Features2d;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamCropper
extends AbstractApp {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final VideoCapture camera = new VideoCapture(0);
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public static void main(String[] args) {
        CamCropper.launch((String[])args);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        FeatureDetector detector = FeatureDetector.create((int)5);
        DescriptorExtractor extractor = DescriptorExtractor.create((int)3);
        DescriptorMatcher matcher = DescriptorMatcher.create((int)4);
        Mat frame = new Mat();
        this.camera.read(frame);
        ImageView src = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src, 0, 0);
        ImageView src2 = new ImageView(Tools.mat2jfxImage(frame));
        mainGrid.add((Node)src2, 1, 0);
        Img[] oldFrame = new Img[]{new Img(frame)};
        MatOfKeyPoint[] oldKeypoints = new MatOfKeyPoint[]{new MatOfKeyPoint()};
        Mat[] oldDescriptors = new Mat[]{new Mat()};
        detector.detect(frame, oldKeypoints[0]);
        extractor.compute(frame, oldKeypoints[0], oldDescriptors[0]);
        this.timer.scheduleAtFixedRate(() -> {
            this.camera.read(frame);
            Img newFrame = new Img(frame, false);
            MatOfKeyPoint newKeypoints = new MatOfKeyPoint();
            Mat newDescriptors = new Mat();
            detector.detect(frame, newKeypoints);
            MatOfDMatch matches = new MatOfDMatch();
            extractor.compute(frame, newKeypoints, newDescriptors);
            matcher.match(oldDescriptors[0], newDescriptors, matches);
            DMatch[] match = matches.toArray();
            ArrayList<DMatch> goodMatches = new ArrayList<DMatch>();
            for (DMatch dMatch : match) {
                double dist = dMatch.distance;
                if (!(dist < 10.0)) continue;
                goodMatches.add(dMatch);
            }
            try {
                Mat imgMatches = new Mat();
                Features2d.drawMatches((Mat)oldFrame[0].getSrc(), (MatOfKeyPoint)oldKeypoints[0], (Mat)newFrame.getSrc(), (MatOfKeyPoint)newKeypoints, (MatOfDMatch)new MatOfDMatch((DMatch[])goodMatches.stream().toArray(DMatch[]::new)), (Mat)imgMatches);
                src.setImage(new Img(imgMatches).toJfxImage());
                ArrayList<Point> goodNewKeypoints = new ArrayList<Point>();
                ArrayList<Point> goodOldKeypoints = new ArrayList<Point>();
                for (DMatch goodMatch : goodMatches) {
                    goodNewKeypoints.add(((KeyPoint)newKeypoints.toList().get((int)goodMatch.trainIdx)).pt);
                    goodOldKeypoints.add(((KeyPoint)oldKeypoints[0].toList().get((int)goodMatch.queryIdx)).pt);
                }
                Mat homography = Calib3d.findHomography((MatOfPoint2f)new MatOfPoint2f((Point[])goodOldKeypoints.stream().toArray(Point[]::new)), (MatOfPoint2f)new MatOfPoint2f((Point[])goodNewKeypoints.stream().toArray(Point[]::new)), (int)8, (double)10.0);
                Mat transformedImage = new Mat();
                Imgproc.warpPerspective((Mat)oldFrame[0].getSrc(), (Mat)transformedImage, (Mat)homography, (Size)new Size((double)newFrame.cols(), (double)newFrame.rows()));
                Core.subtract((Mat)newFrame.getSrc(), (Mat)transformedImage, (Mat)transformedImage);
                src2.setImage(new Img(transformedImage).toJfxImage());
            }
            catch (Exception e) {
                logger.warn("Exception while looking for matches.", (Throwable)e);
            }
            oldFrame[0] = newFrame;
            oldDescriptors[0] = newDescriptors;
            oldKeypoints[0] = newKeypoints;
        }, 0L, 333L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        this.timer.shutdown();
        this.camera.release();
        super.stop();
    }

    public Mat copyOver(Img source, Img destination) {
        Img result_grey = source.bgr2Gray();
        Mat mask = new Mat();
        Imgproc.threshold((Mat)result_grey.getSrc(), (Mat)mask, (double)10.0, (double)255.0, (int)0);
        Mat mask_inv = new Mat();
        Core.bitwise_not((Mat)mask, (Mat)mask_inv);
        Mat roi = new Mat();
        Core.bitwise_and((Mat)source.getSrc(), (Mat)source.getSrc(), (Mat)roi, (Mat)mask);
        Mat im2 = new Mat();
        Core.bitwise_and((Mat)destination.getSrc(), (Mat)destination.getSrc(), (Mat)im2, (Mat)mask_inv);
        Mat result = new Mat();
        Core.add((Mat)im2, (Mat)roi, (Mat)result);
        return result;
    }

    static {
        NativeLibraryLoader.load();
    }
}

