/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.utils;

import java.lang.invoke.MethodHandles;
import org.opencv.core.Core;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static boolean loaded = false;
    private static final String libraryPath = "/usr/local/share/OpenCV/java/libopencv_java330.so";
    private static final String fallbackPath = System.getenv("HOME") + "/opencv/build/lib/libopencv_java330.so";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void load() {
        NativeLibraryLoader.load(libraryPath);
    }

    public static void load(String nativeLibraryPath) {
        if (!loaded) {
            loaded = NativeLibraryLoader.loadFromLibrarypath(nativeLibraryPath);
        } else {
            logger.debug("Native library already loaded.");
        }
    }

    private static boolean loadFromLibrarypath(String nativeLibraryPath) {
        try {
            logger.debug("java.library.path: {}", (Object)System.getProperty("java.library.path"));
            System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            logger.info("Unable to load the library from java.library.path! Using absolute path instead ({})", (Object)nativeLibraryPath);
            return NativeLibraryLoader.loadFromAbsolutePath(nativeLibraryPath);
        }
    }

    private static boolean loadFromAbsolutePath(String nativeLibraryPath) {
        try {
            System.load(nativeLibraryPath);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            logger.info("Unable to load the library from {}. Using fallback path ({})", (Object)nativeLibraryPath, (Object)fallbackPath);
            return NativeLibraryLoader.loadFromAlternatePath();
        }
    }

    private static boolean loadFromAlternatePath() throws RuntimeException {
        try {
            System.load(fallbackPath);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("Unable to load OpenCV native library", e);
        }
    }
}

