/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.retriever;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Stats {
    private static Map<String, List<Long>> cumulativeTimers = new ConcurrentHashMap<String, List<Long>>();
    private static Map<String, Long> cumul = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> timers = new ConcurrentHashMap<String, Long>();
    private static Map<String, List<Long>> stats = new ConcurrentHashMap<String, List<Long>>();

    public static void beginCumulative(String key) {
        cumul.put(key, System.nanoTime());
    }

    public static void endCumulative(String key) {
        long value = cumul.get(key) != null ? System.nanoTime() - cumul.get(key) : 0L;
        List<Long> times = cumulativeTimers.get(key);
        if (times == null) {
            times = new ArrayList<Long>();
        }
        times.add(value);
        cumulativeTimers.put(key, times);
    }

    public static void resetCumulative(String key) {
        List<Long> timers = cumulativeTimers.get(key);
        long total = timers.stream().mapToLong(x -> x).sum();
        cumulativeTimers.put(key, new ArrayList());
        List<Long> times = stats.get(key);
        if (times == null) {
            times = new ArrayList<Long>();
        }
        times.add(total);
        stats.put(key, times);
    }

    public static void beginTask(String key) {
        timers.put(key, System.nanoTime());
    }

    public static void endTask(String key) {
        long value = timers.get(key) != null ? System.nanoTime() - timers.get(key) : 0L;
        List<Long> times = stats.get(key);
        if (times == null) {
            times = new ArrayList<Long>();
        }
        times.add(value);
        stats.put(key, times);
    }

    public static void reset() {
        cumulativeTimers = new ConcurrentHashMap<String, List<Long>>();
        timers = new ConcurrentHashMap<String, Long>();
        stats = new ConcurrentHashMap<String, List<Long>>();
    }

    public static String getStatsAndReset() {
        if (stats.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n").append("###  STATS  ###").append("\n");
        stats.entrySet().forEach(entry -> {
            double average = ((List)entry.getValue()).stream().mapToDouble(l -> l.doubleValue()).average().getAsDouble();
            double sem = Math.sqrt(((List)entry.getValue()).stream().mapToDouble(x -> Math.pow((double)x.longValue() - average, 2.0)).sum() / (double)(((List)entry.getValue()).size() - 1));
            sb.append((String)entry.getKey()).append(": ");
            sb.append(String.format("%.3f", average / 1000000.0));
            sb.append(" \u00b1 ").append(String.format("%.3f", sem / 1000000.0));
            sb.append("ms");
            sb.append("\n");
        });
        sb.append("###  -----  ###").append("\n");
        Stats.reset();
        return sb.toString();
    }
}

