/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cv.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.genericsystem.cv.AbstractApp;
import org.genericsystem.cv.Img;
import org.genericsystem.cv.application.BoundedScheduledThreadPoolExecutor;
import org.genericsystem.cv.application.Config;
import org.genericsystem.cv.application.GSCapture;
import org.genericsystem.cv.application.GSVideoCapture;
import org.genericsystem.cv.application.GeneralInterpolator;
import org.genericsystem.cv.application.MeshGrid;
import org.genericsystem.cv.application.RadonTransform;
import org.genericsystem.cv.application.SuperFrameImg;
import org.genericsystem.cv.utils.NativeLibraryLoader;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class RadonTransformDemo
extends AbstractApp {
    private final double f = 672.5555555555555;
    private GSCapture gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
    private SuperFrameImg superFrame = this.gsCapture.read();
    private ScheduledExecutorService timer = new BoundedScheduledThreadPoolExecutor();
    private Config config = new Config();
    private final ImageView[][] imageViews = new ImageView[][]{new ImageView[3], new ImageView[3], new ImageView[3], new ImageView[3]};

    public static void main(String[] args) {
        RadonTransformDemo.launch((String[])args);
    }

    private void startTimer() {
        this.timer.scheduleAtFixedRate(() -> {
            try {
                Image[] images = this.doWork();
                if (images != null) {
                    Platform.runLater(() -> {
                        Iterator<Image> it = Arrays.asList(images).iterator();
                        for (int row = 0; row < this.imageViews.length; ++row) {
                            for (int col = 0; col < this.imageViews[row].length; ++col) {
                                if (!it.hasNext()) continue;
                                this.imageViews[row][col].setImage(it.next());
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 1000L, 30L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void fillGrid(GridPane mainGrid) {
        double displaySizeReduction = 1.5;
        for (int col = 0; col < this.imageViews.length; ++col) {
            for (int row = 0; row < this.imageViews[col].length; ++row) {
                ImageView imageView;
                this.imageViews[col][row] = imageView = new ImageView();
                mainGrid.add((Node)this.imageViews[col][row], col, row);
                imageView.setFitWidth(this.superFrame.width() / displaySizeReduction);
                imageView.setFitHeight(this.superFrame.height() / displaySizeReduction);
            }
        }
        this.startTimer();
    }

    private Image[] doWork() {
        double angle;
        int k;
        System.out.println("do work");
        if (!this.config.stabilizedMode) {
            this.superFrame = this.gsCapture.read();
        }
        Image[] images = new Image[8];
        long ref = System.currentTimeMillis();
        Img binarized = this.superFrame.getFrame().adaptativeGaussianInvThreshold(7, 5.0);
        images[0] = binarized.toJfxImage();
        Img transposedBinarized = binarized.transpose();
        ref = this.trace("Binarization", ref);
        int stripWidth = 40;
        List<Mat> vStrips = RadonTransform.extractStrips(binarized.getSrc(), stripWidth);
        int stripHeight = 40;
        List<Mat> htrips = RadonTransform.extractStrips(transposedBinarized.getSrc(), stripHeight);
        ref = this.trace("Extract strips", ref);
        List vRadons = vStrips.stream().map(strip -> RadonTransform.transform(strip, 45)).collect(Collectors.toList());
        List hRadons = htrips.stream().map(strip -> RadonTransform.transform(strip, 45)).collect(Collectors.toList());
        ref = this.trace("Compute radons", ref);
        List vProjectionMaps = vRadons.stream().map(radon -> RadonTransform.projectionMap(radon)).collect(Collectors.toList());
        List hProjectionMaps = hRadons.stream().map(radon -> RadonTransform.projectionMap(radon)).collect(Collectors.toList());
        ref = this.trace("Compute projections", ref);
        vProjectionMaps.stream().forEach(projectionMap -> Imgproc.morphologyEx((Mat)projectionMap, (Mat)projectionMap, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0))));
        hProjectionMaps.stream().forEach(projectionMap -> Imgproc.morphologyEx((Mat)projectionMap, (Mat)projectionMap, (int)4, (Mat)Imgproc.getStructuringElement((int)2, (Size)new Size(1.0, 2.0))));
        ref = this.trace("Compute gradients", ref);
        List vTrajs = vProjectionMaps.stream().map(projectionMap -> RadonTransform.bestTraject(projectionMap, -1000.0, 2.0)).collect(Collectors.toList());
        List hTrajs = hProjectionMaps.stream().map(projectionMap -> RadonTransform.bestTraject(projectionMap, -1000.0, 2.0)).collect(Collectors.toList());
        List approxVFunctions = vTrajs.stream().map(traj -> RadonTransform.approxTraject(traj)).collect(Collectors.toList());
        List approxHFunctions = hTrajs.stream().map(traj -> RadonTransform.approxTraject(traj)).collect(Collectors.toList());
        ref = this.trace("Compute approx", ref);
        int hStep = 30;
        int vStrip = 0;
        ArrayList<GeneralInterpolator.OrientedPoint> horizontals = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (Function f : approxVFunctions) {
            horizontals.addAll(RadonTransform.toHorizontalOrientedPoints(f, vStrip, stripWidth, binarized.height(), hStep));
            ++vStrip;
        }
        int vStep = 30;
        int hStrip = 0;
        ArrayList<GeneralInterpolator.OrientedPoint> verticals = new ArrayList<GeneralInterpolator.OrientedPoint>();
        for (Function f : approxHFunctions) {
            verticals.addAll(RadonTransform.toVerticalOrientedPoints(f, hStrip, stripHeight, binarized.width(), vStep));
            ++hStrip;
        }
        GeneralInterpolator interpolator = new GeneralInterpolator(horizontals, verticals, 4.0, 50.0);
        ref = this.trace("Prepare interpolator", ref);
        Img frameDisplay = this.superFrame.getDisplay();
        vStrip = 0;
        for (Function f : approxVFunctions) {
            for (k = hStep; k < binarized.height(); k += hStep) {
                angle = ((Double)f.apply(Double.valueOf(k)) - 45.0) / 180.0 * Math.PI;
                Imgproc.line((Mat)frameDisplay.getSrc(), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) - Math.cos(angle) * (double)stripWidth / 4.0, (double)k - Math.sin(angle) * (double)stripWidth / 4.0), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) + Math.cos(angle) * (double)stripWidth / 4.0, (double)k + Math.sin(angle) * (double)stripWidth / 4.0), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
                angle = interpolator.interpolateHorizontals((vStrip + 1) * stripWidth / 2, k);
                Imgproc.line((Mat)frameDisplay.getSrc(), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) - Math.cos(angle) * (double)stripWidth / 4.0, (double)k - Math.sin(angle) * (double)stripWidth / 4.0), (Point)new Point((double)((vStrip + 1) * stripWidth / 2) + Math.cos(angle) * (double)stripWidth / 4.0, (double)k + Math.sin(angle) * (double)stripWidth / 4.0), (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
            }
            ++vStrip;
        }
        hStrip = 0;
        for (Function f : approxHFunctions) {
            for (k = vStep; k < binarized.width(); k += vStep) {
                angle = (135.0 - (Double)f.apply(Double.valueOf(k))) / 180.0 * Math.PI;
                Imgproc.line((Mat)frameDisplay.getSrc(), (Point)new Point((double)k - Math.cos(angle) * (double)stripHeight / 4.0, (double)((hStrip + 1) * stripHeight / 2) - Math.sin(angle) * (double)stripHeight / 4.0), (Point)new Point((double)k + Math.cos(angle) * (double)stripHeight / 4.0, (double)((hStrip + 1) * stripHeight / 2) + Math.sin(angle) * (double)stripHeight / 4.0), (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
                angle = interpolator.interpolateVerticals(k, (hStrip + 1) * stripHeight / 2);
                Imgproc.line((Mat)frameDisplay.getSrc(), (Point)new Point((double)k - Math.cos(angle) * (double)stripHeight / 4.0, (double)((hStrip + 1) * stripHeight / 2) - Math.sin(angle) * (double)stripHeight / 4.0), (Point)new Point((double)k + Math.cos(angle) * (double)stripHeight / 4.0, (double)((hStrip + 1) * stripHeight / 2) + Math.sin(angle) * (double)stripHeight / 4.0), (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
            }
            ++hStrip;
        }
        images[1] = frameDisplay.toJfxImage();
        ref = this.trace("Display lines", ref);
        MeshGrid meshGrid = new MeshGrid(new Size(16.0, 9.0), interpolator, 20.0, 20.0, this.superFrame.getFrame().getSrc());
        meshGrid.build();
        ref = this.trace("Build mesh", ref);
        images[3] = new Img(meshGrid.drawOnCopy(new Scalar(0.0, 255.0, 0.0)), false).toJfxImage();
        ref = this.trace("Draw mesh", ref);
        Img dewarp = new Img(meshGrid.dewarp()).adaptativeGaussianInvThreshold(7, 3.0);
        images[4] = dewarp.toJfxImage();
        ref = this.trace("Dewarp", ref);
        return images;
    }

    private long trace(String message, long ref) {
        long last = System.currentTimeMillis();
        System.out.println(message + " : " + (last - ref));
        return last;
    }

    @Override
    protected void onS() {
        this.config.stabilizedMode = !this.config.stabilizedMode;
    }

    @Override
    protected void onSpace() {
        if (this.config.isOn) {
            this.timer.shutdown();
            this.gsCapture.release();
        } else {
            this.timer = new BoundedScheduledThreadPoolExecutor();
            this.gsCapture = new GSVideoCapture(0, 672.5555555555555, GSVideoCapture.HD, GSVideoCapture.VGA);
            this.startTimer();
        }
        this.config.isOn = !this.config.isOn;
    }

    @Override
    protected void onT() {
        this.config.textsEnabledMode = !this.config.textsEnabledMode;
    }

    public void stop() throws Exception {
        super.stop();
        this.timer.shutdown();
        this.timer.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.gsCapture.release();
    }

    static {
        NativeLibraryLoader.load();
    }
}

